#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <strstream.h>
#include <iostream.h>
#include "socket.h"
#include "request.h"
#include "sms.h"

const char *HTTP_VER = "1.0";
const int MAX_LINE_LEN = 2048,
          MAX_HEADER_LEN = 16384;

HTTP_Request::HTTP_Request(const char *_host, int _port, const char *_w3_host, int _w3_port)
{
    char buf[128];

    host = strdup(_host);
    if (w3_host = (*_w3_host) ? strdup(_w3_host) : NULL) {
       sprintf(buf, "http://%s", host);
       w3host_prefix = strdup(buf);
    }else w3host_prefix = strdup("");
    port = _port;
    w3_port = _w3_port;
    headers = new Headers();
    body = NULL;
}


HTTP_Request::~HTTP_Request()
{
    delete headers;
    if (body) delete body;
    free(host);
    free(w3host_prefix);
    if (w3_host) free(w3_host);
}

// utworzy odpowiednie gniazdo w zaleznosci czy uzywamy serwera w3cache czy nie
Socket *HTTP_Request::CreateSocket()
{
	char *h;
	int p;

	if (w3_host) { h = w3_host; p = w3_port; }
	else { h = host; p = port; }

    return (*konfig.srcip) ? new AnyIPSocket(h, p, konfig.srcip)
	    		:   new Socket(h, p);
}

Headers *HTTP_Request::GetData(const char *path, int retr_body)
{
    Socket *socket = CreateSocket();
    const char *name, *value;
    int buf_len;

    if (!socket->Ok()) throw new Exception("Nie moge utworzyc gniazdka - GetData()");

    // wypelnianie pol do wyslania do serwera
    socket->WriteMsg("GET %s%s HTTP/%s\n", w3host_prefix, path, HTTP_VER);
    name = headers->FirstHeader(&value);
    while (name) {
         socket->WriteMsg("%s: %s\n", name, value);
         name = headers->NextHeader(&value);
    }
    // wysylamy do serwera
    socket->WriteMsg("\n");

    // teraz odczytujemy rezultaty
    Headers *ret_head = new Headers();
    if (body) delete body;
    body = socket->ReadAll(buf_len);

    debug_stream->Log(LOG_INFO, "Odczytane z serwera (GetData %s): %s", path, body);

    ParseHeaders(*ret_head, body, buf_len);
    if (!retr_body) {
        if (body) delete body;
        body = NULL;
    }
    delete socket;
    return ret_head;
}

Headers *HTTP_Request::PostData(const char *path, Headers &fields)
{
    Socket *socket = CreateSocket();
    const char *name, *value, *form_data;
    char line[MAX_LINE_LEN], *ptr, stream[MAX_HEADER_LEN];

    if (!socket->Ok()) throw new Exception("Nie moge utworzyc gniazdka - PostData()");

    // wypelnianie pol do wyslania do serwera
    sprintf(line, "POST %s%s HTTP/%s\r\n", w3host_prefix, path, HTTP_VER);
    strcpy(stream,line);

    name = headers->FirstHeader(&value);
    while (name) {
         sprintf(line,"%s: %s\r\n", name, value);
         strcat(stream,line);
         name = headers->NextHeader(&value);
    }
    // konwertujemy liste pol na jeden string do wyslania do serwera
    form_data = JoinFormFields(fields);
    // musimy jeszcze wyliczyc dlugosc wysylanych danych (juz po konwersji)
    sprintf(line,"Content-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n",
           strlen(form_data));
    strcat(stream,line);
    sprintf(line,"%s\r\n", form_data);
    strcat(stream,line);

    ptr = stream;
    socket->WriteMsg(ptr);
    debug_stream->Log(LOG_INFO, "Wyslane do serwera (PostData %s): %s", path, ptr);

    // teraz odczytujemy rezultaty
    Headers *ret_head = new Headers();
    int buf_len = MAX_HEADER_LEN;
    if (body) delete body;
    body = (char*)socket->ReadAll(buf_len);
    debug_stream->Log(LOG_INFO, "Odczytane z serwera (PostData %s): %s", path, body);
    ParseHeaders(*ret_head, body, buf_len);


    delete form_data;
    delete socket;
    return ret_head;
}

char *HTTP_Request::str2url(const char *value, char *buf)
{
    const char *c = value;
    char hex[10], *ptr = buf;

    while (*c) {
         if (*c == ' ') *ptr++ = '+'; else
         if (isalnum(*c)) *ptr++ = *c;
         else {
//              sprintf(hex, "%%%X", *c & 0xff);
//              strcpy(ptr, hex);
              *ptr++ = *c;
//              ptr += 3;
         }
         c++;
    } 
    *ptr = '\0';
    return buf;
}

const char *HTTP_Request::JoinFormFields(Headers &fields)
{
    char *buf = new char[MAX_HEADER_LEN], *ret_buf, line[MAX_LINE_LEN] ;
    const char *name, *value;
    
    *buf = '\0'; 
    name = fields.FirstHeader(&value);
    while (name) {
         strcat(buf, str2url(name, line));
         strcat(buf, "=");
         strcat(buf, str2url(value, line));
         name = fields.NextHeader(&value);
         if (name) strcat(buf, "&");
    }

    ret_buf = strdup(buf);
    delete buf;
    return ret_buf; 
}

void HTTP_Request::ParseHeaders(Headers &hd, const char *buf, int buf_len)
{
    // pierwsza linijka zawiera tekst: HTTP/1.1 200 OK
    // ponizej sa wlasciwe naglowki az do pustej linii. poszczegolne linie
    // konczone sa dodatkowo znakiem \r (powrot karetki)

    char *line = new char[MAX_LINE_LEN], *c;
    istrstream is(buf, buf_len);
    
    // najpierw linia ze statusem operacji
    is.getline(line, MAX_LINE_LEN);
//    puts(line);

    // teraz juz petla przez caly naglowek
    is.getline(line, MAX_LINE_LEN);
    while (strlen(line)>2 && line[0] != '\r' && line[0] != '\n') {
         // usuwamy znak powrotu karetki
         if (c = strchr(line, '\r')) *c = 0;

         // szukamy dwukropka - konca nazwy naglowka
         if (c = strchr(line, ':')) {
              *c = 0;
              hd.Add(line,c+2);
         }
         is.getline(line, MAX_LINE_LEN);
    }

    delete line;
}

void HTTP_Request::ReplaceHeader(const char *name, const char *value)
{
    headers->Replace(name, value);
}

void HTTP_Request::AddHeader(const char *name, const char *value)
{
    headers->Add(name, value);
}

const char *HTTP_Request::Header(const char *name)
{
    return headers->Header(name);
}

const char *HTTP_Request::GetBody()
{
    return (body) ? body : "";
}

