/*
 * Copyright (c) 1997-2002 Motonori Nakamura <motonori@media.kyoto-u.ac.jp>
 * Copyright (c) 1997-2002 WIDE Project
 * Copyright (c) 1997-2002 Kyoto University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by WIDE Project and
 *      its contributors.
 * 4. Neither the name of the Project, the University nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: smtp.h,v 1.17 2002/01/20 14:20:42 motonori Exp $
 */

#define CONN_TIMEOUT	70	/* less than normal timeout of connect() */

/* status of SMTP connection */

#define	STAT_CLOSED	0	/* socket closed */
#define	STAT_CONNECTING	1	/* doing connect() */
#define	STAT_CONNECTED	2	/* waiting greeting */
#define	STAT_EHLOSENT	3	/* sending EHLO */
#define	STAT_HELOSENT	4	/* sending HELO */
#define	STAT_MAILSENT	5	/* sending MAIL */
#define	STAT_RCPTSENT	6	/* sending RCPT */
#define	STAT_DATASENT	7	/* sending DATA */
#define	STAT_DATABODY	8	/* sending data body */
#define	STAT_DTERMSENT	9	/* sending DATA termination ('.') */
#define	STAT_SENT	10	/* open and idle after transaction */
#define	STAT_RSETSENT	11	/* sending RSET */
#define	STAT_QUITSENT	12	/* sending QUIT */
#define	STAT_QUITREOPEN	13	/* sending QUIT and need reopen */
#define	STAT_FAILQUIT	14	/* sending QUIT after failure */
#define	STAT_FAIL	15	/* failure/error detected */

#define PROTO_SMTP		0000
#define PROTO_ESMTP		0001
#define PROTO_SIZE		0002
#define PROTO_8BITMIME		0004
#define PROTO_EXPN		0010
#define PROTO_DSN		0020
#define PROTO_PIPELINING	0040

#define IS2xx(r)	((r) >= 200 && (r) < 300)
#define IS3xx(r)	((r) >= 300 && (r) < 400)
#define IS4xx(r)	((r) >= 400 && (r) < 500)
#define IS5xx(r)	((r) >= 500 && (r) < 600)

#define CRLF		"\r\n"

#ifdef ELAST
# define E_SF_IO	(ELAST+1)
# define E_SF_PROTO	(ELAST+2)
# define E_SF_ABORT	(ELAST+3)
#else
# define E_SF_IO	201
# define E_SF_PROTO	202
# define E_SF_ABORT	203
#endif

static struct connection *open_transaction();
static void close_transaction();
static int smtp_connect(), smtp_timeout();
static int smtp_helo_s(), smtp_mail_s(), smtp_data_s();
static int smtp_rset_s(), smtp_quit_s();
static void smtp(), markstatus(), forced_terminate(), dump_internal();
static int new_transaction();
static void process_connection();
static int may_be_reused();
static void trim_rcpts();
static int trim_domain();
static char *smtpstrerror();

