/*
 * This file is part of the sn package.
 * Distribution of sn is covered by the GNU GPL. See file COPYING.
 * Copyright  1998-2000 Harold Tay.
 * Copyright  2000- Patrik Rdman.
 */

/*
 * Check the field name of a header line.
 */

int check_field (char *field, int len)
{
   int i;

   for (i = 0; i < len; i++)
   {
      if (field[i] >= 'a' && field[i] <= 'z')
         continue;
      if (field[i] >= 'A' && field[i] <= 'Z')
         continue;
      if (field[i] >= '0' && field[i] <= '9')
         continue;
      if ('-' == field[i])
         continue;
      if (':' == field[i])
         return (i);
      if (' ' == field[i] || '\t' == field[i])
         break;
      return (0);
   }
   do
      i++;
   while (field[i] == ' ' || field[i] == '\t');
   if (':' != field[i])
      return (0);
   return (i);
}
