/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_AO

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "../other.h"
#include "../output/ao/ao.h"
#include "graphic.h"

void
on_ao_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *combo;
  GtkWidget *entry;

  audio *tmp;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - Audio configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Output Audio:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);

  combo = gtk_combo_box_new_text ();

  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), _("Try..."));
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Oss");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Alsa");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Alsa09");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Esound");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Arts");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Sun");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Null");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Stdout");

  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), 0);

  gtk_table_attach_defaults (GTK_TABLE (table), combo, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Options:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  
  entry = gtk_entry_new();
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 1,2);

  gtk_widget_show_all (box);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      char *ad;

      if (!(tmp = (audio *) malloc (sizeof (audio))))
	fatal (_("Error: memory."));

      ad=(char *)gtk_entry_get_text(GTK_ENTRY(entry));
      if(!ad || !*ad) ad=NULL;
      else ad=g_strdup(ad);

      tmp->realtime = 1;

      tmp->open = ao_init;
      tmp->write = ao_write;
      tmp->close = ao_quit;
      tmp->check = ao_check;
      tmp->info = ao_show;
      tmp->update = NULL;
      tmp->data = NULL;
      tmp->audio_dev = ad;
      tmp->next = NULL;
      tmp->status = OUTPUT_DONE;

      tmp->stop = 0;

      switch (gtk_combo_box_get_active (GTK_COMBO_BOX (combo)))
	{
	case 0:
	  tmp->audio_type = 0;
	  break;
	case 1:
	  tmp->audio_type = USE_OSS;
	  break;
	case 2:
	  tmp->audio_type = USE_ALSA;
	  break;
	case 3:
	  tmp->audio_type = USE_ALSA09;
	  break;
	case 4:
	  tmp->audio_type = USE_ESD;
	  break;
	case 5:
	  tmp->audio_type = USE_ARTS;
	  break;
	case 6:
	  tmp->audio_type = USE_SUN;
	  break;
	case 7:
	  tmp->audio_type = USE_NULL;
	  break;
	case 8:
	  tmp->audio_type = USE_STDOUT;
	  break;
	}

      if (pthread_cond_init (&tmp->cond, NULL))
	fatal (_("Error: Cond init."));
      if (pthread_mutex_init (&tmp->mutex, NULL))
	fatal (_("Error: Mutex init."));
      if (pthread_create (&tmp->th, NULL, output_thread, tmp))
	fatal (_("Thread error."));

      if (play->ao_rate && play->ao_channels && play->ao_bitrate)
	{
	  if (tmp->
	      open (tmp, play->ao_rate, play->ao_channels, play->ao_bitrate))
	    {
	      free (tmp);
	    }
	  else
	    {
	      tmp->info (tmp);

	      output_lock ();

	      tmp->next = play->output;
	      play->output = tmp;

	      output_unlock ();

	      output_list_refresh ();
	    }
	}
      else
	{
	  output_lock ();

	  tmp->next = play->output;
	  play->output = tmp;

	  output_unlock ();

	  output_list_refresh ();
	}
    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
