/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_SNDFILE

#include "../../player.h"
#include "../../output.h"
#include "../../ftime.h"
#include "../../other.h"
#include "../../util.h"

#ifdef ENABLE_GTK
#include "../../gtk/statusbar.h"
#endif

int16_t
sndfile_swap16 (int16_t x)
{
  return ((((u_int16_t) x & 0x00ffU) << 8) |
	  (((u_int16_t) x & 0xff00U) >> 8));
}

void
sndfile_run (void)
{
  char buf[SIZE_BUFFER];
  int16_t *buf16 = (int16_t *) buf;
  int ret;
  int i;
  format_data_sndfile *sndfile =
    (format_data_sndfile *) play->format_current->data;

  if (!sndfile)
    return;

  if (!
      (sndfile->sndfile =
       sf_open (playing_file (), SFM_READ, &sndfile->sfinfo)))
    {
      msg (_("Open file error."));
      return;
    }

  if (sndfile->sfinfo.channels < 1 || sndfile->sfinfo.channels > 2)
    {
      msg (_("No > 2 channels."));
      return;
    }

  msg (_("Play file audio: %s\n"), playing_name ());

  output_open (44100, sndfile->sfinfo.channels, 16);
  output_info ();

  play->play = 1;

  sndfile->start = timer_start ();

  while ((ret = sf_read_raw (sndfile->sndfile, buf, SIZE_BUFFER)))
    {
      if (events.quit || events.skip)
	break;

      if (big_endian ())
	{
	  for (i = 0; i < ret / 2; i++)
	    buf16[i] = sndfile_swap16 (buf16[i]);
	}

      output_write (buf, ret);
    }

  output_close ();
  play->play = 0;

  timer_clear (sndfile->start);
}

char *
sndfile_get_time (void)
{
  format_data_sndfile *sndfile =
    (format_data_sndfile *) play->format_current->data;
  double t;
  long min;
  double s;
  int sec;
  static char str[200];

  if (!sndfile)
    return NULL;

  if (!sndfile->start)
    sndfile->start = timer_start ();

  t = timer_time (sndfile->start);

  min = (long) t / (long) 60;
  s = t - 60.0f * min;

  snprintf (str, 200, "T: %02li:%05.2f", min, s);

  if (sndfile->sfinfo.samplerate < 1)
    return NULL;

  if (sndfile->sfinfo.frames / sndfile->sfinfo.samplerate > 0x7FFFFFFF)
    return NULL;

  sec = sndfile->sfinfo.frames / sndfile->sfinfo.samplerate;
  sec = sec % (60 * 60);

  snprintf (str + strlen (str), 200 - strlen (str), " [%02d:", sec / 60);

  sec = sec % 60;
  snprintf (str + strlen (str), 200 - strlen (str), "%02d.", sec);

  sec = ((1000 * sndfile->sfinfo.frames) / sndfile->sfinfo.samplerate) % 1000;
  snprintf (str + strlen (str), 200 - strlen (str), "%02d]", sec);

  return str;
}

#endif
