/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef SDS_H
#define SDS_H

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <dirent.h>

#define SDS_PORT	12321
#define SDS_LISTEN	100

#define SDS_MONITOR_CONNECT	"MONITOR "
#define SDS_DATA_LIST_CONNECT	"DATA_LIST"
#define SDS_TEST_CONNECT	"TEST"


#ifdef __cplusplus
extern "C"
{
#endif

  typedef struct
  {
    char *server;
  } sds_controller;

  typedef struct sds_client
  {
    char *addr;
    int mute;
    int solo;
    int volume_up;
    int volume_down;
    int balance_up;
    int balance_down;
    int volume;
    int balance;
    int autofader;
    char *socket;

    struct sds_client *next;
  } sds_client;

  int sds_open (char *server);

  /* If you want that sds can admin your input with somaplayer protocol,
   * set the controller like tcp://server or unix://server. Else set 
   * controller to NULL */
  int sds_set (int fd, int rate, int channels, int bitrate, int volume,
	       int balance, int solo, int mute, char *controller);

  int sds_read (int fd, void *data, size_t s);
  int sds_write (int fd, void *data, size_t s);
  int sds_close (int fd);
  int sds_monitor (int fd);
  int sds_test (int fd);

  sds_controller *sds_controller_open (char *server);
  int sds_controller_test (sds_controller * c);
  sds_client *sds_controller_get_list (sds_controller * c);
  //int sds_controller_set_volume(sds_controller *c, int volume);
  //int sds_controller_set_balance(sds_controller *c, int balance);

#ifdef __cplusplus
}
#endif

#endif
