10.1 ショートカットの使用

# ショートカットの使用

Sonic Piはコーディング環境としての楽器です。したがって、あなたが観客の前でライブ演奏している場合は特に、
ショートカットは、はるかに*効率的で自然*にSonicPiの演奏を行うことができます。

Sonic Piの多くの機能は、キーボードを介して制御することができます。
Sonic Piの演奏や作業により慣れるために、ショートカットをもっと使いこなしましょう。

個人的にはブラインドタッチの学習の検討をお勧めします。マウスを使う必要があるときに、動作が遅れ、私はいつもイライラしてしまいます。だから、普段からこれらのショートカットのすべてを使っています！

ショートカットを学べば、効果的にキーボードを使用でき、あなたは、間もなく、プロのようなライブコーディングができるようになるでしょう。

しかし、*一度にすべてを憶えようとしない*で、
まずはあなたが最も使うものを試しながら、実践の中で、さらに追加しながら憶えていくとよいでしょう。

## 一貫したクロスプラットフォーム

クラリネットを習っているところを想像してみてください。すべてのクラリネットは、指使いや操作の全てが一貫してしていることを前提として作られていますが、もしそうでなかったら、別のクラリネットに乗り換えるには大変な時間を費やしてしまうだろうし、一回だけの制作のためにそれを使用することについて戸惑ってしまうでしょう。

残念なことに3つの主要なオペレーティングシステム（ Linux、 Mac OS XおよびWindowsの場合）では、カット＆ペーストなどの操作のために独自の基準が用意されています。
Sonic Piは、これらの基準に準拠します。しかしながらプラットフォームの基準に対応することよりも、
*優先事項として、Sonic Pi内はクロスプラットフォームとして一貫した配置がなされています*。
これは Raspberry Piで演奏したり、ショートカットを学ぶ時、
MacやPCに乗り換えても、違和感無く同じように操作できることを意味しています。

## Control と Meta

一貫性への考え方のひとつにショートカットの命名があります。SonicPiにおいて、主要な2つの組み合わせキーを当てはめるために、*Control キー*と*Metaキー*を用います。すべてのプラットフォームでは、*Control キー*は同じです。しかし、LinuxとWindowsでは、実際の*Metaキー*はAltキーで、Macの*Metaキー*は*コマンド⌘キー*です。一貫性のために、*Metaキー*を使いますが、
あなたのオペレーティングシステムにおける適切なキー配置であることを憶えておいてください。

## 短縮

シンプルで読みやすくするために、*Ctrlキー*＋その他のキーは「*C-*」、*Metaキー*＋その他のキーは「*M-*」の略語を使います。例えば、もし*Metaキー*と' r 'を同時に押さえるショートカットを要求する場合、「*M-r*」と表記します。 
以下は、僕が見つけたとっても有用なショートカットのいくつかです。

## 停止と開始

マウスを使う代わりに、`M-r`でコードを実行することができます。同様に、`M-s`でコードを停止することができます。

## ナビゲーション

ナビゲーションのショートカットを使わない操作は実にもどかしいです。そのため、ショートカットを学ぶことに時間を費やすことを強くお勧めします。マウスやキーボードの矢印キーを手で移動させるより、ブラインドタッチを学ぶことで、これらのショートカットをさらに有効に活用することができます。

文章の先頭に移動するにはC-a、文章の末尾に移動するにはC-e、１行上はC-p、１行下がるにはC-n、一文字進むにはC-f、そして、一文字戻るにはC-b。C-kでカーソルからラインの末尾まで全ての文字を消去する事ができます。

## コードの整形

コードを自動整形するには `M-m`を押します。

## ヘルプシステム

ヘルプシステムを切り替えるには、`M-i`を押します。しかし、何かを見つける場合、もっとはるかに便利なショートカットは、カーソル下の単語検索し、ドキュメントを表示する`C-i`です。簡単でしょう！

完全なリストについては、セクション10.2ショートカット一覧表を見てみましょう。
