/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sonicmail-sound.h"

void sonicmail_sound_play(SonicmailVars *vars)
{
   char wavfile[256];
   int curr_num_mails, prev_num_mails;
   gboolean audio_on, audio_repeat_on;
   
   /* Get audio info: */
   pthread_mutex_lock(&(vars->mut));
      audio_on = vars->audio_on;
      audio_repeat_on = vars->audio_repeat_on;
      strcpy(wavfile, vars->wavfile_filename); /* Get the wavfile name */
      prev_num_mails = vars->prev_num_mails;
      curr_num_mails = vars->curr_num_mails;
   pthread_mutex_unlock(&(vars->mut));
 
   /* Play sound (if enabled and change has occured): */
   if(audio_on && (prev_num_mails < curr_num_mails)) {
      
      int esd_stat;
      
      if((prev_num_mails == 0 && curr_num_mails > 0) || (audio_repeat_on) ) {
      
         /* Play the WAV file using ESD (note that 
            this uses fallback if ESD is not available): */
         if (! (esd_stat = esd_play_file(NULL, wavfile, 1)))
            SM_DEBUG("Failed to play WAV file");
      }
   }
}


