#include <algorithm>
#include "MailMessage.h"
#include "FileMailMessageReader.h"
#include "MaildirMailMessageReader.h"

MaildirMailMessageReader::MaildirMailMessageReader(const File &maildir)
  : m_maildir(maildir)
{
  File(m_maildir, "cur").children(m_children);
  File(m_maildir, "new").children(m_children);
  sort(m_children.begin(), m_children.end());
  m_current = m_children.begin();
  m_end = m_children.end();
}

MaildirMailMessageReader::~MaildirMailMessageReader()
{
}

bool MaildirMailMessageReader::isMaildir(const File &maildir)
{
  return File(maildir, "cur").isDirectory() && File(maildir, "new").isDirectory();
}

OWNED MailMessage *MaildirMailMessageReader::readMessage()
{
  while (m_reader.isNotNull() || m_current != m_end) {
    if (m_reader.isNotNull()) {
      Ptr<MailMessage> msg(m_reader->readMessage());
      if (msg.isNotNull()) {
        return msg.release();
      }
      m_reader.clear();
    }

    while (m_reader.isNull() && (m_current != m_end)) {
      const File &child = *m_current;
      ++m_current;

      if (child.isFile() && !child.isHidden()) {
        Ptr<FileMailMessageReader> tmp(new FileMailMessageReader);
        tmp->open(child.getPath(), true, true);
        m_reader.set(tmp.release());
      }
    }
  }
  return 0;
}
