-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure Wf_Proof_Function_Declaration
  (Node          : in     STree.SyntaxNode;
   Current_Scope : in     Dictionary.Scopes;
   The_Heap      : in out Heap.HeapRecord;
   Func_Sym      :    out Dictionary.Symbol) is
   Spec_Node, Constraint_Node : STree.SyntaxNode;
   Dummy_Component_Data       : ComponentManager.ComponentData;
begin
   ComponentManager.Initialise (Data => Dummy_Component_Data);
   Spec_Node := Child_Node (Current_Node => Node);
   -- ASSUME Spec_Node = function_specification
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Spec_Node) = SP_Symbols.function_specification,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Spec_Node = function_specification in Wf_Proof_Function_Declaration");
   Constraint_Node := Next_Sibling (Current_Node => Spec_Node);
   -- ASSUME Constraint_Node = function_constraint
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Constraint_Node) = SP_Symbols.function_constraint,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Constraint_Node = function_constraint in Wf_Proof_Function_Declaration");
   --# accept Flow, 10, Dummy_Component_Data, "Expected ineffective assignment";
   Subprogram_Specification.Wf_Subprogram_Specification
     (Spec_Node       => Spec_Node,
      Anno_Node       => STree.NullNode,
      Constraint_Node => Constraint_Node,
      Current_Scope   => Current_Scope,
      Current_Context => Dictionary.ProofContext,
      Component_Data  => Dummy_Component_Data,
      The_Heap        => The_Heap,
      Subprog_Sym     => Func_Sym);
   --# end accept;
end Wf_Proof_Function_Declaration;
