/* spek-window.c generated by valac 0.10.4, the Vala compiler
 * generated from spek-window.vala, do not modify */

/* spek-window.vala
 *
 * Copyright (C) 2010-2011  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <spek-platform.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define SPEK_TYPE_WINDOW (spek_window_get_type ())
#define SPEK_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_WINDOW, SpekWindow))
#define SPEK_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_WINDOW, SpekWindowClass))
#define SPEK_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_WINDOW))
#define SPEK_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_WINDOW))
#define SPEK_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_WINDOW, SpekWindowClass))

typedef struct _SpekWindow SpekWindow;
typedef struct _SpekWindowClass SpekWindowClass;
typedef struct _SpekWindowPrivate SpekWindowPrivate;

#define SPEK_TYPE_MESSAGE_BAR (spek_message_bar_get_type ())
#define SPEK_MESSAGE_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_MESSAGE_BAR, SpekMessageBar))
#define SPEK_MESSAGE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_MESSAGE_BAR, SpekMessageBarClass))
#define SPEK_IS_MESSAGE_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_MESSAGE_BAR))
#define SPEK_IS_MESSAGE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_MESSAGE_BAR))
#define SPEK_MESSAGE_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_MESSAGE_BAR, SpekMessageBarClass))

typedef struct _SpekMessageBar SpekMessageBar;
typedef struct _SpekMessageBarClass SpekMessageBarClass;

#define SPEK_TYPE_SPECTROGRAM (spek_spectrogram_get_type ())
#define SPEK_SPECTROGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_SPECTROGRAM, SpekSpectrogram))
#define SPEK_SPECTROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_SPECTROGRAM, SpekSpectrogramClass))
#define SPEK_IS_SPECTROGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_SPECTROGRAM))
#define SPEK_IS_SPECTROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_SPECTROGRAM))
#define SPEK_SPECTROGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_SPECTROGRAM, SpekSpectrogramClass))

typedef struct _SpekSpectrogram SpekSpectrogram;
typedef struct _SpekSpectrogramClass SpekSpectrogramClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SPEK_TYPE_PREFERENCES_DIALOG (spek_preferences_dialog_get_type ())
#define SPEK_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_PREFERENCES_DIALOG, SpekPreferencesDialog))
#define SPEK_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_PREFERENCES_DIALOG, SpekPreferencesDialogClass))
#define SPEK_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_PREFERENCES_DIALOG))
#define SPEK_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_PREFERENCES_DIALOG))
#define SPEK_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_PREFERENCES_DIALOG, SpekPreferencesDialogClass))

typedef struct _SpekPreferencesDialog SpekPreferencesDialog;
typedef struct _SpekPreferencesDialogClass SpekPreferencesDialogClass;
typedef struct _Block4Data Block4Data;

#define SPEK_TYPE_PREFERENCES (spek_preferences_get_type ())
#define SPEK_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_PREFERENCES, SpekPreferences))
#define SPEK_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_PREFERENCES, SpekPreferencesClass))
#define SPEK_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_PREFERENCES))
#define SPEK_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_PREFERENCES))
#define SPEK_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_PREFERENCES, SpekPreferencesClass))

typedef struct _SpekPreferences SpekPreferences;
typedef struct _SpekPreferencesClass SpekPreferencesClass;
#define _spek_preferences_unref0(var) ((var == NULL) ? NULL : (var = (spek_preferences_unref (var), NULL)))

struct _SpekWindow {
	GtkWindow parent_instance;
	SpekWindowPrivate * priv;
};

struct _SpekWindowClass {
	GtkWindowClass parent_class;
};

struct _SpekWindowPrivate {
	GtkUIManager* ui;
	SpekMessageBar* message_bar;
	SpekSpectrogram* spectrogram;
	char* description;
	char* cur_dir;
	GtkFileFilter* filter_all;
	GtkFileFilter* filter_audio;
	GtkFileFilter* filter_png;
	char** audio_extensions;
	gint audio_extensions_length1;
	gint _audio_extensions_size_;
};

struct _Block4Data {
	int _ref_count_;
	SpekWindow * self;
	GtkAboutDialog* dlg;
};


static gpointer spek_window_parent_class = NULL;

GType spek_window_get_type (void) G_GNUC_CONST;
GType spek_message_bar_get_type (void) G_GNUC_CONST;
GType spek_spectrogram_get_type (void) G_GNUC_CONST;
#define SPEK_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPEK_TYPE_WINDOW, SpekWindowPrivate))
enum  {
	SPEK_WINDOW_DUMMY_PROPERTY
};
static void spek_window_on_file_open (SpekWindow* self);
static void _spek_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self);
static void spek_window_on_file_save (SpekWindow* self);
static void _spek_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self);
static void spek_window_on_file_quit (SpekWindow* self);
static void _spek_window_on_file_quit_gtk_action_callback (GtkAction* action, gpointer self);
static void spek_window_on_edit_preferences (SpekWindow* self);
static void _spek_window_on_edit_preferences_gtk_action_callback (GtkAction* action, gpointer self);
static void spek_window_on_help_about (SpekWindow* self);
static void _spek_window_on_help_about_gtk_action_callback (GtkAction* action, gpointer self);
#define SPEK_WINDOW_UI "\n" \
"<ui>\n" \
"    <menubar name='MenuBar'>\n" \
"        <menu action='File'>\n" \
"            <menuitem action='FileOpen'/>\n" \
"            <menuitem action='FileSave'/>\n" \
"            <separator/>\n" \
"            <menuitem action='FileQuit'/>\n" \
"        </menu>\n" \
"        <menu action='Edit'>\n" \
"            <menuitem action='EditPreferences'/>\n" \
"        </menu>\n" \
"        <menu action='Help'>\n" \
"            <menuitem action='HelpAbout'/>\n" \
"        </menu>\n" \
"    </menubar>\n" \
"\n" \
"    <toolbar name='ToolBar'>\n" \
"        <toolitem action='FileOpen'/>\n" \
"        <toolitem action='FileSave'/>\n" \
"        <separator expand='true'/>\n" \
"        <toolitem action='HelpAbout'/>\n" \
"    </toolbar>\n" \
"</ui>\n"
SpekWindow* spek_window_new (const char* file_name);
SpekWindow* spek_window_construct (GType object_type, const char* file_name);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
SpekMessageBar* spek_message_bar_new (const char* message);
SpekMessageBar* spek_message_bar_construct (GType object_type, const char* message);
SpekSpectrogram* spek_spectrogram_new (void);
SpekSpectrogram* spek_spectrogram_construct (GType object_type);
static void spek_window_on_dropped (SpekWindow* self, GdkDragContext* cx, gint x, gint y, GtkSelectionData* data, guint info, guint time);
static void _spek_window_on_dropped_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void spek_window_open_file (SpekWindow* self, const char* file_name);
static void* spek_window_check_version (SpekWindow* self);
static void* _spek_window_check_version_gthread_func (gpointer self);
void spek_spectrogram_open (SpekSpectrogram* self, const char* file_name);
const char* spek_spectrogram_get_file_name (SpekSpectrogram* self);
void spek_spectrogram_save (SpekSpectrogram* self, const char* file_name);
SpekPreferencesDialog* spek_preferences_dialog_new (void);
SpekPreferencesDialog* spek_preferences_dialog_construct (GType object_type);
GType spek_preferences_dialog_get_type (void) G_GNUC_CONST;
static void _lambda15_ (gint id, Block4Data* _data4_);
static void __lambda15__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void spek_window_url_hook (SpekWindow* self, GtkAboutDialog* about, const char* link);
static void _spek_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
gpointer spek_preferences_ref (gpointer instance);
void spek_preferences_unref (gpointer instance);
GParamSpec* spek_param_spec_preferences (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void spek_value_set_preferences (GValue* value, gpointer v_object);
void spek_value_take_preferences (GValue* value, gpointer v_object);
gpointer spek_value_get_preferences (const GValue* value);
GType spek_preferences_get_type (void) G_GNUC_CONST;
SpekPreferences* spek_preferences_get_instance (void);
gboolean spek_preferences_get_check_update (SpekPreferences* self);
gint spek_preferences_get_last_update (SpekPreferences* self);
static gboolean _lambda16_ (SpekWindow* self);
static gboolean __lambda16__gsource_func (gpointer self);
void spek_preferences_set_check_update (SpekPreferences* self, gboolean value);
void spek_preferences_set_last_update (SpekPreferences* self, gint value);
void spek_preferences_save (SpekPreferences* self);
static void spek_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry SPEK_WINDOW_ACTION_ENTRIES[8] = {{"File", NULL, N_ ("_File")}, {"FileOpen", GTK_STOCK_OPEN, NULL, NULL, NULL, (GCallback) _spek_window_on_file_open_gtk_action_callback}, {"FileSave", GTK_STOCK_SAVE, NULL, NULL, NULL, (GCallback) _spek_window_on_file_save_gtk_action_callback}, {"FileQuit", GTK_STOCK_QUIT, NULL, NULL, NULL, (GCallback) _spek_window_on_file_quit_gtk_action_callback}, {"Edit", NULL, N_ ("_Edit")}, {"EditPreferences", GTK_STOCK_PREFERENCES, NULL, "<Ctrl>E", NULL, (GCallback) _spek_window_on_edit_preferences_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpAbout", GTK_STOCK_ABOUT, NULL, "F1", NULL, (GCallback) _spek_window_on_help_about_gtk_action_callback}};
static const GtkTargetEntry SPEK_WINDOW_DEST_TARGET_ENTRIES[1] = {{"text/uri-list", (guint) 0, (guint) 0}};


static void _spek_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self) {
	spek_window_on_file_open (self);
}


static void _spek_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self) {
	spek_window_on_file_save (self);
}


static void _spek_window_on_file_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	spek_window_on_file_quit (self);
}


static void _spek_window_on_edit_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	spek_window_on_edit_preferences (self);
}


static void _spek_window_on_help_about_gtk_action_callback (GtkAction* action, gpointer self) {
	spek_window_on_help_about (self);
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
	gtk_main_quit ();
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _spek_window_on_dropped_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	spek_window_on_dropped (self, context, x, y, selection_data, info, time_);
}


static void* _spek_window_check_version_gthread_func (gpointer self) {
	void* result;
	result = spek_window_check_version (self);
	return result;
}


SpekWindow* spek_window_construct (GType object_type, const char* file_name) {
	SpekWindow * self;
	char* _tmp0_;
	GtkActionGroup* actions;
	GtkUIManager* _tmp1_;
	GtkWidget* menubar;
	GtkToolbar* toolbar;
	SpekMessageBar* _tmp2_;
	SpekSpectrogram* _tmp3_;
	char* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkVBox* vbox;
	GError * _inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	self->priv->description = (_tmp0_ = g_strdup ((gtk_window_set_title ((GtkWindow*) self, _ ("Spek - Acoustic Spectrum Analyser")), gtk_window_get_title ((GtkWindow*) self))), _g_free0 (self->priv->description), _tmp0_);
	gtk_window_set_default_icon_name ("spek");
	gtk_window_set_default_size ((GtkWindow*) self, 640, 480);
	g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	actions = gtk_action_group_new ("Actions");
	gtk_action_group_set_translation_domain (actions, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (actions, SPEK_WINDOW_ACTION_ENTRIES, G_N_ELEMENTS (SPEK_WINDOW_ACTION_ENTRIES), self);
	self->priv->ui = (_tmp1_ = gtk_ui_manager_new (), _g_object_unref0 (self->priv->ui), _tmp1_);
	gtk_ui_manager_insert_action_group (self->priv->ui, actions, 0);
	gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (self->priv->ui));
	{
		gtk_ui_manager_add_ui_from_string (self->priv->ui, SPEK_WINDOW_UI, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("spek-window.vala:90: Could not load the UI: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (actions);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	menubar = _g_object_ref0 (gtk_ui_manager_get_widget (self->priv->ui, "/MenuBar"));
	toolbar = _g_object_ref0 (GTK_TOOLBAR (gtk_ui_manager_get_widget (self->priv->ui, "/ToolBar")));
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_BOTH_HORIZ);
	gtk_tool_item_set_is_important (GTK_TOOL_ITEM (gtk_ui_manager_get_widget (self->priv->ui, "/ToolBar/FileOpen")), TRUE);
	gtk_tool_item_set_is_important (GTK_TOOL_ITEM (gtk_ui_manager_get_widget (self->priv->ui, "/ToolBar/FileSave")), TRUE);
	gtk_tool_item_set_is_important (GTK_TOOL_ITEM (gtk_ui_manager_get_widget (self->priv->ui, "/ToolBar/HelpAbout")), TRUE);
	self->priv->message_bar = (_tmp2_ = g_object_ref_sink (spek_message_bar_new (_ ("A new version of Spek is available on <a href=\"http://www.spek-projec" \
"t.org\">www.spek-project.org</a>"))), _g_object_unref0 (self->priv->message_bar), _tmp2_);
	self->priv->spectrogram = (_tmp3_ = g_object_ref_sink (spek_spectrogram_new ()), _g_object_unref0 (self->priv->spectrogram), _tmp3_);
	self->priv->cur_dir = (_tmp4_ = g_strdup (g_get_home_dir ()), _g_free0 (self->priv->cur_dir), _tmp4_);
	self->priv->filter_all = (_tmp5_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (self->priv->filter_all), _tmp5_);
	gtk_file_filter_set_name (self->priv->filter_all, _ ("All files"));
	gtk_file_filter_add_pattern (self->priv->filter_all, "*");
	self->priv->filter_png = (_tmp6_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (self->priv->filter_png), _tmp6_);
	gtk_file_filter_set_name (self->priv->filter_png, _ ("PNG images"));
	gtk_file_filter_add_pattern (self->priv->filter_png, "*.png");
	self->priv->filter_audio = (_tmp7_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (self->priv->filter_audio), _tmp7_);
	gtk_file_filter_set_name (self->priv->filter_audio, _ ("Audio files"));
	{
		char** ext_collection;
		int ext_collection_length1;
		int ext_it;
		ext_collection = self->priv->audio_extensions;
		ext_collection_length1 = self->priv->audio_extensions_length1;
		for (ext_it = 0; ext_it < self->priv->audio_extensions_length1; ext_it = ext_it + 1) {
			char* ext;
			ext = g_strdup (ext_collection[ext_it]);
			{
				gtk_file_filter_add_pattern (self->priv->filter_audio, ext);
				_g_free0 (ext);
			}
		}
	}
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_pack_start ((GtkBox*) vbox, menubar, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) toolbar, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->message_bar, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->spectrogram, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	gtk_widget_show_all (menubar);
	gtk_widget_show_all ((GtkWidget*) toolbar);
	gtk_widget_show_all ((GtkWidget*) self->priv->spectrogram);
	gtk_widget_show ((GtkWidget*) vbox);
	spek_platform_fix_ui (self->priv->ui);
	gtk_widget_show ((GtkWidget*) self);
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, SPEK_WINDOW_DEST_TARGET_ENTRIES, G_N_ELEMENTS (SPEK_WINDOW_DEST_TARGET_ENTRIES), GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _spek_window_on_dropped_gtk_widget_drag_data_received, self, 0);
	if (file_name != NULL) {
		spek_window_open_file (self, file_name);
	}
	{
		g_thread_create (_spek_window_check_version_gthread_func, self, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch11_g_thread_error;
			}
			_g_object_unref0 (vbox);
			_g_object_unref0 (toolbar);
			_g_object_unref0 (menubar);
			_g_object_unref0 (actions);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally11;
	__catch11_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (vbox);
		_g_object_unref0 (toolbar);
		_g_object_unref0 (menubar);
		_g_object_unref0 (actions);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (vbox);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (menubar);
	_g_object_unref0 (actions);
	return self;
}


SpekWindow* spek_window_new (const char* file_name) {
	return spek_window_construct (SPEK_TYPE_WINDOW, file_name);
}


static void spek_window_on_dropped (SpekWindow* self, GdkDragContext* cx, gint x, gint y, GtkSelectionData* data, guint info, guint time) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cx != NULL);
	g_return_if_fail (data != NULL);
	if (gtk_selection_data_get_length (data) > 0) {
		_tmp0_ = gtk_selection_data_get_format (data) == 8;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint files_length1;
		gint _files_size_;
		char** _tmp2_;
		char** _tmp1_;
		char** files;
		files = (_tmp2_ = _tmp1_ = gtk_selection_data_get_uris (data), files_length1 = _vala_array_length (_tmp1_), _files_size_ = files_length1, _tmp2_);
		if (files_length1 > 0) {
			{
				char* _tmp3_;
				char* _tmp4_;
				_tmp3_ = g_filename_from_uri (files[0], NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch12_g_convert_error;
					}
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				spek_window_open_file (self, _tmp4_ = _tmp3_);
				_g_free0 (_tmp4_);
				gtk_drag_finish (cx, TRUE, FALSE, (guint32) time);
				files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			goto __finally12;
			__catch12_g_convert_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (e);
				}
			}
			__finally12:
			if (_inner_error_ != NULL) {
				files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	gtk_drag_finish (cx, FALSE, FALSE, (guint32) time);
}


static void spek_window_open_file (SpekWindow* self, const char* file_name) {
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_name != NULL);
	self->priv->cur_dir = (_tmp0_ = g_path_get_dirname (file_name), _g_free0 (self->priv->cur_dir), _tmp0_);
	spek_spectrogram_open (self->priv->spectrogram, file_name);
	gtk_window_set_title ((GtkWindow*) self, _tmp2_ = g_strdup_printf (_ ("Spek - %s"), _tmp1_ = g_path_get_basename (file_name)));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
}


static void spek_window_on_file_open (SpekWindow* self) {
	GtkFileChooserDialog* chooser;
	g_return_if_fail (self != NULL);
	chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Open File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL));
	gtk_dialog_set_default_response ((GtkDialog*) chooser, (gint) GTK_RESPONSE_ACCEPT);
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) chooser, FALSE);
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) chooser, self->priv->cur_dir);
	gtk_file_chooser_add_filter ((GtkFileChooser*) chooser, self->priv->filter_all);
	gtk_file_chooser_add_filter ((GtkFileChooser*) chooser, self->priv->filter_audio);
	gtk_file_chooser_set_filter ((GtkFileChooser*) chooser, self->priv->filter_audio);
	if (gtk_dialog_run ((GtkDialog*) chooser) == GTK_RESPONSE_ACCEPT) {
		char* _tmp0_;
		spek_window_open_file (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) chooser));
		_g_free0 (_tmp0_);
	}
	gtk_object_destroy ((GtkObject*) chooser);
	_g_object_unref0 (chooser);
}


static void spek_window_on_file_save (SpekWindow* self) {
	GtkFileChooserDialog* chooser;
	char* _tmp0_;
	char* file_name;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save Spectrogram"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL));
	gtk_dialog_set_default_response ((GtkDialog*) chooser, (gint) GTK_RESPONSE_ACCEPT);
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) chooser, self->priv->cur_dir);
	_tmp0_ = g_strdup (spek_spectrogram_get_file_name (self->priv->spectrogram));
	if (_tmp0_ == NULL) {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = g_strdup (_ ("Untitled")), _g_free0 (_tmp0_), _tmp1_);
	}
	file_name = g_path_get_basename (_tmp0_);
	file_name = (_tmp2_ = g_strconcat (file_name, ".png", NULL), _g_free0 (file_name), _tmp2_);
	gtk_file_chooser_set_current_name ((GtkFileChooser*) chooser, file_name);
	gtk_file_chooser_add_filter ((GtkFileChooser*) chooser, self->priv->filter_png);
	gtk_file_chooser_set_filter ((GtkFileChooser*) chooser, self->priv->filter_png);
	if (gtk_dialog_run ((GtkDialog*) chooser) == GTK_RESPONSE_ACCEPT) {
		char* _tmp3_;
		char* _tmp4_;
		file_name = (_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) chooser), _g_free0 (file_name), _tmp3_);
		self->priv->cur_dir = (_tmp4_ = g_path_get_dirname (file_name), _g_free0 (self->priv->cur_dir), _tmp4_);
		spek_spectrogram_save (self->priv->spectrogram, file_name);
	}
	gtk_object_destroy ((GtkObject*) chooser);
	_g_free0 (file_name);
	_g_free0 (_tmp0_);
	_g_object_unref0 (chooser);
}


static void spek_window_on_file_quit (SpekWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void spek_window_on_edit_preferences (SpekWindow* self) {
	SpekPreferencesDialog* dlg;
	g_return_if_fail (self != NULL);
	dlg = g_object_ref_sink (spek_preferences_dialog_new ());
	gtk_window_set_transient_for ((GtkWindow*) dlg, (GtkWindow*) self);
	gtk_dialog_run ((GtkDialog*) dlg);
	_g_object_unref0 (dlg);
}


static void _lambda15_ (gint id, Block4Data* _data4_) {
	SpekWindow * self;
	self = _data4_->self;
	gtk_object_destroy ((GtkObject*) _data4_->dlg);
}


static void __lambda15__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda15_ (response_id, self);
}


static void _spek_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	spek_window_url_hook (self, about, link_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->dlg);
		g_slice_free (Block4Data, _data4_);
	}
}


static void spek_window_on_help_about (SpekWindow* self) {
	Block4Data* _data4_;
	gint authors_length1;
	gint _authors_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** authors;
	gint artists_length1;
	gint _artists_size_;
	char** _tmp3_;
	char** _tmp2_ = NULL;
	char** artists;
	char* license;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	authors = (_tmp1_ = (_tmp0_ = g_new0 (char*, 7 + 1), _tmp0_[0] = g_strdup ("Primary Development:"), _tmp0_[1] = g_strdup ("\tAlexander Kojevnikov (maintainer)"), _tmp0_[2] = g_strdup (""), _tmp0_[3] = g_strdup ("Contributors:"), _tmp0_[4] = g_strdup ("\tFabian Deutsch"), _tmp0_[5] = g_strdup ("\tJonathan Gonzalez V"), _tmp0_[6] = g_strdup ("\tStefan Kost"), _tmp0_), authors_length1 = 7, _authors_size_ = authors_length1, _tmp1_);
	artists = (_tmp3_ = (_tmp2_ = g_new0 (char*, 1 + 1), _tmp2_[0] = g_strdup ("Olga Vasylevska"), _tmp2_), artists_length1 = 1, _artists_size_ = artists_length1, _tmp3_);
	license = g_strdup ("Copyright (C) 2010-2011  Alexander Kojevnikov");
	license = (_tmp4_ = g_strconcat (license, "\n\n", NULL), _g_free0 (license), _tmp4_);
	license = (_tmp5_ = g_strconcat (license, "Spek is free software: you can redistribute it and/or modify ", NULL), _g_free0 (license), _tmp5_);
	license = (_tmp6_ = g_strconcat (license, "it under the terms of the GNU General Public License as published by ", NULL), _g_free0 (license), _tmp6_);
	license = (_tmp7_ = g_strconcat (license, "the Free Software Foundation, either version 3 of the License, or ", NULL), _g_free0 (license), _tmp7_);
	license = (_tmp8_ = g_strconcat (license, "(at your option) any later version.", NULL), _g_free0 (license), _tmp8_);
	license = (_tmp9_ = g_strconcat (license, "\n\n", NULL), _g_free0 (license), _tmp9_);
	license = (_tmp10_ = g_strconcat (license, "Spek is distributed in the hope that it will be useful, ", NULL), _g_free0 (license), _tmp10_);
	license = (_tmp11_ = g_strconcat (license, "but WITHOUT ANY WARRANTY; without even the implied warranty of ", NULL), _g_free0 (license), _tmp11_);
	license = (_tmp12_ = g_strconcat (license, "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the ", NULL), _g_free0 (license), _tmp12_);
	license = (_tmp13_ = g_strconcat (license, "GNU General Public License for more details.", NULL), _g_free0 (license), _tmp13_);
	license = (_tmp14_ = g_strconcat (license, "\n\n", NULL), _g_free0 (license), _tmp14_);
	license = (_tmp15_ = g_strconcat (license, "You should have received a copy of the GNU General Public License ", NULL), _g_free0 (license), _tmp15_);
	license = (_tmp16_ = g_strconcat (license, "along with Spek.  If not, see http://www.gnu.org/licenses/", NULL), _g_free0 (license), _tmp16_);
	_data4_->dlg = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ());
	gtk_about_dialog_set_program_name (_data4_->dlg, "Spek");
	gtk_about_dialog_set_version (_data4_->dlg, PACKAGE_VERSION);
	gtk_about_dialog_set_copyright (_data4_->dlg, _ ("Copyright \xc2\xa9 2010-2011 Alexander Kojevnikov"));
	gtk_about_dialog_set_comments (_data4_->dlg, self->priv->description);
	g_object_set ((GObject*) _data4_->dlg, "authors", authors, NULL);
	g_object_set ((GObject*) _data4_->dlg, "artists", artists, NULL);
	gtk_about_dialog_set_website_label (_data4_->dlg, _ ("Spek Website"));
	gtk_about_dialog_set_website (_data4_->dlg, "http://www.spek-project.org/");
	gtk_about_dialog_set_license (_data4_->dlg, license);
	gtk_about_dialog_set_wrap_license (_data4_->dlg, TRUE);
	{
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		_tmp17_ = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (), "spek", 128, GTK_ICON_LOOKUP_FORCE_SVG, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		gtk_about_dialog_set_logo (_data4_->dlg, _tmp18_ = _tmp17_);
		_g_object_unref0 (_tmp18_);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			gtk_about_dialog_set_logo_icon_name (_data4_->dlg, "spek");
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (license);
		artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
		block4_data_unref (_data4_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_about_dialog_set_translator_credits (_data4_->dlg, _ ("translator-credits"));
	gtk_window_set_transient_for ((GtkWindow*) _data4_->dlg, (GtkWindow*) self);
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data4_->dlg, TRUE);
	g_signal_connect_data ((GtkDialog*) _data4_->dlg, "response", (GCallback) __lambda15__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_about_dialog_set_url_hook (_spek_window_url_hook_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_window_set_modal ((GtkWindow*) _data4_->dlg, TRUE);
	gtk_window_present ((GtkWindow*) _data4_->dlg);
	_g_free0 (license);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	block4_data_unref (_data4_);
}


static void spek_window_url_hook (SpekWindow* self, GtkAboutDialog* about, const char* link) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	spek_platform_show_uri (link);
}


static gpointer _spek_preferences_ref0 (gpointer self) {
	return self ? spek_preferences_ref (self) : NULL;
}


static gboolean _lambda16_ (SpekWindow* self) {
	gboolean result = FALSE;
	gtk_widget_show_all ((GtkWidget*) self->priv->message_bar);
	result = FALSE;
	return result;
}


static gboolean __lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


static void* spek_window_check_version (SpekWindow* self) {
	void* result = NULL;
	SpekPreferences* prefs;
	gboolean check;
	GTimeVal time_val = {0};
	GDate today = {0};
	gint day;
	gint diff;
	char* version;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	prefs = _spek_preferences_ref0 (spek_preferences_get_instance ());
	check = spek_preferences_get_check_update (prefs);
	if (!check) {
		result = NULL;
		_spek_preferences_unref0 (prefs);
		return result;
	}
	g_get_current_time (&time_val);
	g_get_current_time (&time_val);
	memset (&today, 0, sizeof (GDate));
	g_date_set_time_val (&today, &time_val);
	day = spek_preferences_get_last_update (prefs);
	diff = ((gint) g_date_get_julian (&today)) - day;
	if (diff < 7) {
		result = NULL;
		_spek_preferences_unref0 (prefs);
		return result;
	}
	version = spek_platform_read_line ("http://www.spek-project.org/version");
	if (version == NULL) {
		result = NULL;
		_g_free0 (version);
		_spek_preferences_unref0 (prefs);
		return result;
	}
	if (version != NULL) {
		_tmp0_ = _vala_strcmp0 (version, PACKAGE_VERSION) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, g_object_ref (self), g_object_unref);
	}
	spek_preferences_set_check_update (prefs, check);
	spek_preferences_set_last_update (prefs, (gint) g_date_get_julian (&today));
	spek_preferences_save (prefs);
	result = NULL;
	_g_free0 (version);
	_spek_preferences_unref0 (prefs);
	return result;
}


static void spek_window_class_init (SpekWindowClass * klass) {
	spek_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpekWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = spek_window_finalize;
}


static void spek_window_instance_init (SpekWindow * self) {
	char** _tmp0_ = NULL;
	self->priv = SPEK_WINDOW_GET_PRIVATE (self);
	self->priv->audio_extensions = (_tmp0_ = g_new0 (char*, 27 + 1), _tmp0_[0] = g_strdup ("*.3gp"), _tmp0_[1] = g_strdup ("*.aac"), _tmp0_[2] = g_strdup ("*.aif"), _tmp0_[3] = g_strdup ("*.aifc"), _tmp0_[4] = g_strdup ("*.aiff"), _tmp0_[5] = g_strdup ("*.amr"), _tmp0_[6] = g_strdup ("*.awb"), _tmp0_[7] = g_strdup ("*.ape"), _tmp0_[8] = g_strdup ("*.au"), _tmp0_[9] = g_strdup ("*.dts"), _tmp0_[10] = g_strdup ("*.flac"), _tmp0_[11] = g_strdup ("*.gsm"), _tmp0_[12] = g_strdup ("*.m4a"), _tmp0_[13] = g_strdup ("*.m4p"), _tmp0_[14] = g_strdup ("*.mp3"), _tmp0_[15] = g_strdup ("*.mp4"), _tmp0_[16] = g_strdup ("*.mp+"), _tmp0_[17] = g_strdup ("*.mpc"), _tmp0_[18] = g_strdup ("*.mpp"), _tmp0_[19] = g_strdup ("*.oga"), _tmp0_[20] = g_strdup ("*.ogg"), _tmp0_[21] = g_strdup ("*.ra"), _tmp0_[22] = g_strdup ("*.ram"), _tmp0_[23] = g_strdup ("*.snd"), _tmp0_[24] = g_strdup ("*.wav"), _tmp0_[25] = g_strdup ("*.wma"), _tmp0_[26] = g_strdup ("*.wv"), _tmp0_);
	self->priv->audio_extensions_length1 = 27;
	self->priv->_audio_extensions_size_ = self->priv->audio_extensions_length1;
}


static void spek_window_finalize (GObject* obj) {
	SpekWindow * self;
	self = SPEK_WINDOW (obj);
	_g_object_unref0 (self->priv->ui);
	_g_object_unref0 (self->priv->message_bar);
	_g_object_unref0 (self->priv->spectrogram);
	_g_free0 (self->priv->description);
	_g_free0 (self->priv->cur_dir);
	_g_object_unref0 (self->priv->filter_all);
	_g_object_unref0 (self->priv->filter_audio);
	_g_object_unref0 (self->priv->filter_png);
	self->priv->audio_extensions = (_vala_array_free (self->priv->audio_extensions, self->priv->audio_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (spek_window_parent_class)->finalize (obj);
}


GType spek_window_get_type (void) {
	static volatile gsize spek_window_type_id__volatile = 0;
	if (g_once_init_enter (&spek_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpekWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spek_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpekWindow), 0, (GInstanceInitFunc) spek_window_instance_init, NULL };
		GType spek_window_type_id;
		spek_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "SpekWindow", &g_define_type_info, 0);
		g_once_init_leave (&spek_window_type_id__volatile, spek_window_type_id);
	}
	return spek_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




