package Ops::User;

use SmallPigVars qw($config);
use SmallPig;

use CGI qw(:standard :cgi-lib);
use CGI::Cookie ();

use strict;

my $lang;
my %CACHE;

sub new{
  my ($class, $STATE, $spdb) = @_;
  my $self = {};
  if($spdb){ $self->{'spdb'} = $spdb; }
  else{  require SPDB; $self->{'spdb'} = SPDB->new; }
  $self->{'STATE'} = $STATE;

  $lang = SmallPig::get_lang_ptr($STATE->{lang}, "LUser");
  
  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub _salt{
  my @saltset = (0..9, 'A'..'Z', 'a'..'z', '.', '/');
  return join('', @saltset[rand @saltset, rand @saltset]);
}

sub _create_passwd{
  my $ret = substr(join('', localtime()), 0, 10);
  return $ret;
}

sub _update_passwd{
  my ($self, $uid, $passwd)= @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my $crypt = crypt($passwd, _salt());
  my $data = {('passwd'=>$DBH->quote("$crypt"))};
  return $spdb->db_update("Users", $data, "uid=$uid");
}

sub register{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  
  my ($tboards, $tusers, $op) = 
    map { $STATE->{$_} } qw(boards users op);
  my $msg;

  my ($username, $email, $realname, $passwd, $passwda) = 
    map{ $STATE->{$_} } 
  qw(myusername myemail myrealname mypassword mypassworda);

  my $uri = script_name()."?op=register";
  if($username =~ /anonymous/gi){
      return (0, $lang->{'anonymous'}, "", $uri);
  }
  
  if($username =~ /\W/g){
      return (0, $lang->{'non_word'}, "", $uri);
  }

  # --- if there is no username or email 
  if(!$username||!$email){
    my $msg;
    $msg = "<LI>$lang->{'loginusername'} $lang->{'is_missing'}."
      if !$username;
    $msg .= "<LI>$lang->{'loginemail'} $lang->{'is_missing'}."
      if !$email;
    
    return (0, $msg, "", $uri);
  }
  
  if($config->{'self_chose_passwd'} eq "yes"){
      my $msg;
      if($passwd && $passwda){
	  unless($passwda eq $passwd){
	      $msg .= "<LI>".$lang->{'passwds_not_match'};
	  }
	  if(length($passwd) < 5 || length($passwda) <5){
	      $msg .= "<LI>".$lang->{'passwd_too_short'};
	  }
      }
      if($passwd && !$passwda || !$passwd && $passwda){
	  $msg .= "<LI>".$lang->{'need_passwd'};
      }

      return (0, $msg, "", $uri) if $msg;
  }

  my $username_q = $DBH->quote($username);
  my $email_q = $DBH->quote($email);
  my $res = $spdb->db_count("Users", "username=$username_q");
  if($res){
      return (0, $lang->{'user_in_use'}, "", $uri);
  }
  
  # --- if allow replicated email 
  if($config->{'emaildup'} eq "yes"){
    $res = $spdb->db_count("Users", "realemail=$email_q AND active=1");
    if($res){
	return (0, $lang->{'mult_acc'}, "", $uri);
    }
  }

  # --- find the current time
  my $time = $spdb->db_date(); my $active;

  # --- lock the table Users
  $spdb->db_lock(("Users", "BoardPrefs"));

  my ($uid, $isadmin) = $spdb->db_select_cols("MAX(uid)", "Users"); 
  if($uid){
    $uid++; $isadmin = 0; 
  
    # --- if need confirm, active = 0;
    $active = ($config->{'confirm_email'} eq "yes")?0:1;
  }
  else{
    # --- first user register should be admin
    $uid = $isadmin = 1; $active = 1;
     # --- insert dummy node to *Users*
    my $data = {('uid'       =>0,
		 'username'  =>'anon','nickname'  =>'anon',
		 'realemail' =>'anon','fakeemail' =>'anon')};
    $spdb->db_insert("Users", $data);
  }
  
  # --- insert new user in *Users*
  my $data = {('uid'=>$uid,
	       'username'  =>$username,
	       'nickname'  =>$username,
	       'realemail' =>$email,
	       'fakeemail' =>$email,
	       'registered'=>$time,
	       'isadmin'   =>$isadmin,
	       'active'    =>$active,
	       'realname'  =>$realname,
	       'passwd'    =>$passwd)};
  my ($succ, $errmsg) = $spdb->db_insert("Users", $data);
  return (0, $errmsg, "", $uri) if !$succ;      

  $data = {(
	    'uid'       =>$uid,
	    'sort'      =>$config->{'sort'},
	    'view'      =>$config->{'view'},
	    'display'   =>$config->{'display'},
	    'postsper'  =>$config->{'postsper'},
	    )};

  ($succ, $errmsg) = $spdb->db_insert("BoardPrefs", $data);
  if(!$succ){
      $spdb->db_delete("Users", "uid=$uid");
      return (0, $errmsg, "", $uri);
  }

  # --- unlock the table Users
  $spdb->db_unlock();

  # --- create a new password for the new user
  my $new_passwd = $passwd || _create_passwd();
  # --- mail the password to the new user
  my $mailsubject = "$config->{'title'} $lang->{'reg_conf_title'}";

  my $conf_text = "";
  $conf_text = qq!
To confirm your email address, visit the following
Web page:

$config->{'cgidir'}/user.cgi?op=confirm&uid=$uid! 
if $config->{'confirm_email'} eq "yes";

  my $mailbody = qq!
Welcome to $config->{'title'}

You have registered for $config->{'title'} using email address:
$email.  If you did not register for $config->{'title'}, 
please ignore this message.
$conf_text

As a reminder, your username is $username and your password
is $new_passwd.  You may keep this email to refer to case you 
forget.

Thanks.
$config->{'adminaddr'}
    !;
  
  my ($succ, $errmsg) = SmallPig::send_mail($email, $config->{'adminaddr'},
					    $mailsubject, $mailbody);
  unless ($succ){
      $spdb->db_delete("Users", "uid=$uid");
      return (0, "$lang->{'cant_mail'}: $errmsg", "", $uri);
  }
  
  my ($succ, $errmsg) = $self->_update_passwd($uid, $new_passwd);
  return (0, $errmsg, "", $uri) if !$succ; 
  
  if($config->{'notifyadmins'} eq "yes"){
      my $title = "$config->{'title'} new user registration";
      my $date = localtime(); 
      my $agent = user_agent();
      my $remote = remote_host();
      my $mail = qq!
At $date, a user at $remote registered an account with uid $uid using the $agent browser.. 
    !;
      
      # --- look up the admins
      my ($admins) = $spdb->db_select_many_new(1,"realemail","Users","isadmin=1");
      
      # --- send email to each admin
      if($admins){
	  
	  while (my ($realemail) = $admins->fetchrow_array){
	    SmallPig::send_mail($realemail, $config->{'adminaddr'},
				$title, $mail);
	  }
	  
	  $spdb->db_handler_done($admins);

      }
  }

  if($config->{'spmail_cgi'} && -d $config->{'spmail_cgi'}){

      my $mlang = SmallPig::get_spmail_lang();

      # --- create default folders
      $spdb->db_lock(("MailFolders"));
      
      my $mmfid = $spdb->db_max("mfid", "MailFolders");
      $mmfid = 0 unless $mmfid; $mmfid++;
      my $mmforder = $spdb->db_max("mforder", "MailFolders");
      $mmforder = 0 unless $mmforder; $mmforder++;  
      
      my @folders = ($mlang->{'inbox'}, $mlang->{'draft'},
		     $mlang->{'sent'}, $mlang->{'trash'});
      
      push @folders, $mlang->{'Private_Msg'} ;
      
      for(my $i=$mmfid, my $j=0; $i<$mmfid+4; $i++, $j++){
	  my $data = {('mfid'=>$i,
		       'mfname'=>$folders[$j],
		       'msid'=>0,
		       'uid'=>$uid,
		       'mforder'=>$mmforder)};
	  $spdb->db_insert("MailFolders", $data);
      }
  }
  
  $msg = "$lang->{'user_register2'}: $username <BR><BR>
$lang->{'user_register3'}";
  
  return (1, $msg, $lang->{'user_register1'}, "$config->{'cgidir'}/user.cgi?op=login");
}

sub forget_passwd{
  my ($self, $STATE) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $msg;

  my $username_q = $DBH->quote($STATE->{'myusername'});

  unless($STATE->{'myusername'}){
    return (0, "$lang->{'loginusername'} $lang->{'is_missing'}.", "", "$config->{'cgidir'}/user.cgi?op=login");
  }

  my ($uid, $email, $fakeemail) = 
    $spdb->db_select_cols("uid, realemail, fakeemail", "Users", 
			 "username=$username_q AND active=1");
  unless($uid){
      return (0, $lang->{'cant_find_user'}, "", "$config->{'cgidir'}/user.cgi?op=login");
  }
  my $new_passwd = _create_passwd();
  my $mailsubject = "$config->{'title'} $lang->{'request_passwd'}";
  my $mailbody = qq|
Here is your temporary password: $new_passwd

Please write this Password down! Once you have 
logged in, you may change this password.

Thanks.
$config->{'adminaddr'}
  |;

  my ($succ, $errmsg) = SmallPig::send_mail($email, $config->{'adminaddr'},
					    $mailsubject, $mailbody);
  unless($succ){
      return (0, "$lang->{'cant_mail'}: $errmsg", "", "$config->{'cgidir'}/user.cgi?op=login");
  }

  my ($succ, $errmsg) = $self->_update_passwd($uid, $new_passwd);
  return (0, $errmsg, "", "$config->{'cgidir'}/user.cgi?op=login") if !$succ; 

  return (1, $lang->{'forget_passwd'}, $lang->{'passwd_sent'},
	  $ENV{SCRIPT_NAME}."?op=login");
}

sub save_user1{
  my ($self, $STATE) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my ($uri, $msg);

  my ($vpasswd, $passwd, $nickname, $realname, $realemail, 
      $fakeemail, $homepage, $bio,$icq, $myuid, $username, $prev_op, 
      $photo, $location, $privlev, $postsper, $uid) = 
	map{ $STATE->{$_} } 
  qw(vpasswd passwd 
     mynickname realname realemail 
     myfakeemail homepage mybio myicq
     myuid myusername prev_op 
     myphoto mylocation myprivlev postsper uid);

  # --- check the uid --- thanks Tim W from solutionscripts.com
  # --- if uid ne myuid
  if($uid != $myuid){
      # --- need admin right to change the profile
      my ($isadmin) = $spdb->db_select_cols("isadmin", "Users", "uid=$myuid");
      if(!$isadmin){
	  return (0, $lang->{'not_allow_edit'}, "", "$config->{'cgidir'}/user.cgi");
      }
  }
  
  if($passwd && $passwd){
    unless($vpasswd eq $passwd){
      $msg = "<LI>".$lang->{'passwds_not_match'};
    }
    if(length($passwd) < 5 || length($vpasswd) <5){
      $msg .= "<LI>".$lang->{'passwd_too_short'};
    }
  }
  if(($passwd && !$passwd) || (!$passwd && $passwd)){
    $msg = "<LI>".$lang->{'need_passwd'};
  }
  if($msg){
      $uri = "$config->{'cgidir'}/user.cgi";
      if($prev_op eq "modifyuser"){
	  $uri = "$config->{'cgidir'}/admin.cgi";
      } 
      return (0, $msg, "", $uri);
  }
  #update all fields
  else{
    $self->_update_passwd($myuid, $passwd) if $passwd && $vpasswd;
    my ($passwdq, $nicknameq, $realnameq, $realemailq, 
	$fakeemailq, $homepageq, $bioq, $icqq, $photoq,
	$locationq, $privlevq) = 
	map{ $DBH->quote($STATE->{$_}) } 
    qw(passwd 
       mynickname realname realemail 
       myfakeemail homepage mybio myicq
       myphoto mylocation myprivlev);

    my $data = {('realname'=>$realnameq,
		 'realemail'=>$realemailq, 'fakeemail'=>$fakeemailq,
		 'homepage'=>$homepageq, 'bio'=>$bioq,
		 'icq'=>$icqq, 'photourl'=>$photoq,
		 'location'=>$locationq, 'privlev'=>$privlevq)};
    $data->{'nickname'} = $nicknameq if $config->{'one_hdlr'} ne "yes";
    my ($succ, $errmsg) = $spdb->db_update("Users", $data, "uid=$myuid");
    return (0, $errmsg) if !$succ;
  }

  if($prev_op eq "modifyuser"){
      $uri = "$config->{'cgidir'}/admin.cgi";
  }
  
  return (1, $lang->{'profile_modified2'}, $lang->{'profile_modified1'}, $uri);
}

sub save_preferences1{
  my ($self, $STATE) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  
  my ($postsper, $myuid, $uid, $prev_op) = 
      map{ $STATE->{$_} } qw(mypostsper myuid uid prev_op);

  # --- check the uid --- thanks Tim W from solutionscripts.com
  # --- if uid ne myuid
  if($uid != $myuid){
      # --- need admin right to change the profile
      my ($isadmin) = $spdb->db_select_cols("isadmin", "Users", "uid=$uid");
      if(!$isadmin){
	  return (0, $lang->{'not_allow_edit'}, "", "$config->{'cgidir'}/user.cgi");
      }
  }

  my ($sigq, $sortq, $displayq, $viewq, $cookieexpireq, $themeq, $langq) = 
      map{ $DBH->quote($STATE->{$_}) } 
  qw(mysig mysort mydisplay myview cookieexpire mytheme mylang);
  my $data = {('sig'=>$sigq, 
	       'sort'=>$sortq, 'display'=>$displayq,
	       'view'=>$viewq, 'postsper'=>$postsper,
	       'theme'=>$themeq,
	       'lang'=>$langq)};
  my ($succ, $errmsg) = $spdb->db_update("BoardPrefs", $data, "uid=$myuid");
  return (0, $errmsg) if !$succ;

  ($succ, $errmsg) = $spdb->db_update("Users", {'cookieexpire'=>$cookieexpireq}, "uid=$myuid");
  return (0, $errmsg) if !$succ;

  my $uri = "$config->{'cgidir'}/user.cgi";
  if($prev_op eq "modifyuser"){
      $uri = "$config->{'cgidir'}/admin.cgi";
  }
  
  return (0, $errmsg) if !$succ;
  return (1, $lang->{'profile_modified2'}, $lang->{'profile_modified1'}, $uri);      
}

sub _authenticate{
  my ($self, $username, $passwd) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  
  my $username_q = $DBH->quote($username);
  my ($saved_passwd, $ce, $active) = 
    $spdb->db_select_cols("passwd, cookieexpire, active", 
			  "Users", 
			  "STRCMP(username, $username_q)=0");
  return (0, $lang->{'username_not_exist'}) unless($saved_passwd);
  return (0, $lang->{'passwd_not_match'}) 
    unless($saved_passwd eq crypt($passwd, $saved_passwd));
  return (0, $lang->{'not_active'}) unless $active;
  return ($ce, '');
}

sub verify_cookie{
  my $self = shift;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);    

  require MD5;
  my %cookie = cookie('login_cookie');

  return (0, "no cookie") unless %cookie;
  my $secret = $config->{'cookiesecret'};
  my $newhash = MD5->hexhash(
	        $secret.MD5->hexhash(join('',
					  $secret,
				   @cookie{qw(time username)})));

  unless($newhash eq $cookie{'hash'}){
    undef $CACHE{'cookiesecret'};
    return (0, "");
  }
  
  return($cookie{'username'}, "");
}

sub login{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($uri, $cookie, $msg);

  my ($username, $passwd, $autologout) = 
    map{ $STATE->{$_} } qw(loginusername loginpasswd autologout);
  
  $uri = $ENV{'SCRIPT_NAME'}."?op=login";
  if(length($username) > 0 && length($passwd) > 0){
    my $res;
    ($res, $msg) = $self->_authenticate($username, $passwd);

    if($res){
	# --- make cookie
	$cookie = $self->_create_cookie("login_cookie", $username, "", $res);

	unless($cookie){
	    return (0, $lang->{'cant_cookie'}, "", $uri);
	}
	$uri = $ENV{'SCRIPT_NAME'};

	# --- update the lastlogin
	my $timeq = $DBH->quote($spdb->db_date());
	my $usernameq = $DBH->quote($username);
	my $data = {('lastlogon'=>$timeq)};
	$spdb->db_update("Users", $data, "username=$usernameq AND active=1");
    
    }
    else{
      return (0, $msg, "", $uri);
    }
  }
  else{ 
    my $msg;
    $msg = "<LI>$lang->{'loginusername'} $lang->{'is_missing'}."
      if !$username;
    $msg .= "<LI>$lang->{'loginpasswd'} $lang->{'is_missing'}."
      if !$passwd;
    return (0, $msg, "", $uri);
  }

  return (1, $lang->{'login_succ2'}, $lang->{'login_succ1'}, $uri, $cookie);
}

sub _create_cookie{
    my ($self, $cname, $username, $secret, $cexpire) = @_;
    my $now = time();
    $secret = $secret || $config->{'cookiesecret'};
    my $hash = MD5->hexhash($secret.MD5->hexhash(join('',
						      $secret,
						      $now,
						      $username)));
    my $cval = {'time' => $now,
		'username' => $username,
		'hash' => $hash};
    
    my $path = "/";
    
    require CGI::Cookie;
    return  CGI::Cookie->new(-name => $cname,
			     -path => $path, 
			     -value => $cval,
			     -expires => $cexpire);
}

sub logout{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my $username = $STATE->{'username'};
  my $uid = $STATE->{'uid'};
  my $usernameq = $DBH->quote($username);

  # --- make_cookie
  my $cookie = "";
  $cookie = $self->_create_cookie("login_cookie", $username, "logout");

  return (0, $lang->{'cant_cookie'}, "")
    unless $cookie;
  
  if($config->{'spmail_cgi'} && -d $config->{'spmail_cgi'}){
      # --- update the caution
      my $cnt = $spdb->db_count("CautionTo","mto=$uid");
      if($cnt){
	  $spdb->db_delete("CautionTo", "mto=$uid AND slogon<=1");
	  $spdb->db_update("CautionTo", {('slogon'=>'slogon-1')},
			   "mto=$uid AND slogon>1");
      }
  
      # --- update the new messages to unread
      $spdb->db_update("MailMessages", {('new'=>2)}, 
		       "new=1 AND uid=$uid");
  }

  return (0, $lang->{'logout_succ2'},  $lang->{'logout_succ1'},
	  $ENV{'SCRIPT_NAME'}."?op=login", $cookie);
}

sub confirm{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);

  my $uid = $STATE->{'uid'};
  if(!$uid || !$spdb->db_count("Users", "uid=$uid")){
    return (0, $lang->{'cant_found_page'});  
  }
  
  $spdb->db_update("Users", {('active'=>1)}, "uid=$uid");
  
  return (1, $lang->{'confirm2'}, $lang->{'confirm1'});
}

sub _select_the_most_parent{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
                                   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
      $template->_select_the_most_parent($pid);
  }
}

sub _select_the_least_child{
    my ($self, $cid, $cnt, $date) = @_;
    my $spdb = $self->{'spdb'};

    my ($childids) = $spdb->db_select_many_new(1, "childid", "ParentAndChild",
					       "parentid=$cid");
    
    if(!$childids){
	($date) = $spdb->db_select_cols("date", "Posts", "cid=$cid") if !$date;
	$cnt = 0 if !$cnt;
	return ($cid, $cnt, $date);
    }

    my ($scid, $scnt, $cnt, $where, $date);
    my $scnt = 0;
    while (my ($childid) = $childids->fetchrow_array){
        $scnt++;
	($scid, $cnt) = $self->_select_the_least_child($childid, 0, $date);
	$scnt += $cnt;
	$where .= "cid=$scid OR ";
	
    }

    $spdb->db_handler_done($childids);

    $where =~ s/(.+) OR $/$1/;
    
    ($scid, $date) = $spdb->db_select_cols("cid, MAX(date)", 
					   "Posts", $where, 
					   "GROUP BY sid");
 
    return ($scid, $scnt, $date);
}

sub _expire_threads{
    my ($self, $selectedthreads, $sid, $op) = @_;
    my $spdb = $self->{'spdb'};
    my $DBH = $spdb->{'dbh'};
    
    my ($where, $where1, $where2, $where3, $cnt1);
    foreach (@$selectedthreads){
	my $cid = $_;
	$where .= "cid=$cid OR "; 
	$where1 .= "parentid=$cid OR ";
	$where2 .= "childid=$cid OR ";
	my $mpid = $self->_select_the_most_parent($cid);
	$where3 .= "cid=$mpid OR ";
    }
    $where =~ s/(.+) OR $/$1/g;
    $where1 =~ s/(.+) OR $/$1/g;
    $where2 =~ s/(.+) OR $/$1/g;
    $where3 =~ s/(.+) OR $/$1/g; 

    # --- lookup child
    my ($childids) = $spdb->db_select_many_new(1, "childid","ParentAndChild", "$where1");

    if($childids){

	while ( my ($childid) = $childids->fetchrow_array){
	    # --- find out the least child
	    my ($lchildid, $replies, $lastmod) = 
		$self->_select_the_least_child($childid);
	    my $data = {('cid'=>$childid, 'sid'=>$sid, 
			 'lastmod'=>$lastmod, 'replies'=>$replies)};
	    $spdb->db_insert("MostParents", $data);
	}

	$spdb->db_handler_done($childids);

    }

    $where1 = "$where1 OR $where2" if $where1;
    # --- delete from ParentAndChild
    $spdb->db_delete("ParentAndChild", $where1);

    # --- update the replies field for the most parent
    my ($mpids) = $spdb->db_select_many_new(1, "cid", "MostParents", $where3);

    if($mpids){
	
	while (my ($mpid) = $mpids->fetchrow_array){
	    my ($lcid, $cnt, $date) = $self->_select_the_least_child($mpid);
	    my $dateq = $DBH->quote($date);
	    my ($succ, $errmsg) = 
		$spdb->db_update("MostParents", 
				 {('replies'=>$cnt, 'lastmod'=>$dateq)}, 
				 "cid=$mpid");
	    return (0, $errmsg) if !$succ;
	}
	
	$spdb->db_handler_done($mpids);

    }
    # --- update commentcount in Boards
    my $sidq = $DBH->quote($sid);
    $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
    my ($succ, $errmsg) =
      $spdb->db_update("Boards", 
		      {('commentcount'=>$cnt1)},
		      "sid=$sidq");
    return (0, $errmsg) if !$succ;
    return (1);
}

sub _recover_thread{
    my ($self, $cid, $sid, $cautionblockptr) = @_;
    my $spdb = $self->{'spdb'};
    my $DBH = $spdb->{'dbh'};

    my $sidq = $DBH->quote($sid);

    my ($childids) = $spdb->db_select_many_new(1, "cid", "Posts", 
					       "sid=$sidq AND pid=$cid");    
    my $where;
    
    if($childids){

	while (my ($childid) = $childids->fetchrow_array){
	    $where .= "cid=$childid OR "; 
	    
	    my $data = {('parentid'=>$cid, 'childid'=>$childid)};
	    $spdb->db_insert("ParentAndChild", $data);
	}

	$spdb->db_handler_done($childids);

    }
    $where =~ s/(.+) OR $/$1/g;

    $spdb->db_delete("MostParents", $where);
    return (1);
}

sub move_threads{
  my ($self, $STATE) = @_;
  my ($STATE, $spdb) =  map{ $self->{$_} } qw(STATE spdb); 
  my $DBH = $spdb->{'dbh'};

  my $ret;
  my ($selectedthreads, $catandboard, $sid, $op, $userstatus, 
      $tuserstatus) = 
      map{ $STATE->{$_} } 
  qw(selectedthreads catandboard sid op userstatus tuserstatus);

  my ($level) = $spdb->db_select_cols("level", "Boards", 
				      "sid=".$DBH->quote($sid));
  my $bstatus = SmallPig::get_board_status($level);

  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};
  my $sfgmus = $tuserstatus->{gmem};

  if($userstatus ne "admin" && 
     !($bstatus =~ /group/ && $sfmus && grep { $_ eq $sid } @$sfmus) &&
     !($bstatus eq "group private" && $sfgmus && grep { $_ eq $sid } @$sfgmus) &&
     $bstatus !~ /public/ && $bstatus !~ /user private/){
	 return (0, $lang->{'unable_to_move'});
  }

  # --- make sure at least one item is selected
  unless($selectedthreads){
      return (0, $lang->{'at_least_one'});
  }

  my $cabq = $DBH->quote($catandboard);
  if($spdb->db_count("Boards", "sid=$cabq") <= 0){
      return (0, $lang->{'choose_board'});
  }
  my @selectedthreads = split("#", $selectedthreads);

  my ($ctype, $tmpmsg) = $self->_expire_threads(\@selectedthreads, $sid, $op);
  return (0, $tmpmsg) if $ctype == 0;
  
  my ($where, $where1);
  foreach (@selectedthreads){
      my $cid = $_; 
      $where .= "cid=$cid OR ";
  }
  $where =~ s/(.*) OR $/$1/g;
  
  my $data = {('sid'=>$cabq)};
  $spdb->db_update("Posts", $data, $where);
  $spdb->db_update("FileAttach", $data, $where);
  $spdb->db_update("MostParents", $data, $where);   
  
  my ($pids) = $spdb->db_select_many_new(1, "cid, pid", "Posts", $where);

  if($pids){
  
      while(my ($cid, $pid) = $pids->fetchrow_array){
	  if($spdb->db_count("Posts", "sid=$cabq AND cid=$pid") <= 0){
	      my $data = {('sid'=>$catandboard, 'cid'=>$cid)};
	      $spdb->db_insert("MostParents", $data);
	  }
	  else{
	      $spdb->db_delete("MostParents", "sid=$cabq AND cid=$cid");
	      $spdb->db_insert("ParentAndChild", {('parentid'=>$pid,
						   'childid'=>$cid)});
	  }
      }

      $spdb->db_handler_done($pids);

  }
  
  # --- update the ParentAndChild
  foreach (@selectedthreads){
      my $cid = $_;
      if($spdb->db_count("Posts", "sid=$cabq AND pid=$cid AND pid<>0") > 0){
	  # --- need to recover the branch
	  my ($ctype, $tmpmsg) = 
	      $self->_recover_thread($cid, $catandboard);
	  return (0, $tmpmsg) if $ctype==0;
      }
      
      my $mpid = $self->_select_the_most_parent($cid);
      $where1 .= "cid=$mpid OR ";
  }
  $where1 =~ s/(.*) OR $/$1/g;
  
  # --- update the replies field for the most parent
  my ($mpids) = $spdb->db_select_many_new(1, "cid", "MostParents", $where1);

  if($mpids){

      while ( my ($mpid) = $mpids->fetchrow_array){
	  my ($lcid, $cnt, $date) = $self->_select_the_least_child($mpid);
	  my $dateq = $DBH->quote($date);
	  my ($succ, $errmsg) = 
	      $spdb->db_update("MostParents", 
			       {('replies'=>$cnt, 'lastmod'=>$dateq)}, 
			       "cid=$mpid");
	  return (0, $errmsg) if !$succ;
      }
      
      $spdb->db_handler_done($mpids);

  }
      
  # --- update commentcount in Boards
  
  # -------------------------------------------------------------- #

  my $sidq = $DBH->quote($catandboard);
  my $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
  my $tlastmod = $spdb->db_max("date", "Posts", "approved=1 AND sid=$sidq");
  my ($succ, $errmsg) =
      $spdb->db_update("Boards", 
		       {('commentcount'=>$cnt1,
			 'lastmod'=>$DBH->quote($tlastmod))},
		       "sid=$sidq");
  
  # -------------------------------------------------------------- #
  
  $sidq = $DBH->quote($sid);
  $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
  $tlastmod = $spdb->db_max("date", "Posts", "approved=1 AND sid=$sidq");
  ($succ, $errmsg) =
      $spdb->db_update("Boards", 
		       {('commentcount'=>$cnt1,
			 'lastmod'=>$DBH->quote($tlastmod))},
		       "sid=$sidq");

  # -------------------------------------------------------------- #

  return (0, $errmsg) if !$succ;
  
  return (1, $lang->{'move_threads4'}, $lang->{'move_threads3'});
}

return 1;


