package SmallPig;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(@EXPORT_OK);
@EXPORT_OK = qw();

use SmallPigVars qw($config);

use strict;

sub add_br{
  my $body = shift;
  my @body = split('\n', $body);
  return join('<BR>', @body);
}

sub filter_quote{
  my $str = shift;
  $str =~ s/\"/&quot;/g;
  return $str;
}

sub filter_html{
  my $str = shift;
  $str =~ s/</&lt;/g;
  $str =~ s/>/&gt;/g;
  $str = filter_quote($str);
  return $str;
}

sub recover_quote{
  my $str = shift;
  $str =~ s/&quot;/\"/g;
  return $str;
}

sub recover_html{
  my $str = shift;
  $str =~ s/&lt;/</g;
  $str =~ s/&gt;/>/g;
  $str =~ s/&quot;/\"/g;
  return $str;
}

sub format_markup{
    my ($str) = @_;
    # --- format email address
    $str =~ s/\[email\s+([^\]]+)\](.+?)\[\/email\]/<A HREF=mailto:$1>$2<\/A>/gsi;
    $str =~ s/\[email\](.+?)\[\/email\]/<A HREF=mailto:$1>$1<\/A>/gsi;
    # --- format url 
    $str =~ s/\[url\s+([^\]]+)\](.+?)\[\/url\]/<A HREF=$1>$2<\/A>/gsi;
    $str =~ s/\[url\](.+?)\[\/url\]/<A HREF=$1>$1<\/A>/gsi;
    # --- format image
    $str =~ s/\[img\](.+?)\[\/img\]/<IMG SRC=$1 BORDER=0>/gsi;
    # --- format i
    $str =~ s/\[i\](.+?)\[\/i\]/<i>$1<\/i>/gsi;
    # --- format b
    $str =~ s/\[b\](.+?)\[\/b\]/<b>$1<\/b>/gsi;

    
    # --- Emoticons (mod from Marcus J. Ertl, 29.10.1999 --- 
    $str =~ s/\s+x-\(/<IMG SRC=\"$config->{imagesdir}\/smilies\/Mad2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+x\(/<IMG SRC=\"$config->{imagesdir}\/smilies\/Mad.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Happy.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:-\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Happy.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:\(/<IMG SRC=\"$config->{imagesdir}\/smilies\/Sad.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:-\(/<IMG SRC=\"$config->{imagesdir}\/smilies\/Sad.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+;\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Wilk.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+;-\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Wilk.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:P/<IMG SRC=\"$config->{imagesdir}\/smilies\/Tongue.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:-P/<IMG SRC=\"$config->{imagesdir}\/smilies\/Tongue.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+;P/<IMG SRC=\"$config->{imagesdir}\/smilies\/Tongue2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+;-P/<IMG SRC=\"$config->{imagesdir}\/smilies\/Tongue2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:O\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Embrass2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:O/<IMG SRC=\"$config->{imagesdir}\/smilies\/Embrass.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+\^_\^/<IMG SRC=\"$config->{imagesdir}\/smilies\/Sleep.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+\^\^;/<IMG SRC=\"$config->{imagesdir}\/smilies\/Sleep3.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+\^\^/<IMG SRC=\"$config->{imagesdir}\/smilies\/Sleep2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+8-\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Cool2.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+8\)/<IMG SRC=\"$config->{imagesdir}\/smilies\/Cool.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    $str =~ s/\s+:D/<IMG SRC=\"$config->{imagesdir}\/smilies\/TooHappy.gif\" WIDTH=14 HEIGHT=15>/gsi; 
    # --- end of mod 

    return $str;
}

sub recover_markup{
    my ($str) = @_;
    # --- format email address
    $str =~ s/\[email\](.+?)\[\/email\]/$1/gsi;
    $str =~ s/\[email\s+([^\]]+)\](.+?)\[\/email\]/$2 <$1>/gsi;
    # --- format url 
    $str =~ s/\[url\](.+?)\[\/url\]/$1/gsi;
    $str =~ s/\[url\s+([^\]]+)\](.+?)\[\/url\]/$2 ($1)/gsi;
    # --- format image
    $str =~ s/\[img\](.+?)\[\/img\]//gsi;
    # --- format i
    $str =~ s/\[i\](.+?)\[\/i\]/$1/gsi;
    # --- format b
    $str =~ s/\[b\](.+?)\[\/b\]/$1/gsi;
    return $str;
}

sub url_encode{
  my $words = shift;
  $words =~ s/([^a-zA-Z0-9_.-])/"%".sprintf("%1X", ord($1))/eg;
  return $words;
}

sub get_board_status{
  my $level = shift;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

sub load_module{
    eval "require $_[0]";
    $_[0]->import(@_[1 .. $#_]);
}

sub get_lang_ptr{
    my ($lang, $type) = @_;
    
    $lang ||= $config->{'lang'};
    
    my $thememod = "Langs::$lang\::$type";

    # --- load the theme module
    load_module($thememod);
    return get_lang();
}

sub get_spmail_config{
    if($config->{'spmail_cgi'} && -d $config->{'spmail_cgi'}){
	unshift(@INC, $config->{'spmail_cgi'});
	
	require SpmailVars;
	SpmailVars->import();

	return get_mconfig();
    }

    return undef;
}

sub get_spmail_lang{
    if($config->{'spmail_cgi'} && -d $config->{'spmail_cgi'}){
	unshift(@INC, $config->{'spmail_cgi'});
	
	require SpmailLang;
	SpmailLang->import();

	return get_mlang();
    }

    return undef;
}

sub send_mail{
  my ($addr, $from, $subject, $content, $replyto, $lang) = @_;

  # --- if there is no recipient address
  return if !$addr;

  require HTML::TreeBuilder;
  require HTML::FormatText;
  
  $content =~ s/\n/<BR>/gi;
  my $html = HTML::TreeBuilder->new();
  $html->parse($content);
  my $formatter = HTML::FormatText->new(leftmargin=>0, 
					rightmargin=>76);
  $content = $formatter->format($html);

  if($config->{'smtpserver'}){
      require Net::SMTP;
      
      my $smtp = Net::SMTP->new($config->{'smtpserver'});
      if(!$smtp){
	  return (0, $@);
      }
      $smtp->mail($from);
      
      $smtp->to($addr);
      $smtp->data();
      $smtp->datasend("Subject: $subject\n");
      $smtp->datasend("To: $addr\n");
      $smtp->datasend("Reply-To: $replyto\n") if $replyto;
      $smtp->datasend("\n");
      $smtp->datasend($content);
      $smtp->dataend();
      $smtp->quit;
  }
  elsif($config->{'sendmail'}){
      local $ENV{PATH};
      unless(open MAIL, "|$config->{'sendmail'} -oi -t"){
	  return (0, "");
      }

      print MAIL "To: ", $addr, "\n";
      print MAIL "From: ", $from, "\n";
      print MAIL "Subject: ", $subject, "\n";
      print MAIL "Reply-To: $replyto\n\n" if $replyto;
      print MAIL "$content";
      close MAIL;
  }
  else{ return (0, $lang->{'no_mail_server'}); }
  
  return (1, "");
}

return 1;


