package Templates::CommentsNC;

use SmallPigVars qw($config);
use Templates::Default;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::Default);

my $lang;

sub new{
  my ($class, $spcgi, $spdb) = @_;

  $template = Templates::Default->new($spcgi, $spdb);

  $template->{'spcgi'} ||= $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} ||= $spdb;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

sub print_file_att{
  my ($template) = @_;
  my ($STATE, $spdb, $files_info) = 
      map{ $template->{$_} } qw(STATE spdb files_info_dont_show);
  my $theme = $template->{'theme'};
  
  my $fsize = $template->_comp_byte($config->{'file_size'});
  $files_info .= qq!
<BR>$lang->{'note'}: 
<i>$lang->{'max_file'} $config->{'file_max'} $lang->{'files'}.<BR>
$lang->{'total_file'} $fsize.</i>
    !;

  $files_info =
"<B>$lang->{'file_att'}:</B><BR>$files_info";

  $template->print_msg("", 1, "", $files_info, 
		       $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
}

sub print_new_comment_form{
  my ($self) = @_;
  my ($STATE, $spdb) = map{$self->{$_}} qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  
  my ($username, $fakeemail, $nickname, $uid, $userstatus, $sid,
      $subject, $body, $sig, $op, $prev_op, $cid, $emailreply) = 
    map{ $STATE->{$_} } 
  qw(username fakeemail nickname uid userstatus sid subject 
     body sig op prev_op cid emailreply);
  $prev_op ||= $op;

  # --- edit post
  if($op eq "editpost" && $cid){
    ($subject, $body, $emailreply) = 
      $spdb->db_select_cols("subject, bodytext, emailreply", 
			   "Posts", "cid=$cid");
    ($nickname, $fakeemail, $uid) = 
      $spdb->db_select_cols("nickname, fakeemail, U.uid",
			   "Posts AS P, Users AS U", 
			   "P.uid=U.uid AND cid=$cid AND U.active=1");
    $emailreply = ($emailreply)?"yes":"";
  }
  my ($bodyq);
  # --- reply
  if($op eq "reply"){
      $subject = $template->{'rsubject'};
      if($subject !~ /^Re:/){
	  $subject = "Re: $subject";
      }
  }
  $nickname = $template->filter_quote($nickname);
  $fakeemail = $template->filter_quote($fakeemail);
  $subject = $template->filter_quote($subject);

  my $nicknamep = qq|<INPUT TYPE="text" name='poster' size=35 value="$nickname">|;
  my $fakeemailp = qq|<INPUT TYPE="text" name='posteremail' size=35 value="$fakeemail">|;
  my $subjectp = qq|<INPUT TYPE="text" name='subject' size=35 value="$subject">|;

  my ($html, $markup) = $template->allow_html_markup($sid);
  
  my $hm = qq|<li> <a href="javascript:openWindow('$config->{cgidir}/default.cgi?dpage=markuphelp');">$lang->{'markup'}</a> $lang->{'is_allowed'}| if $markup;
  $hm .= "<li>$lang->{'html_enabled'}" if $html;
  $hm .= "<br>" if $html || $markup;

  $body = $template->filter_quote($body);
  $body = $template->filter_html($body) unless $html;
  
  my $checked;
  if($emailreply eq "yes"){
      $checked = "checked";
  }

  # --- reply
  my $btitle;
  if($op eq "reply" || $prev_op =~ /reply/){
      $btitle = $lang->{'reply_post'};
  }
  elsif($op eq "editpost" || $prev_op =~ /editpost/){
      $btitle = $lang->{'edit_post'};
  }
  else{
      $btitle = $lang->{'new_post'};
  }

  $template->SUPER::print_block_start("","", $btitle);

  print qq|
      <TR><TD>
      <TABLE BORDER=0 CELLPADDING=10><TR><TD><font size="1">
          <script language="JavaScript">
	  <!-- hide from JavaScript-challenged browsers

	      function openWindow(url) {
		  popupWin = window.open(url, 'remote',  'scrollbars,resizable,dependent,width=400,height=400,left=10,top=10')
		  }
  
            // done hiding -->
		</script>

	  <B>$lang->{'nick_name1'}:</B>($lang->{'leave_blank'})<br>$nicknamep<BR>
	      <B>$lang->{'loginemail'}:</B>($lang->{'leave_blank'})<br>$fakeemailp<BR>
		  <B>$lang->{'subject'}:</B><BR>$subjectp<BR><BR>
      <B>$lang->{'post'}:</B><BR>$hm
	  <TEXTAREA NAME=body ROWS=8 COLS=45 WRAP=virtual>$body</TEXTAREA><BR>
	      $lang->{'email_me_reply'}
		  <INPUT TYPE=checkbox NAME=emailreply VALUE="yes" $checked></font>
		      |;
  print "<BR></TD></TR></TABLE></TD></TR>";
  
  $template->SUPER::print_block_end();
}

sub _set_files_info{
  my ($self, $fids) = @_;
  my ($spdb) = map{ $self->{$_} } qw(spdb);
  my ($files_info, $files_info_dont_show);
  my $theme = $template->{'theme'};

  if(!$fids){
      $files_info = "$lang->{'no_file_att'}.<BR>";
      $files_info_dont_show = "$lang->{'no_file_att'}.<BR>";
  }
  else{
      my @fids = split(/\#/, $fids);
      my $where;
      foreach (@fids){
	  $where .= "fid=$_ OR ";
      }
      $where =~ s/(.+) OR $/$1/;
      
      my ($files) = 
	  $spdb->db_select_many_new(1, 
				    "fid, fname, date, fsize, fdesc",
				    "FileAttach", $where);
      
      if($files){

	  while (my ($fid, $fname, $date, $fsize, $fdesc) = $files->fetchrow_array){
	      my $fnameurl1 = $self->_file_encode($date, $fname);
	      my $fnameurl = qq|<a href="$config->{'file_url'}/$fnameurl1">$fname</a>|;
	      my $img = qq|<INPUT TYPE="image" name="DeleteFile $fname($fid)" border=0 src="$theme->{'imagesdir'}/delete_file.gif">|;
	      $files_info_dont_show .= "$img $fnameurl $fsize $lang->{'bytes'} $fdesc<BR>";
	      $fnameurl = "<B>$fname</B>";
	      $files_info .= "$fnameurl $fsize $lang->{'bytes'} $fdesc<BR>";
	  }

	  $spdb->db_handler_done($files);
      
      }
  
  }
  $self->{'files_info'} = $files_info;
  $self->{'files_info_dont_show'} = $files_info_dont_show;
}

#############################################################################
# --- private functions
# ---
#############################################################################
sub _file_encode{
  my ($self, $date, $fname) = @_;
  $date =~ s/\s+/-/g;
  $fname =~ s/(\s+|\\)/-/g;
  return "$date-$fname";
}

sub _comp_byte{
  my ($self, $size) = @_;
  if($size != -1){
      $size = $size / 1000;
      if($size =~ /^((\d{2}|\d{1}|\d{3})\.\d).+/ || $size =~ /^(\d{2})\.0+$/){
	  $size = $1."k";
      }
      else{
	  $size = $size / 1000;
	  $size =~ s/(\d+\.\d).+/$1/;
	  $size .= "M";
      }
  }
  return $size;
}

return 1;


