package Templates::Index;

use SmallPigVars qw($config);
use SPDB;
use Templates::Default;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::Default);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::Default->new($spcgi, $spdb, $pagetype);

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  $template->{'title'} = "";
  $template->{'refresh'} = "";

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  $template->SUPER::print_standard_index();
  $template->print_iconbar(); 
  $template->print_space();
  $template->print_forums_list(); 
  $template->print_adjust_font();
}

sub print_iconbar{
  my ($template) = @_;
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $theme = $template->{'theme'};

  my $userstatus = $STATE->{'userstatus'};
  my $DBH = $spdb->{'dbh'};

  my ($sp, $mp, $se);

  if($userstatus ne "anon"){
      $sp = qq|<img alt="$lang->{'show_new_posts'}" border=0 src="$theme->{'imagesdir'}/$theme->{'shownewposts_image'}">|;
      $mp = qq|<img alt="$lang->{'mark_all_threads3'}" border=0 src="$theme->{'imagesdir'}/$theme->{'markallposts_image'}">|;
      $sp = qq|<a href="$config->{'cgidir'}/index.cgi?op=shownewposts">$sp</a>|;
      $mp = qq|<a href="$config->{'cgidir'}/index.cgi?op=markallthreads">$mp</a>|;
  }
  else{
      $sp = qq|<img alt="$lang->{'show_new_posts'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'shownewposts_image'}">|;
      $mp = qq|<img alt="$lang->{'mark_all_threads3'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'markallposts_image'}">|;
  }

  $se = qq|<a href="$config->{'cgidir'}/search.cgi"><img alt="$lang->{'search'}" border=0 src="$theme->{'imagesdir'}/$theme->{'search_image'}"></a>|;

  $template->print_block_start($theme->{'dhdrcolor'}, $theme->{'dhdrcolor'});
  print qq|<TR><TD ALIGN="left">$sp&nbsp;$mp&nbsp;&nbsp;$se</TD>|;
  $template->print_block_end();
}

sub print_forums_list{
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $theme = $template->{'theme'};
  
  $template->SUPER::print_block_start();

  my ($view, $lastlogon, $uid, $username, $userstatus, $op, $nps) = 
      map{ $STATE->{$_} } 
  qw(view lastlogon uid username userstatus op nps);
  my $lastlogonq = $DBH->quote($lastlogon);
  
  my ($cats) = $spdb->db_select_many_new(1, "catid, cattitle",
					 "Cats",
					 "", 
					 "ORDER BY catorder");

  # --- print btitle
  print btitle();

  # --- if there is no categories
  unless($cats){
      print  "<TR><TD colspan=4>$lang->{'no_categories'}</TD></TR>"
  }
  else{
  # --- loop through all the categories
  my $has_board = 0;
  while (my ($catid, $cattitle) = $cats->fetchrow_array){      
      my $catidq = $DBH->quote($catid);
      
      my $select = "B.sid, title, commentcount,  
                    date_format(lastmod, \"$config->{date_format}\"),
                    introtext, active, sorder";
      my $where = " B.sid=BC.sid AND BC.catid=$catidq ";
    
      # --- only public forum visible for anon
      $where .= "AND level>=60 AND active=1 "
	  if($userstatus eq "anon");
    
      # --- user forum visible for ruser, gmem, mod
      $where .= "AND level>=48 AND active=1 "
	  if($userstatus eq "ruser" ||
	     $userstatus =~ /gmem/ ||
	     $userstatus =~ /mod/);

      my ($boards, $from);
      $from .= " Boards AS B, BoardBelongToCat AS BC";

      # --- select public and user forums
      ($boards) = $spdb->db_select_many(1, 
					$select, 
					$from, 
					$where);
      
      # --- if user is a moderator in group private forums
      if($userstatus =~ /mod/){
	  $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                    (level=32) AND B.sid=M.sid AND
                    BC.catid=$catidq ";
	  $from = "Boards AS B, BoardBelongToCat AS BC, Moderators AS M";
	  my ($boards1) = 
	      $spdb->db_select_many(1, $select, $from, $where);
	  unshift @$boards, @$boards1 if $boards1;      
      }
      
      # --- if user is a group mem in group private forums
      if($userstatus =~ /gmem/){
	  $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                    (level=32) AND B.sid=M.sid AND
                    BC.catid=$catidq ";
	  $from = "Boards AS B, BoardBelongToCat AS BC, GroupMems AS M";
	  my ($boards1) = 
	      $spdb->db_select_many(1, $select, $from, $where);
	  unshift @$boards, @$boards1 if $boards1;      
      }    

      # --- sort the boards by sorder
      @$boards = sort { $a->[6] <=> $b->[6]; } @$boards if $boards;

      # --- no forums
      if(!$boards){
	  print qq| 
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD COLSPAN=4>
    <B>$cattitle</B>
  </TD>
</TR>  
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH=10 BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;
</TD><TD COLSPAN=3>
  $lang->{'no_forums'}</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
  <TD COLSPAN=3></TD></TR>
      | if $config->{'display_no_forums'} eq "yes";

      }
      # --- has forums
      else {
	  $has_board = 1;
    # --- display cattitle
	print qq!
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD CLASS=lbheader2 COLSPAN=4>
    <B>$cattitle</B>
  </TD>
      </TR>  
	  !;
	  
	  my $cnt = 0;
	  
	  foreach (@$boards) {
	      my ($sid, $title, $commentcount, $lastmod, $introtext) = @$_;
	      
	      $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
	      
	      my $sidq = $DBH->quote($sid);
	      $cnt++;
	      $lastmod = $lang->{'no_posts'} unless $lastmod;
	      
	      my $newpost;
	      
	      # --- deal with the cookie
	      if($userstatus ne "anon" && $lastlogon) {
		  my $cnt1 = $template->count_new_posts($sid, $nps);
		  
		  $newpost = "<b><FONT class=\"caution\">($cnt1 $lang->{'new'})</FONT></B>" 
		      if $cnt1;
	      }# --- end dealing with cookie
		  
		  # --- encode sid
		  my $sid1 = $template->url_encode($sid);
	      # --- deal with url and posts
	      my ($url, $tmp);
	      $url = "comments.cgi?op=topicslist&page=1&sid=$sid1&view=$view";
	      
	      $tmp = "<B>$title</B>";
	      $tmp = "<a href=\"$config->{'cgidir'}/$url\">$tmp</a>"
		  if($commentcount || (!$commentcount));
	      print bcontent($tmp, $commentcount, $newpost, 
			     $lastmod, $introtext, $sid, $uid);
	  }
	  unless($cnt){
	      print qq| 
<TR><TD WIDTH=10>&nbsp;</TD><TD COLSPAN=3>$lang->{'no_forums'}</TD></TR> 
    |;
	  }
      }
  } # --- end cats

  $spdb->db_handler_done($cats);

  } 
  $template->SUPER::print_block_end();
}

sub btitle{
  my $theme = $template->{'theme'};
  my $ret = qq| 
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
  <TD WIDTH=$theme->{'empty_w'}>&nbsp;</TD>
  <TD CLASS=bheader2 WIDTH=$theme->{'forums_w'}>$lang->{'forums'}</TD>
  <TD WIDTH=$theme->{'posts_w'} CLASS=bheader2>$lang->{'posts'}</TD>
  <TD WIDTH=$theme->{'lastpost_w'} CLASS=bheader2>$lang->{'lastpost'}</TD>
</TR>
    |;
  return $ret;
}

sub bcontent{
  my ($title, $cnt, $np, $lastmod, $intro) = @_;
  my $theme = $template->{'theme'};
  my $ret .= qq!
<TR BGCOLOR=$theme->{'llhdrcolor'}>
  <TD WIDTH=$theme->{'empty_w'} BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'forums_w'}>$title</TD>
  <TD WIDTH=$theme->{'posts_w'}>$cnt $np</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>$lastmod</TD></TR>
<TR BGCOLOR=$theme->{'llhdrcolor'}>
  <TD WIDTH=$theme->{'empty_w'} BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'forums_w'}>$intro</TD>
  <TD WIDTH=$theme->{'posts_w'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>&nbsp;</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
  <TD COLSPAN=3>
</TD></TR>
  !;	
  return $ret;
}

return 1;


