package Templates::Subscription;

use SmallPigVars qw($config);
use SPDB;
use Templates::User;

use strict;
use vars qw(@ISA $template $lang);

@ISA = qw(Templates::User);

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::User->new($spcgi, $spdb, $pagetype);

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'subscription'} = \&subscription;
  $pagesubs->{'subscribe'} = \&subscribe;
  $pagesubs->{'editsub'} = \&editsub;
  
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub subscription{
    my $theme = $template->{'theme'};
    my $name = "subscribe";
    print qq^
	<script language="JavaScript">
	    <!--
		function CheckX(){
		    document.$name.selectedthreads1.checked = !document.$name.selectedthreads1.checked;
		    CheckAll();
		}
    function CheckAll(){
	for (var i=0;i<document.$name.elements.length;i++){
	    var e=document.$name.elements[i];
	    if (e.name != 'selectedthreads1')
		e.checked=document.$name.selectedthreads1.checked;
	}
    }
    //-->
	</script>
	    ^;

    print qq|<form action="$config->{'cgidir'}/user.cgi" name="subscribe" method="post">|;
    $template->print_user_index();

    $template->print_msg("header1", 1, "", $lang->{'subscribe3'},
			 $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
    $template->print_msg("header2", 1, "", $lang->{'sel_forums'},
			 $theme->{'inbgcolor'}, $theme->{'inbgcolor'});

    $template->print_forums_list();

    print qq|<font size ="1"><input type="submit" name="op" value=$lang->{'Subscribe'}></font></form>|;
}

sub print_forums_list{
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $theme = $template->{'theme'};
  
  $template->SUPER::print_block_start();

  my ($view, $lastlogon, $uid, $username, $userstatus, $op, $nps) = 
      map{ $STATE->{$_} } 
  qw(view lastlogon uid username userstatus op nps);
  my $lastlogonq = $DBH->quote($lastlogon);
  
  my ($cats) = $spdb->db_select_many_new(1, "catid, cattitle",
					 "Cats",
					 "", 
					 "ORDER BY catorder");

  # --- print btitle
  print btitle1();

  # --- if there is no categories
  unless($cats){
      print "<TR><TD colspan=4>$lang->{'no_categories'}</TD></TR>";
  }
  else{
  # --- loop through all the categories
  my $has_board = 0;
  while ( my ($catid, $cattitle) = $cats->fetchrow_array){
      my $catidq = $DBH->quote($catid);
      
      my $select = "B.sid, title, commentcount,  
                    date_format(lastmod, \"$config->{date_format}\"),
                    introtext, active, sorder";
      my $where = " B.sid=BC.sid AND BC.catid=$catidq ";
    
      # --- only public forum visible for anon
      $where .= "AND level>=60 AND active=1 "
	  if($userstatus eq "anon");
    
      # --- user forum visible for ruser, gmem, mod
      $where .= "AND level>=48 AND active=1 "
	  if($userstatus eq "ruser" ||
	     $userstatus =~ /gmem/ ||
	     $userstatus =~ /mod/);

      my ($boards, $from);
      $from .= " Boards AS B, BoardBelongToCat AS BC";

      # --- select public and user forums
      ($boards) = $spdb->db_select_many(1, 
					$select, 
					$from, 
					$where);
      
      # --- if user is a moderator in group private forums
      if($userstatus =~ /mod/){
	  $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                    (level=32) AND B.sid=M.sid AND
                    BC.catid=$catidq ";
	  $from = "Boards AS B, BoardBelongToCat AS BC, Moderators AS M";
	  my ($boards1) = 
	      $spdb->db_select_many(1, $select, $from, $where);
	  unshift @$boards, @$boards1 if $boards1;      
      }
      
      # --- if user is a group mem in group private forums
      if($userstatus =~ /gmem/){
	  $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                    (level=32) AND B.sid=M.sid AND
                    BC.catid=$catidq ";
	  $from = "Boards AS B, BoardBelongToCat AS BC, GroupMems AS M";
	  my ($boards1) = 
	      $spdb->db_select_many(1, $select, $from, $where);
	  unshift @$boards, @$boards1 if $boards1;      
      }    

      # --- sort the boards by sorder
      @$boards = sort { $a->[6] <=> $b->[6]; } @$boards if $boards;

      # --- no forums
      if(!$boards){
	  print qq| 
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD COLSPAN=4>
    <B>$cattitle</B>
  </TD>
</TR>  
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH="2%" BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;
</TD><TD COLSPAN=3>
  $lang->{'no_forums'}</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=2%></TD>
  <TD COLSPAN=3></TD></TR>
      | if $config->{'display_no_forums'} eq "yes";

      }
      # --- has forums
      else {
	  $has_board = 1;
    # --- display cattitle
	print qq!
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD CLASS=lbheader2 COLSPAN=4>
    <B>$cattitle</B>
  </TD>
      </TR>  
	  !;
	  
	  my $cnt = 0;
	  
	  foreach (@$boards) {
	      my ($sid, $title, $commentcount, $lastmod, $introtext) = @$_;
	      
	      $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
	      
	      my $sidq = $DBH->quote($sid);
	      $cnt++;
	      $lastmod = $lang->{'no_posts'} unless $lastmod;
	      
	      my $newpost;
	      
	      # --- deal with the cookie
	      if($userstatus ne "anon" && $lastlogon) {
		  my $cnt1 = $template->count_new_posts($sid, $nps);
		  
		  $newpost = "<b><FONT class=\"caution\">($cnt1 $lang->{'new'})</FONT></B>" 
		      if $cnt1;
	      }# --- end dealing with cookie
		  
		  # --- encode sid
		  my $sid1 = $template->url_encode($sid);
	      # --- deal with url and posts
	      my ($url, $tmp);
	      $url = "comments.cgi?op=topicslist&page=1&sid=$sid1&view=$view";
	      
	      $tmp = "<B>$title</B>";
	      $tmp = "<a href=\"$config->{'cgidir'}/$url\">$tmp</a>"
		  if($commentcount || (!$commentcount));
	      print bcontent1($tmp, $commentcount, $newpost, 
			     $lastmod, $introtext, $sid, $uid);
	  }
	  unless($cnt){
	      print qq| 
<TR><TD WIDTH=2%>&nbsp;</TD><TD COLSPAN=3>$lang->{'no_forums'}</TD></TR> 
    |;
	  }
      }
  } # --- end cats

  $spdb->db_handler_done($cats);

  }
  print bcontent2();
  
  $template->SUPER::print_block_end();
}

sub btitle1{
    my $theme = $template->{'theme'};
  my $select = qq|
<td width=2% align="center">
    <a href="javascript:CheckX()" 
	onMouseOver="window.status='Select all displayed messages'; 
return true;" onMouseOut="window.status=' '; return true;">
    <b>X</b></a></td>|;
  my $ret = qq| 
      <TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
	  $select  
	      <TD CLASS=bheader2 WIDTH=60%>$lang->{'forums'}</TD>
		  <TD WIDTH=20% CLASS=bheader2>$lang->{'posts'}</TD>
		      <TD WIDTH=20% CLASS=bheader2>$lang->{'lastpost'}</TD>
			  </TR>
    |;
}

sub bcontent1{
  my ($title, $cnt, $np, $lastmod, $intro, $sid, $uid) = @_;
  my $spdb = $template->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $template->{'theme'};

  my $select = "&nbsp;";

  my $sidq = $DBH->quote($sid);
  my ($sub) = $spdb->db_select_cols("subscription", "Boards", "sid=$sidq");
  
  my $msg;
  $msg = "($lang->{'not_allow_sub'})" if !$sub;

  my $num2 = $spdb->db_count("SubscribeBoard", "sid=$sidq AND uid=$uid");
  $msg = "($lang->{'subscribed'})" if $num2;
  $select = "<font size=1><input type=checkbox name=selectedforums value=\"$sid\"></font>" 
    if $sub && !$num2;
  $select = qq|<td width=2% bgcolor=$theme->{'lhdrcolor'}>$select</td>|;

  my $ret .= qq!
<TR BGCOLOR=$theme->{'llhdrcolor'}>
    $select
  <TD WIDTH=$theme->{'forums_w'}>$title $msg</TD>
  <TD WIDTH=$theme->{'posts_w'}>$cnt $np</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>$lastmod</TD></TR>
<TR BGCOLOR=$theme->{'llhdrcolor'}>
  <TD WIDTH=$theme->{'empty_w'} BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'forums_w'}>$intro</TD>
  <TD WIDTH=$theme->{'posts_w'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>&nbsp;</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=2%></TD>
  <TD COLSPAN=3>
</TD></TR>
  !;	
  return $ret;
}

sub bcontent2{
  my $ret .= qq!
<TR>
<TD>
<font size=1><INPUT NAME=selectedthreads1 TYPE=checkbox onClick="CheckAll();"></font>
</TD>
<TD COLSPAN=3>$lang->{'sel_all_forums'}
</TD>
<TR>
  !;	
  return $ret;
}

sub subscribe{
    my $theme = $template->{'theme'};
    $template->print_user_index();
    
    my $spdb = $template->{'spdb'};
    my $STATE = $template->{'STATE'};
    my $uid = $STATE->{'uid'};

    my $cnt1 = $spdb->db_count("Boards", "subscription=1");
    my $cnt2 = $spdb->db_count("SubscribeBoard", "uid=$uid");
    
    $template->print_msg("header1", 1, "", $lang->{'user_subscription1'},
			 $theme->{'inbgcolor'}, $theme->{'inbgcolor'});

    my $msg;
    $msg = $lang->{'user_subscription2'}."<BR>";
    $msg .= qq|<a href="$config->{'cgidir'}/user.cgi?op=subscribe">
	$lang->{'subscribe1'}</a>| if($cnt1 - $cnt2 > 0);

    $template->print_msg("header2", 1, "", $msg,
			 $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
    
    $template->print_sub_boards();
}

sub print_sub_boards{
  my ($self) = @_;
  my $spdb = $self->{'spdb'};
  my $theme = $template->{'theme'};

  $template->SUPER::print_block_start();

  my $STATE = $self->{'STATE'};
  my ($uid, $view) = map{ $STATE->{$_} } qw(uid view);
  my $select = "B.sid, title";
  # --- select public and user forums
  my ($boards) = 
    $spdb->db_select_many_new(1, $select,
			      "SubscribeBoard AS SB, Boards AS B",
			      "uid=$uid AND SB.sid=B.sid");
  print btitle2();  
  # --- no forums
  unless($boards){
    print qq| 
<TR BGCOLOR=$theme->{'boxbgcolor'}>
<TD COLSPAN=4>$lang->{'no_forums'}</TD></TR>|;
  }
  else{ 
    my $cnt = 0;
    while ( my ($sid, $title) = $boards->fetchrow_array) {
      $cnt++;
      # --- encode sid
      my $sid1 = $self->url_encode($sid);
      my $url = "comments.cgi?op=topicslist&page=1&sid=$sid1&view=$view";
      my $tmp = "<B>$title</B>";
      $tmp = qq|<a href="$config->{'cgidir'}/$url">$tmp</a>|;
      print bcontent3($tmp, undef, undef, undef, undef, $sid);      
    }

    $spdb->db_handler_done($boards);

    unless($cnt){
      print qq| 
<TR><TD WIDTH=10>&nbsp;</TD><TD COLSPAN=4>$lang->{'no_forums'}</TD></TR> 
  |;
    }
  }

  $template->SUPER::print_block_end();
}

sub btitle2{
    my $theme = $template->{'theme'};
  my $ret = qq| 
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
  <TD CLASS=bheader2 WIDTH=70%>$lang->{'forums'}</TD>
  <TD WIDTH=10% CLASS=bheader2>$lang->{'post'}</TD>
  <TD WIDTH=10% CLASS=bheader2>$lang->{'edit'}</TD>
  <TD WIDTH=10% CLASS=bheader2>$lang->{'unsubscribe'}</TD>
</TR>
    |;
}

sub bcontent3{
  my ($title, $cnt, $np, $lastmod, $intro, $sid) = @_;
  my ($post, $edit, $unsub);
  my $theme = $template->{'theme'};
  $np = "($np)" if $np;
  $post = qq|<a href="$config->{'cgidir'}/comments.cgi?op=newpost&sid=$sid">P</a>|;
  $edit = qq|<a href="$config->{'cgidir'}/user.cgi?op=editsub&sid=$sid">E</a>|;
  $unsub = qq|<a href="$config->{'cgidir'}/user.cgi?op=unsubscribe&sid=$sid">U</a>|;

  my $ret .= qq!
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH=70%>&nbsp;$title $np</TD>
  <TD WIDTH=10%>$post</TD>
  <TD WIDTH=10%>$edit</TD>
  <TD WIDTH=10%>$unsub</TD>
</TR>
  !;	
  return $ret;
}

sub editsub{
  my ($self) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my $STATE = $self->{'STATE'};
  my ($sid, $uid) = map{ $STATE->{$_} } qw(sid uid);
  my $sidq = $DBH->quote($sid);
  my ($title) = $spdb->db_select_cols("title", "Boards", "sid=$sidq");

  print qq|<form method="post" action="$config->{'cgidir'}/user.cgi">|;

  $template->print_user_index();
  $template->print_sub_options();
  print qq|<input type="hidden" name="sid" value=$sid><input type="hidden" name="uid" value=$uid> 
      <font size=1><input type="submit" name="op" value=$lang->{'SaveSubscription'}></font></form>|;
}

sub print_sub_options{
  my ($self) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'}; 

  $template->SUPER::print_block_start();

  my $STATE = $self->{'STATE'};
  my ($sid, $uid) = map{ $STATE->{$_} } qw(sid uid);
  my $sidq = $DBH->quote($sid);
  my ($eformat) = $spdb->db_select_cols("eformat", "SubscribeBoard", 
				       "sid=$sidq AND uid=$uid");
  my ($ret, $content);
  $content = "<B>$lang->{'email_format'}:</B><BR>";
  $content .= $template->select_option({('Daily Summary'=>1,
					'Daily Digest'=>2,
					'Individual Messages'=>4)},
				       'seformat', $eformat);
  print qq|<tr><td>
      <table border=0 cellpadding=0>
	  <tr><td><font size=1>$content</font></td></tr>
	      </table>
		  </td></tr>|;
  $template->SUPER::print_block_end();
}

return 1;


