package Templates::TopicsList;

use SmallPigVars qw($config);
use SPDB;
use Templates::CommentsTL;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::CommentsTL);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::CommentsTL->new($spcgi, $spdb, $pagetype);

  $template->{'spcgi'} = $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  $template->{'title'} = "";
  $template->{'refresh'} = "";

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  $pagefiles->{'shownewposts'} = "shownewposts.temp";

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  $pagesubs->{'printable'} = \&printable;
  
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  $template->print_standard_index();

  $template->print_boardinfo();
  
  # --- get the list pointer
  ($template->{'tlptr'}, $template->{'totalnums'}) = $template->_list_ptr();

  $template->print_iconbar();
  $template->print_space();
  $template->print_topicslist();
  $template->print_page_index($template->{'totalnums'});  
  $template->print_adjust_font();
}

sub printable{
    $template->print_boardinfo();
     # --- get the list pointer
    ($template->{'tlptr'}, $template->{'totalnums'}) = $template->_list_ptr();
    $template->print_topicslist();
}

sub print_boardinfo{
  my ($template) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $template->{'theme'};

  my ($sid, $sort, $mode, $postsper) = 
    map{ $STATE->{$_} } qw(sid sort mode postsper);
  
  my $sid_q = $DBH->quote($sid);

  # --- get the board information
  my $select = "title, level, approved, introtext";
  my ($title, $level, $approved, $intro) =
    $spdb->db_select_cols($select, "Boards", "sid=$sid_q");
  
  # --- update board hits
  $spdb->db_update("Boards", {('hits'=>'hits+1')}, "sid=$sid_q"); 

  # --- get the moderators of this board
  $select = "DISTINCT U.uid, nickname, privlev, fakeemail";
  my $from = "Users AS U, Moderators AS M";
  my $where = "sid=$sid_q AND M.uid = U.uid AND U.active ";
  
  my ($mods) = $spdb->db_select_many_new(1, $select, $from, $where);
 
  $sort .= "ending";
  
  my $userinfo;
  if($mods){
      
      while (my ($uid, $username, $privlev, $fakeemail) = $mods->fetchrow_array){
	  if($privlev==0){
	      $userinfo .= qq|<a href="$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper" class=bheader>$username</a>|;
	  }
	  else{
	      $userinfo .= qq|$username|;
	  }
	  $userinfo .= " / ";
      }
      
      $spdb->db_handler_done($mods);
	  
	  $userinfo =~ s/(.*) \/ $/$1/i;
  }
  my $status = $template->get_board_status($level);

  my $ret;
  if($mode eq "printable"){
    print qq|
<tr width="100%"><td class=header1>
$config->{'title'}
<HR>
<B>$title</B><BR>
<LI>$lang->{'sorted_by'} $sort<BR>
<LI>$lang->{'board_is'} $status<BR>
<LI>$lang->{'moderators'}: $userinfo 
<HR>
</td></tr>
  |;
  }
  else{
      # --- print the information!!!!!!!!!!!!!
      $template->SUPER::print_block_start($theme->{'dhdrcolor'},
					  $theme->{'dhdrcolor'});
      print qq|
	  <TR width="100%">
	      <TD width="40%" class=bheader2nb><B>$title</B><BR>$intro</TD>
		  <TD width="30%">&nbsp;</TD>
		      <TD width="30%" align="right" valign="top" class=bheader2nb>$lang->{'moderators'}: $userinfo&nbsp;<BR>$lang->{'access'}: $status&nbsp;</TD>
			  </TR>|;
	
      $template->print_block_end();
  }
  
}

sub print_iconbar{
  my ($self) = @_;
  my ($STATE, $spdb, $totalnums) = map{ $self->{$_} } qw(STATE spdb totalnums);
  my $theme = $template->{'theme'};

  my ($can_write, 
      $cgi, $op, $sort, $postsper, $page, $sid, $view,
      $cid, $display, $pid, $words, $match, $ssid, 
      $mode, $userstatus) = 
    map { $STATE->{$_ } } 
  qw(can_write cgi op sort postsper page sid view 
     cid display pid words match ssid mode userstatus);
  $page ||= 1;
  $cgi = $ENV{SCRIPT_NAME};
  my $referer = $ENV{HTTP_REFERER};
  # --- encode sid
  my $sid1 = $sid;
  $sid = $template->url_encode($sid);
  # --- encode sort
  my $sort1 = $sort;
  $sort = $template->url_encode($sort);
  
  my ($cw, $sp, $mp, $d, $pp, $np, $all, $vad, $p, $se);
 
  # --- new post
  if($can_write){
      $cw = qq|<a href="$config->{'cgidir'}/comments.cgi?op=newpost&sid=$sid"><img alt="$lang->{'make_new_post'}" border=0 src="$theme->{'imagesdir'}/$theme->{'post_image'}"></a>|; 
  }
  else{
      $cw = qq|<img border=0 alt="$lang->{'make_new_post'} ($lang->{'disabled'})" src="$theme->{'imagesdir'}/$theme->{'post_image'}">|;
  }
  
  if($mode eq "shownewposts" && $userstatus ne "anon"){
      $sp = qq|<a href="$config->{'cgidir'}/comments.cgi?op=topicslist&page=1&sid=$sid&view=$view"><img alt="$lang->{'show_all_posts'}" border=0 src="$theme->{'imagesdir'}/$theme->{'showallposts_image'}"></a>|;
  }
  elsif($userstatus ne "anon"){
      $sp = qq|<a href="$config->{'cgidir'}/comments.cgi?op=topicslist&page=1&sid=$sid&view=$view&mode=shownewposts"><img alt="$lang->{'show_new_posts'}" border=0 src="$theme->{'imagesdir'}/$theme->{'shownewposts_image'}"></a>|;
  }
  else{
      $sp = qq|<img border=0  alt="$lang->{'show_new_posts'} ($lang->{'disabled'})"  src="$theme->{'imagesdir'}/$theme->{'shownewposts_image'}">|;
  }
  
  if($userstatus ne "anon"){
      $mp = qq|<a href="$config->{'cgidir'}/comments.cgi?op=markallthreads&sid=$sid"><img alt="$lang->{'mark_all_threads3'}" border=0 src="$theme->{'imagesdir'}/$theme->{'markallposts_image'}"></a>|;
  }
  else{
      $mp = qq|<img border=0  alt="$lang->{'mark_all_threads3'} ($lang->{'disabled'})" src="$theme->{'imagesdir'}/$theme->{'markallposts_image'}">|;
  }

  # --- all 
  $all = qq|<a href="$config->{'cgidir'}/index.cgi"><img border=0 src="$theme->{'imagesdir'}/$theme->{'all_image'}" alt="$lang->{'all_forum'}"></a>|;

  # --- view
  my $view1 = ($view eq "expanded")?"collapsed":"expanded";
  my $image = ($view eq "expanded")?
    $theme->{'collapsed_image'}:
      $theme->{'expanded_image'};
  my $alt = ($view eq "expanded")?
    $lang->{'collapse_threads1'}:
      $lang->{'expand_threads1'};
  $vad = qq|<a href="$config->{'cgidir'}/comments.cgi?op=$op&page=$page&postsper=$postsper&sort=$sort&sid=$sid&view=$view1&mode=$mode"><img border=0 src="$theme->{'imagesdir'}/$image" alt="$alt"></a>|;
  
  my $totalpages = int $totalnums/$postsper;
  my $remain = $totalnums % $postsper;
  $totalpages++ if $remain > 0;
  
  # --- prev page
  if($page == 1){
    $pp = qq|<img border=0 src="$theme->{'imagesdir'}/$theme->{'prev_image'}">|;
  }
  else{
    my $page = $page-1;
    my $url = "$config->{'basewwwdir'}$cgi?&op=$op&page=$page&postsper=$postsper&sort=$sort&sid=$sid&view=$view&mode=$mode";
    $pp = qq|<a href=$url><img alt="$lang->{'prev_page'}" border=0 src="$theme->{'imagesdir'}/$theme->{'prev_image'}"></a>|;
  }
  
  # --- next page
  if($page == $totalpages || $totalpages==0){
    $np = qq|<img border=0 src="$theme->{'imagesdir'}/$theme->{'next_image'}">|;
  }
  else{
    my $page = $page+1;
    my $url = "$config->{'basewwwdir'}$cgi?&op=$op&page=$page&postsper=$postsper&sort=$sort&sid=$sid&view=$view&mode=$mode";
    $np = qq|<a href=$url><img alt="$lang->{'next_page'}" border=0 src="$theme->{'imagesdir'}/$theme->{'next_image'}"></a>|;
  }

  $se = qq|<a href="$config->{'cgidir'}/search.cgi?sid=$sid"><img alt="$lang->{'search'}" border=0 src="$theme->{'imagesdir'}/$theme->{'search_image'}"></a>|;
  
  $p = qq|<a href="$config->{'basewwwdir'}$cgi?op=topicslist&page=$page&postsper=$postsper&sort=$sort&sid=$sid&view=$view&mode=printable"><img alt="$lang->{'print'}" border=0 src="$theme->{'imagesdir'}/$theme->{'print_image'}"}></a>|;
  $template->SUPER::print_block_start($theme->{'dhdrcolor'},
				      $theme->{'dhdrcolor'});
  my $forum = $template->_select_forums($STATE->{'forum'});
  print qq|<TR><TD ALIGN="left">$cw&nbsp;$sp&nbsp;$mp&nbsp;&nbsp;$pp&nbsp;$all&nbsp;$np&nbsp;$vad&nbsp;&nbsp;$se</TD><TD ALIGN="right">&nbsp;$p</TD></TR>|;
  $template->SUPER::print_block_end();
}

#############################################################################
# --- private functions
# ---
#############################################################################
sub _select_forums{
  my ($template, $forum) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};

  my $ret;

  $ret = "<SELECT NAME=\"forum\"><font size=\"1\">";
  $ret .= "<OPTION VALUE=\"all_forums\">$lang->{'all_forums'}";
  my ($value, $text);
  if($forum){
    my ($title) = $spdb->db_select_cols("title", "Boards", 
					"sid=".$DBH->quote($forum));
    $ret .= "<OPTION SELECTED VALUE=\"$forum\" SELECTED>$title" 
      if $title;
  }
  
  my ($foruma) = $spdb->db_select_many_new(1, "sid, title", "Boards");
  
  if($foruma){
      while (my ($forum1, $title) = $foruma->fetchrow_array){
	  $ret .= "<OPTION VALUE=\"$forum1\">$title" unless $forum eq $forum1;
      }
      $spdb->db_handler_done($foruma);
  }

  $ret .= "</FONT></SELECT>";
  return $ret;
}


return 1;


