package Templates::UserPost;

use SmallPigVars qw($config);
use SPDB;
use Templates::User;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::User);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::User->new($spcgi, $spdb, $pagetype);

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  $pagesubs->{'threads'} = \&threads;
 
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
    $template->print_user_index();

    $template->print_msg("header1", 1, "", $lang->{'posthist2'},
			 $config->{'inbgcolor'}, $config->{'inbgcolor'});

    my $msg;
    $msg .= qq|<a href="$config->{'cgidir'}/user.cgi?op=umovethreads">
	$lang->{'movemsg'}</a>|;
    $template->print_msg("header2", 1, "", "$lang->{'posthist3'}\:<BR>$msg",
			 $config->{'inbgcolor'}, $config->{'inbgcolor'});

    
    $template->print_user_posts();
    my ($uid, $postsper) = map{ $template->STATE->{$_} } qw(uid postsper);
    $template->print_page_index($template->{'totalnums'}, 
				"&uid=$uid&postsper=$postsper");

#    print qq|<font size ="1"><input type="submit" name="op" value=$lang->{'Subscribe'}></font></form>|;
}

sub threads{
    my $STATE = $template->STATE; 
    use Templates::Admin::StandardIndex;
    
    unless($STATE->{'sid'}){
	require Templates::Admin::BoardsBlock;
	my $boardblock = Templates::Admin::BoardsBlock->new($STATE->{'op'});
	print $boardblock->get($STATE);
    }
    else{
	require Templates::Admin::ThreadsBlock;
	my $threads = Templates::Admin::ThreadsBlock->new();
	print $threads->get($STATE);
    }
}

return 1;


