// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


// greek.h: This file contains data about the 24 Greek letters used by
//          starplot and starconvert.

#ifndef _GREEK_H
#define _GREEK_H

// there are two different abbreviations for Alpha, so this is 25 not 24,
//  and for loops (other than those matching abbreviations) should start at 1.
const unsigned int NUM_GREEK_LETTERS = 25; 

struct greekletter {
  const char abbrev[4];    // e.g. ALF or ALP for Alpha
  const char name[10];     // e.g. Alpha
  unsigned int abbrlen;
  unsigned int namelen;    // so we don't have to use strlen() all the time
  
  unsigned int pixelwidth; // pixel representation of the letter
  char * pixellines[10];   //  (assumes a 10-point font)
} ;

#define OOO "","",""
#define OO  "",""

const greekletter Greek[NUM_GREEK_LETTERS] = {
  {
    "ALF", "Alpha", 3, 5,
    6, {OOO," xx  x","x  x x","x   x","x  x"," xx xx",OO}
  },
  {
    "ALP", "Alpha", 3, 5,
    6, {OOO," xx  x","x  x x","x   x","x  x"," xx xx",OO}
  },
  {
    "BET", "Beta", 3, 4,
    5, {" xx","x  x","x  x","xxxx","x   x","x   x","x  x","xxx","x","x"}
  },
  {
    "GAM", "Gamma", 3, 5,
    5, {OOO," x  x","x x x","  x x","   x","   x","  x","  x"}
  },
  {
    "DEL", "Delta", 3, 5,
    5, {"  xxx"," x"," x","  x"," x x","x   x","x   x"," xxx",OO}
  },
  {
    "EPS", "Epsilon", 3, 7,
    4, {OOO," xxx","x","xxx","x"," xxx",OO}
  },
  {
    "ZET", "Zeta", 3, 4,
    4, {"","x"," xxx","  x"," x","x","x"," xxx","   x","  x"}
  },
  {
    "ETA", "Eta", 3, 3,
    5, {OO,"xx"," xxx"," x  x"," x  x"," x  x"," x  x","    x",""}
  },
  {
    "THE", "Theta", 3, 5,
    4, {" xx","x  x","x  x","xxxx","x  x","x  x","x  x"," xx",OO}
  },
  {
    "IOT", "Iota", 3, 4,
    3, {OOO,"xx"," x"," x"," x"," xx",OO}
  },
  {
    "KAP", "Kappa", 3, 5,
    5, {OOO,"x   x"," x x"," xx"," x x"," x  x",OO}
  },
  {
    "LAM", "Lambda", 3, 6,
    6, {"  xx","    x","    x","    x","   xx","  x x"," x  x","x    x",OO}
  },
  {
    "MU", "Mu", 2, 2,
    5, {OOO,"x  x","x  x","x  x","x  x","xxx x","x","x"}
  },
  {
    "NU", "Nu", 2, 2,
    4, {OOO,"x  x","x  x","x  x","x x","xx",OO}
  },
  {
    "XI", "Xi", 2, 2,
    4, {" x","  xx"," x","x"," xx","x","x"," xxx","   x",""}
  },
  {
    "OMI", "Omicron", 3, 7,
    4, {OOO," xx","x  x","x  x","x  x"," xx",OO}
  },
  {
    "PI", "Pi", 2, 2,
    6, {OOO," xxxxx","x x x","  x x","  x x","  x x",OO}
  },
  {
    "RHO", "Rho", 3, 3,
    4, {OOO," xx","x  x","x  x","x  x","xxx","x","x"}
  },
  {
    "SIG", "Sigma", 3, 5,
    6, {OOO," xxxxx","x  x","x  x","x  x"," xx",OO}
  },
  {
    "TAU", "Tau", 3, 3,
    6, {OOO," xxxxx","x  x","   x","   x","   x",OO}
  },
  {
    "UPS", "Upsilon", 3, 7,
    5, {OOO,"x  x","x   x","x   x","x   x"," xxx",OO}
  },
  {
    "PHI", "Phi", 3, 3,
    5, {"","  x","  x"," xxx","x x x","x x x","x x x"," xxx","  x","  x"}
  },
  {
    "CHI", "Chi", 3, 3,
    6, {"","xx   x","  x x","  xx","  x"," x x","x  x","x   xx",OO}
  },
  {
    "PSI", "Psi", 3, 3,
    5, {OOO,"x   x","x x x","x x x","x x x"," xxx","  x","  x"}
  },
  {
    "OME", "Omega", 3, 5,
    7, {OOO," x   x","x     x","x  x  x","x  x  x"," xx xx",OO}
  }
} ;

#endif // #ifndef _GREEK_H
