package net.sf.statcvs.pages;

/**
 * @author Benoit Xhenseval
 * @author Richard Cyganiak (richard@cyganiak.de)
 * @version $Id: MarkupXDoc.java,v 1.6 2008/04/02 11:22:14 benoitx Exp $
 */
public class MarkupXDoc implements MarkupSyntax {
    private final static MarkupSyntax instance = new MarkupXDoc();

    public static MarkupSyntax getInstance() {
        return instance;
    }

    private MarkupXDoc() {
        // Singleton
    }

    public String getEndOfPage() {
        return "</body>\n</document>";
    }

    public String getExtension() {
        return "xml";
    }

    public String getHeader(final String pageName, final String stylesheetURL) {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + "<document xmlns:lxslt=\"http://xml.apache.org/xslt\">\n" + "<properties><title>"
                + pageName + "</title></properties>\n" + "<head>\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; "
                + "charset=ISO-8859-1\"/>\n" + "    <meta name=\"Generator\" content=\"StatCVS @VERSION@\"/>\n" + "    <link rel=\"stylesheet\" href=\""
                + HTML.escape(stylesheetURL) + "\" type=\"text/css\"/>\n" + "  </head>\n\n" + "<body>";
    }

    public String startSection1(final String title) {
        return "<section name=\"" + title + "\">\n";
    }

    public String endSection1() {
        return "</section>";
    }

    public String startSection2(final String title) {
        return "\n<div class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String startSection2(final String title, final String id) {
        return "\n<div id=\"" + HTML.escape(id) + "\" class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String endSection2() {
        return "</subsection></div>";
    }

    public String getTableFormat() {
        return " class=\"statCvsTable\"";
    }

    public String toString() {
        return "XDoc";
    }
}
