/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: service.pike,v 1.2 2005/03/14 17:29:56 astra Exp $
 */

constant cvs_version="$Id: service.pike,v 1.2 2005/03/14 17:29:56 astra Exp $";

inherit "/kernel/module";

#include <macros.h>
#include <classes.h>
#include <database.h>
#include <exception.h>
#include <attributes.h>
#include <events.h>

class Service {
  function   send_function;
  function notify_function;
  object            socket;
  string              name;

  void create(string n, function sf, function nf, object sock) {
    send_function = sf;
    notify_function = nf;
    name = n;
    socket = sock;
  }
  void send(mixed args) {
    werror("sending to service "+ name + "\n");
    args = ({ name, this_user() }) + args;
  
    send_function(args);
  }
  void notify(mixed args) {
    if ( functionp(notify_function) )
      notify_function(args);
  }
}

static mapping mServices;
static mapping   mEvents;

void init_module() 
{
  mServices = ([ ]);
  mEvents   = ([ ]);
}

void notify_services(int e, mixed ... args)
{
  foreach(indices(mEvents), int event) {
    if ( (event & e) > 0  ) {
      foreach(mEvents[event], Service s) {
	  s->notify(args);
      }
    }
  }
}

void 
register_service(function send_function,function notify, string name,void|int event)
{
    MESSAGE("Service Registered!");
    if ( CALLER->get_ip() != "127.0.0.1" )
	steam_error("Invalid call - cannot register non-local services !");
    mServices[name] = Service(name, send_function, notify, CALLER);
    if ( event > 0 ) {
	add_global_event(event, notify_services, PHASE_NOTIFY);
	if ( !arrayp(mEvents[event]) )
	    mEvents[event] = ({ mServices[name] });
	else
	    mEvents[event] += ({ mServices[name] });
    }

  // todo: unregister service bei logout !
  werror("Events: %O\n", mEvents);
}

void call_service(mixed name, mixed args) 
{
  Service s = mServices[name];
  if ( !objectp(s) )
    steam_error("No such Service: " + name);
  s->send(args);
}

void handle_service(object user, object obj, mixed id, mixed res)
{
  if ( CALLER->get_ip() != "127.0.0.1" )
    steam_error("Invalid call - cannot callback non-local services !");
  object ouid = this_user();
  
  obj->handle_service(id, res);
}

int is_service(mixed name)
{
  object service = mServices[name];
  if ( !objectp(service) || !functionp(service->send_function) )
    return 0;
  return 1;
}

mapping get_services()
{
  return copy_value(mServices);
}

string get_identifier() { return "ServiceManager"; }
  






