__copyright__ = """
Copyright (C) 2006, Catalin Marinas <catalin.marinas@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
"""

import sys, os
from optparse import OptionParser, make_option
from pydoc import pager

from stgit.commands.common import *
from stgit import git


help = 'show the commit corresponding to a patch (or the current patch)'
usage = """%prog [options] [<patch>]

Show the commit log and the diff corresponding to a given patch. The
output is similar to that generated by the 'git show' command."""

options = []


def func(parser, options, args):
    """Show commit log and diff
    """
    if len(args) == 0:
        patch = 'HEAD'
    elif len(args) == 1:
        patch = args[0]
    else:
        parser.error('incorrect number of arguments')

    commit_id = git_id(patch)
    commit_str = git.pretty_commit(commit_id)
    if commit_str:
        pager(commit_str)
