/*
 * gtk-signal.c		-- GTK+ signal & callback management
 * 
 * Copyright  2000 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 * 
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 11-Oct-2000 23:42 (eg)
 * Last file update: 23-Oct-2000 08:28 (eg)
 */

#include "stklos.h"
#include "gtk-glue.h"

static int tc_callback;	/* The type_cell number associated to callbacks */

struct callback_obj {
  stk_header header;
  GtkSignalFunc fct;
};

#define CALLBACKP(p) 	 (BOXED_TYPE_EQ((p), tc_callback))
#define CALLBACK_FUNC(p) (((struct callback_obj *) (p))->fct)


/* ====================================================================== */

SCM STk_make_callback(GtkSignalFunc fct)
{
  SCM z;
  NEWCELL(z, callback);
  CALLBACK_FUNC(z) = fct;
  return z;
}


/*===========================================================================*\
 * 
 * 				  Setting signals 
 * 
\*===========================================================================*/

/* 
 * WIDGET   is the Scheme widget on which the signal must be set
 * SIGNAL   is the signal name
 * CALLBACK is the Scheme object designing the C procedure which must be connected
 *	    to the signal
 * CLOSURE  is the Scheme procedure which must be called  
 */

void STk_set_signal(SCM widget, SCM signal, GtkSignalFunc callback, SCM closure)
{
  char *s = STRING_CHARS(signal);
  SCM l, object_widget;

  for (l = WIDGET_SIGNALS(widget); !NULLP(l); l = CDR(CDR(l))) {
    if (strcmp(STRING_CHARS(CAR(l)), s) == 0) {
      /* Destroy old handler */
      STk_debug("Il faudrait dtruire l'ancien handler"); //FIXME:
      CAR(CDR(l)) = closure;
    }
  }

  if (NULLP(l))
    /* signal was not used before */
    WIDGET_SIGNALS(widget) = STk_cons(signal, 
				      STk_cons(closure, 
					       WIDGET_SIGNALS(widget)));

  /* Do the GTK connection. (gtk_user_data contains a ref. to the STklos object) */
  object_widget = (SCM) gtk_object_get_user_data(GTK_OBJECT(WIDGET_ID(widget)));

  gtk_signal_connect(GTK_OBJECT(WIDGET_ID(widget)), s, callback, (gpointer)closure);
}


DEFINE_PRIMITIVE("%signal-set!", user_signal_set, subr4,
		 (SCM w, SCM signal, SCM cbck, SCM closure))
{
  ENTER_PRIMITIVE(user_signal_set);

  if (!WIDGETP(w))      		    STk_error_bad_widget(w);
  if (!STRINGP(signal)) 		    STk_error("bad signal name ~S", signal);
  if (!CALLBACKP(cbck))			    STk_error("bad callback ~S", cbck);
  if (STk_procedurep(closure) == STk_false) STk_error("bad procedure ~S", closure);

  STk_set_signal(w, signal, CALLBACK_FUNC(cbck), closure);
  return STk_void;
}


/* ====================================================================== */

SCM STk_get_signal(SCM w, SCM signal)
{
  SCM l;
  char *s = STRING_CHARS(signal);

  for (l = WIDGET_SIGNALS(w); !NULLP(l); l = CDR(CDR(l))) {
    if (strcmp(STRING_CHARS(CAR(l)), s) == 0)
      return CAR(CDR(l));
  }
  return STk_false;
}


DEFINE_PRIMITIVE("%signal-get", user_signal_get, subr2, (SCM w, SCM signal))
{
  return STk_get_signal(w, signal);
}


/* ====================================================================== */

static void general_callback(GtkObject* w, gpointer data)
{
  /* "data" is the closure to call. Its argument is the object which wraps "w" */
  STk_C_apply((SCM) data, 1, (SCM) gtk_object_get_user_data(GTK_OBJECT(w)));
}


static struct extended_type_descr xtype_callback = {
  "callback-function",
  NULL,
};

void STk_init_gtk_signal(void)
{
  /* Define the new callback object type and the general callback function */
  DEFINE_USER_TYPE(tc_callback, &xtype_callback);
  STk_define_variable(STk_intern("%general-callback"),
		      STk_make_callback(general_callback),
		      STk_gtk_module);

  /* Add the primitives to manipulate signals */
  ADD_PRIMITIVE(user_signal_set);
  ADD_PRIMITIVE(user_signal_get);
}



