/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include <kfilemetainfo.h>
#include <kfileitem.h>
#include <kapplication.h>
#include <qtextcodec.h>

#define STRIGI_IMPORT_API //todo: could also define this in cmake...
#include <jstreamsconfig.h>
#include <strigi_plugins.h>

class KFileAnalyzer : public jstreams::StreamThroughAnalyzer {
private:
    static KApplication app;
    jstreams::Indexable* idx;
public:
    KFileAnalyzer() {
        // translate filenames from UTF-8
        QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf8"));
    }
    ~KFileAnalyzer() {}
     void setIndexable(jstreams::Indexable*i) {
        idx = i;
    }
    jstreams::InputStream *connectInputStream(jstreams::InputStream *in) {
        if ((int)idx->getDepth() != 0) {
//             std::cout << "Not depth=0, returning\n";
            return in;
        }

        // ok, determing path:
        if (idx->getName().length() == 0) {
//             std::cout << "No file name; returning\n";
            return in;
        }

        // don't try to do image/xpm files, as KDE < 3.5.6 crashes on those
        std::string s = idx->getName();
        int n = s.length();
        if (n < 3) {
        } else if (s.substr(n-3,3)=="xpm") {
            return in;
        } else if (s.substr(n-3,3)=="XPM") {
            return in;
        }
 
        // Then create a new KFileMetaInfo object
        KFileMetaInfo info( KURL::fromPathOrURL( idx->getName().c_str() ),
            QString::null,
            KFileMetaInfo::TechnicalInfo|KFileMetaInfo::ContentInfo);
        // See: http://developer.kde.org/documentation/library/cvs-api/kdelibs-apidocs/kio/kio/html/classKFileMetaInfo.html

        if (info.isEmpty()) {
//             std::cout << "KFileMetaInfo is empty... returning\n";
            return in;
        }

        // and process the metadata:
        QStringList sk(info.supportedKeys());
        QStringList::Iterator it;
        for ( it = sk.begin(); it != sk.end(); ++it ) {
            QString value = info.value(*it).toString();
            if (!value.isNull() && value.length()) {
                idx->setField((const char*)(*it).lower().utf8(),
                    (const char*)value.utf8());
            }
        }
        if (!info.mimeType().isNull()) {
            idx->setMimeType((const char*)info.mimeType().utf8());
        }

        return in;
    }
    bool isReadyWithStream() { return true; }
};

char* fileanalyzerargv[] = {"strigita_kfile"};
int fileanalyzerargc = 1;
KApplication KFileAnalyzer::app(fileanalyzerargc, fileanalyzerargv,
    "kio_strigi", false, false);

STRIGI_THROUGH_PLUGINS_START
STRIGI_THROUGH_PLUGINS_REGISTER(KFileAnalyzer)
STRIGI_THROUGH_PLUGINS_END

