# - Try to find Strigi
# Once done this will define
#
#  STRIGI_FOUND - system has Strigi
#  STRIGI_INCLUDE_DIR - the Strigi include directory
#  STRIGI_STREAMS_LIBRARY - Link these to use Strigi streams
#  STRIGI_HTMLGUI_LIBRARY - Link these to use Strigi html gui
#  STRIGI_CLIENT_LIBRARY - Link to use the Strigi C++ client
#

FIND_PATH(STRIGI_INCLUDE_DIR strigi/strigihtmlgui.h
  PATHS
  $ENV{STRIGI_HOME}/include
  ${CMAKE_INSTALL_PREFIX}/include
)
IF(NOT STRIGI_INCLUDE_DIR AND NOT Strigi_FIND_QUIETLY)
  MESSAGE(STATUS "Could not find Strigi include directory.")
ENDIF(NOT STRIGI_INCLUDE_DIR AND NOT Strigi_FIND_QUIETLY)

FIND_LIBRARY(STRIGI_STREAMS_LIBRARY NAMES streams
  PATHS
  $ENV{STRIGI_HOME}/lib
  ${CMAKE_INSTALL_PREFIX}/lib
)
IF(NOT STRIGI_STREAMS_LIBRARY AND NOT Strigi_FIND_QUIETLY)
  MESSAGE(STATUS "Could not find Strigi streams library.")
ENDIF(NOT STRIGI_STREAMS_LIBRARY AND NOT Strigi_FIND_QUIETLY)

FIND_LIBRARY(STRIGI_HTMLGUI_LIBRARY NAMES strigihtmlgui
  PATHS
  $ENV{STRIGI_HOME}/lib
  ${CMAKE_INSTALL_PREFIX}/lib
)
IF(NOT STRIGI_HTMLGUI_LIBRARY AND NOT Strigi_FIND_QUIETLY)
  MESSAGE(STATUS "Could not find Strigi htmlgui library.")
ENDIF(NOT STRIGI_HTMLGUI_LIBRARY AND NOT Strigi_FIND_QUIETLY)

FIND_LIBRARY(STRIGI_CLIENT_LIBRARY NAMES searchclient
  PATHS
  $ENV{STRIGI_HOME}/lib
  ${CMAKE_INSTALL_PREFIX}/lib
)
IF(NOT STRIGI_CLIENT_LIBRARY AND NOT Strigi_FIND_QUIETLY)
  MESSAGE(STATUS "Could not find Strigi client library.")
ENDIF(NOT STRIGI_CLIENT_LIBRARY AND NOT Strigi_FIND_QUIETLY)
  
IF(STRIGI_INCLUDE_DIR AND STRIGI_STREAMS_LIBRARY AND STRIGI_HTMLGUI_LIBRARY AND STRIGI_CLIENT_LIBRARY)
   SET(STRIGI_FOUND TRUE)
ENDIF(STRIGI_INCLUDE_DIR AND STRIGI_STREAMS_LIBRARY AND STRIGI_HTMLGUI_LIBRARY AND STRIGI_CLIENT_LIBRARY)

IF(STRIGI_FOUND)
  IF(NOT Strigi_FIND_QUIETLY)
    MESSAGE(STATUS "Found Strigi: ${STRIGI_HTMLGUI_LIBRARY}")
  ENDIF(NOT Strigi_FIND_QUIETLY)
ELSE(STRIGI_FOUND)
  IF(Strigi_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find Strigi")
  ENDIF(Strigi_FIND_REQUIRED)
ENDIF(STRIGI_FOUND)

