/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <FL/Fl_Preferences.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/fl_ask.H>
#include <SDL/SDL_net.h>
#include "http.h"
#include "load.h"
#include "url.h"
#include "interface.h"

extern IPaddress ip;	// Holds host info for current comic (or in the case of this file, stripclub.sf.net for .comic updates)

inline void chop(char *in) {		// Chops off newline characters
	for (int i = strlen(in) - 1; i > 0; i--) {
		if ((in[i] == 0xA) || (in[i] == 0xD)) {
			in[i] = '\0';
		} else {
			return;
		}
	}
}

void ImportComics(const char *File) {
	FILE *fptr;
	Fl_Preferences *ImportComic = NULL;
	char Name[400], Value[400];
	if (!File || !strlen(File)) {
		DbgOut("Empty pointer passed to ImportComics(), cancel clicked?\n");
		return;
	}
	if (!fl_ask("Warning: Any entries read may overwrite current values, continue?\n")) {
		return;
	}
	if (!(fptr = fopen(File, "r"))) {
		MOut("Unable to open %s for comic import!\n", File);
		return;
	}
	while(!feof(fptr)) {
		fgets(Name, 399, fptr);
		chop(Name);
		if (!strcmp(Name, "comic")) {
			if (ImportComic) {
				delete ImportComic;
				ImportComic = NULL;
			}
			fgets(Value, 399, fptr);
			chop(Value);
			Out("Importing Comic: %s\n", Value);
			ImportComic = new Fl_Preferences(Prefs, Value);
		} else {
			if (ImportComic) {
				fgets(Value, 399, fptr);
				chop(Value);
				DbgOut("Importing %s: %s\n", Name, Value);
				ImportComic->set(Name, Value);
			} else {
				MOut("Corrupt import file: %s\nRead %s before reading first comic name.\n", File, Name);
				fclose(fptr);
				return;
			}
		}
	}
	if (ImportComic) {
		delete ImportComic;
	}
	fclose(fptr);
	Prefs->flush();			// Make sure changes are written to disk
}

void ExportAllComics(const char *File) {
	FILE *fptr;
	Fl_Preferences *ExportComic = NULL;
	char Name[400], Value[400];
	int Groups, Entries;
	if (!File || !strlen(File)) {
		DbgOut("Empty pointer passed to ExportAllComics(), cancel clicked?\n");
		return;
	}
	if ((fptr = fopen(File, "r"))) {
		fclose(fptr);
		if (!fl_ask("Warning: File exists, overwrite?\n")) {
			return;
		}
	}
	if (!(fptr = fopen(File, "w"))) {
		MOut("Unable to open %s for comic export!\n", File);
		return;
	}
	Out("Exporting all comics to %s\n", File);
	Groups = Prefs->groups();
	for(int i = 0; i < Groups; i++) {
		strcpy(Name, Prefs->group(i));
		if (strcmp(Name, "hosts")) {		// Duh, don't export the hosts section...
			if (ExportComic) {
				delete ExportComic;
				ExportComic = NULL;
			}
			ExportComic = new Fl_Preferences(Prefs, Name);
			Entries = ExportComic->entries();
			Out("Exporting comic: %s\n", Name);
			DbgOut("Exporting comic: %s\n", Name);
			fprintf(fptr, "comic\n%s\n", Name);
			for (int j = 0; j < Entries; j++) {
				strcpy(Name, ExportComic->entry(j));
				if (strcmp(Name, "useragent") && strcmp(Name, "headcount") && 
					strcmp(Name, "getcount") && strcmp(Name, "gigsdown") && 
					strcmp(Name, "bytesdown") && strcmp(Name, "bookmark")) {	// Don't export these, duh
					ExportComic->get(Name, Value, "", 399);
					DbgOut("Exporting %s: %s\n", Name, Value);
					fprintf(fptr, "%s\n%s\n", Name, Value);
				}
			}
		}
	}
	if (ExportComic) {
		delete ExportComic;
	}
	fclose(fptr);
}

void ExportSeperateComics() {
	FILE *fptr;
	Fl_Preferences *ExportComic = NULL;
	char File[80], Name[400], Value[400];
	int Groups, Entries;
	if (!fl_ask("Warning: Any existing .comic files will be overwritten! Continue?\n")) {
		return;
	}
	Groups = Prefs->groups();
	for(int i = 0; i < Groups; i++) {
		strcpy(Name, Prefs->group(i));
		if (strcmp(Name, "hosts")) {		// Duh, don't export the hosts section...
			snprintf(File, 80, "%s.comic", Name);
			if (!(fptr = fopen(File, "w"))) {
				Out("Unable to open %s for comic export!\n", File);
				continue;
			}
			Out("Exporting comic seperately: %s\n", Name);
			DbgOut("Exporting comic seperately: %s\n", Name);
			if (ExportComic) {
				delete ExportComic;
				ExportComic = NULL;
			}
			ExportComic = new Fl_Preferences(Prefs, Name);
			Entries = ExportComic->entries();
			fprintf(fptr, "comic\n%s\n", Name);
			for (int j = 0; j < Entries; j++) {
				strcpy(Name, ExportComic->entry(j));
				if (strcmp(Name, "useragent") && strcmp(Name, "headcount") && 
					strcmp(Name, "getcount") && strcmp(Name, "gigsdown") && 
					strcmp(Name, "bytesdown") && strcmp(Name, "bookmark")) {	// Don't export these, duh
					ExportComic->get(Name, Value, "", 399);
					DbgOut("Exporting %s: %s\n", Name, Value);
					fprintf(fptr, "%s\n%s\n", Name, Value);
				}
			}
			fclose(fptr);
		}
	}
	if (ExportComic) {
		delete ExportComic;
	}
}

void ExportComic(Fl_Widget *w, void *Comic) {
	FILE *fptr;
	Fl_Preferences *ExportComic = NULL;
	char Name[400], Value[400];
	const char *File;
	int Entries;
	if (!Comic) {
		DbgOut("Empty pointer passed to ExportComic()\n");
		return;
	}
	sprintf(Name, "%s.comic", (char *)Comic);
	File = fl_file_chooser("Select a file to export the comic to", "*.comic", Name);
	if (!(fptr = fopen(File, "w"))) {
		Out("Unable to open %s for comic export!\n", File);
		return;
	}
	Out("Exporting comic: %s\n", (char *)Comic);
	ExportComic = new Fl_Preferences(Prefs, (char *)Comic);
	if (ExportComic) {
		Entries = ExportComic->entries();
		fprintf(fptr, "comic\n%s\n", (char *)Comic);
		for (int j = 0; j < Entries; j++) {
			strcpy(Name, ExportComic->entry(j));
			if (strcmp(Name, "useragent") && strcmp(Name, "headcount") && 
				strcmp(Name, "getcount") && strcmp(Name, "gigsdown") && 
				strcmp(Name, "bytesdown") && strcmp(Name, "bookmark")) {	// Don't export these, duh
				ExportComic->get(Name, Value, "", 399);
				DbgOut("Exporting %s: %s\n", Name, Value);
				fprintf(fptr, "%s\n%s\n", Name, Value);
			}
		}
		delete ExportComic;
	}
	fclose(fptr);
}

void UpdateComics() {
	const char *File;
	FILE *fptr;
	char buf[200], comic[30], empty[] = "";
	int timestamp, size, updated = 0;
	struct stat filestat;
	sURL *Break;

	SwitchComic(NULL, empty);		// So the reader doesn't get locked into some bizarre state, empty neccessary because "" doesn't work

	Break = URLCreate("http://stripclub.sourceforge.net/comics/");	// Base dir for .comics

	Interface.BarLabel("Grabbing comics.txt...");

	File = GrabHTTPLink("http://stripclub.sourceforge.net/comics.txt");

	if (File) {
		if (!(fptr = fopen(File, "r"))) {		// This would be a definite WTF moment, but you never know...
			Interface.BarLabel("Error opening local copy of comics.txt!");
			MOut("Error opening local copy of comics.txt!\n");
			return;
		}
	} else {
		Interface.BarLabel("Error retrieving comics.txt!");
		MOut("Error retrieving comics.txt!\n");
		return;
	}

	Interface.BarLabel("Checking for updates...");

	while (!feof(fptr)) {
		fgets(buf, 199, fptr);
		sscanf(buf, "%s %d %d", comic, &timestamp, &size);
		if (!stat(GetCacheFileName(comic, true, "comics"), &filestat)) {	// File exists
			if(((filestat.st_mtime + timezone) >= timestamp) && (filestat.st_size == size)) {	// Local copy is newer or just as old, and size matches
				continue;
			}
		}
		// File doesn't exist locally, or newer copy is available
		Out("Downloading new/updated comic: %s\n", comic);
		updated++;
		GrabHTTPLink(MakeNewURL(comic, Break));	// Grab new copy (we can ignore the return value)
	}
	fclose(fptr);
	MOut("%d new/updated .comic file(s) downloaded\nComic files can be found in %s\n", updated, GetCacheFileName("", true, "comics"));
	URLDelete(Break);
}
