/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EXPORTDIALOG_H
#define _SC_EXPORTDIALOG_H

// sc
class ExportParam;
class ExternProvider;
class ExternButton;
class RevisionWidget;

// qt
#include <qdialog.h>
class QComboBox;
class QCheckBox;
class QPushButton;


class ExportDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

    enum Type { unknown, repository, workingcopy };

public:
  ExportDialog( ExternProvider* p, bool force, QWidget *parent = 0 );
  virtual ~ExportDialog();

  void initSrcUrl( const QString& url );
  void initSrcPath( const QString& path );

  ExportParam* getParameters() const;

public slots:
  void srcExtern();
  void dstExtern();
  void checkOk( const QString& text );

private:
  Type            _type;
  QComboBox*      _src;
  ExternButton*   _srcEx;
  RevisionWidget* _srcRw;

  QComboBox*      _dst;
  ExternButton*   _dstEx;

  QCheckBox*      _force;
  QComboBox*      _eol;

  QPushButton*    _ok;

  ExternProvider* _p;
};

#endif // _SC_EXPORTDIALOG_H
