/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTWIDGET_H
#define _SC_LISTWIDGET_H

// sc
#include "svn/DirEntry.h"
#include "svn/WcStatus.h"
class ScModel;
class Project;
class ScLvi;
class RepositoryLvi;
class RepositoryModel;
class WcModel;
class ProjectFoldersWidget;
class RepositoryFilesWidget;
class WorkingCopyFilesWidget;
class SplitLayout;

// qt
#include <qwidget.h>
class QWidgetStack;
class QListView;
class QListViewItem;
class QPopupMenu;


class ListWidget : public QWidget 
{
  typedef QWidget super;
  Q_OBJECT 

public:
  ListWidget( ScModel* model, QWidget *parent=0, const char *name=0 );
  virtual ~ListWidget();

  ScModel* getModel() const;

  void addProject( Project* prj );
  void refreshProjects();

  // QWidget overwrite
  void customEvent( QCustomEvent* ce );

  void installChildEventFilter( const QObject* filter );

  QPopupMenu* getRepositoryFilesMenu();
  QPopupMenu* getRepositoryFolderMenu();
  QPopupMenu* getWorkingCopyFilesMenu();
  QPopupMenu* getWorkingCopyFolderMenu();
  QPopupMenu* getProjectMenu();

  ProjectFoldersWidget* getProjectFoldersWidget();

public slots:
  void reload();

  void showEmptyFiles();
  void showProject();
  void showWorkingCopyFiles();
  void showRepositoryFiles();
  void clearWorkingCopyFiles();

private:
    SplitLayout*          _split;
  ProjectFoldersWidget*   _subvn;
  QWidgetStack*           _stackFiles;
  RepositoryFilesWidget*  _filesRp;
  WorkingCopyFilesWidget* _filesWc;
  
  ScModel*                _model;
  RepositoryModel*        _rpModel;
  WcModel*                _wcModel;
};

#endif // _SC_LISTWIDGET_H

