/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ImportCmd.h"
#include "ImportParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/CommitInfo.h"
#include "util/Error.h"


ImportCmd::ImportCmd( ImportParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

ImportCmd::~ImportCmd()
{
  delete _cb;
}

void ImportCmd::run()
{
  sc::Error*      err;
  svn::CommitInfo info;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->import( _param->getCommitInfo(), _param->getPath(), _param->getUrl(),
    _param->getRecurse() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
