/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MOVEPARAM_H
#define _SC_MOVEPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "svn/Revision.h"
#include "util/String.h"


/**
 * Parameter class for MoveCmd.
 */
class MoveParam : public ScParam
{
public:
  MoveParam( const svn::Paths& srcPathsOrUrls, const svn::Revision* srcRev,
    const char* dstPathOrUrl, bool force ) : _srcPathsOrUrls(srcPathsOrUrls),
    _srcRev(srcRev), _dstPathOrUrl(dstPathOrUrl), _force(force)
  {
  }

  ~MoveParam()
  {
    delete _srcRev;
  }

  const svn::Paths& getSrcPathsOrUrls() const
  {
    return _srcPathsOrUrls;
  }

  const svn::Revision* getSrcRevision() const
  {
    return _srcRev;
  }

  const sc::String& getDstPathOrUrl() const
  {
    return _dstPathOrUrl;
  }

  bool getForce() const
  {
    return _force;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(MoveParam);

private:
  // in
  svn::Paths            _srcPathsOrUrls;
  const svn::Revision*  _srcRev;

  sc::String            _dstPathOrUrl;
  bool                  _force;

  // out
  svn::CommitInfo       _info;
};

#endif // _SC_MOVEPARAM_H
