/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTSETTINGSWIDGET_H
#define _SC_PROJECTSETTINGSWIDGET_H

// sc
#include "sublib/SettingsWidget.h"
class ExternProvider;
class ExternButton;
class Project;

// qt
class QLineEdit;
class QPushButton;
class QComboBox;
class QListView;
class QListViewItem;


class ProjectSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  ProjectSettingsWidget( ExternProvider* p, QWidget *parent = 0, const char *name = 0 );
  ~ProjectSettingsWidget();

  void setProject( Project* prj );
  Project* getProject() const;

public slots:
  void textChanged( const QString& text );
  void selectionChanged( QListViewItem* );
  void clicked( QListViewItem* );

  void add();
  void del();
  void clr();
  void up();
  void down();
  void std();
  void activated(int);

  void selectSource();

private:
  void handleExtern( QLineEdit* e );

  Project*        _prj;
  ExternProvider* _p;

  QLineEdit*    _name;

  QListView*    _items;
  QComboBox*    _type;

  QPushButton*  _add;
  QPushButton*  _del;
  QPushButton*  _clr;

  QPushButton*  _up;
  QPushButton*  _down;

  QPushButton*  _layout;

  QLineEdit*    _itemName;
  QLineEdit*    _itemSource;
  ExternButton* _itemEx;
};


#endif // _SC_PROJECTSETTINGSWIDGET_H
