/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TextViewWidget.h"

// sys
#include <stdio.h>
#include <algorithm>

// qt
#include <qgrid.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qscrollbar.h>
#include <qsplitter.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>



TextViewWidget::TextViewWidget( QWidget *parent, const char *name )
: super( parent, name ), _vsbOff(sboHide), _hsbOff(sboHide)
{
  setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
  //setFont( QFont("Courier New",10,QFont::Normal,false/*,QFont::Unicode*/) );
  //setFrameStyle( QFrame::Box | QFrame::Plain );
  setFrameStyle( QFrame::Panel | QFrame::Sunken );
  //setBackgroundMode( QWidget::NoBackground );

  QGridLayout* gl = new QGridLayout( this, 2, 2 );
  //gl->setResizeMode( QLayout::FreeResize );
  gl->setMargin(1);
  {
    // top left
    // filled by inherited classes...

    // top right
    _vsb = new QScrollBar( Qt::Vertical, this );
    _vsb->setBackgroundMode( Qt::NoBackground );
    _vsb->setLineStep( QFontMetrics(font()).height() );
    //_vsb->setMinimumHeight( _vsb->width()+1 );
    gl->addWidget( _vsb, 0, 1 );

    // bottom left
    _hsb = new QScrollBar( Qt::Horizontal, this );
    _hsb->setBackgroundMode( Qt::NoBackground );
    _hsb->setLineStep( QFontMetrics(font()).width('x') );
    //_hsb->setMinimumWidth( _hsb->height()+1 );
    gl->addWidget( _hsb, 1, 0 );

    // botto right
    // empty
  }

  QObject::connect( _vsb, SIGNAL(valueChanged(int)), this, SLOT(vsbChange(int)) );
  QObject::connect( _hsb, SIGNAL(valueChanged(int)), this, SLOT(hsbChange(int)) );
}

TextViewWidget::~TextViewWidget()
{
}

void TextViewWidget::updateScrollBars()
{
  QSize prefSize = getScrollSizeHint();
  QSize currSize = getScrollSizeCurr();

  _vsb->setRange( 0, std::max(0,prefSize.height() - currSize.height()) );
  _vsb->setSteps( _vsb->lineStep(), currSize.height() );

  _hsb->setRange( 0, std::max(0,prefSize.width() - currSize.width()) );
  _hsb->setSteps( _hsb->lineStep(), currSize.width() );

  if( prefSize.height() <= currSize.height() )
  {
    setScrollBarOff( _vsb, _vsbOff, true );
  }
  else
  {
    setScrollBarOff( _vsb, _vsbOff, false );
  }

  if( prefSize.width() <= currSize.width() )
  {
    setScrollBarOff( _hsb, _hsbOff, true );
  }
  else
  {
    setScrollBarOff( _hsb, _hsbOff, false );
  }

  emit updatedScrollBars();
}

QScrollBar* TextViewWidget::getVScrollBar() const
{
  return _vsb;
}

QScrollBar* TextViewWidget::getHScrollBar() const
{
  return _hsb;
}

void TextViewWidget::setVScrollBarOff( ScrollBarOff off )
{
  _vsbOff = off;
}

void TextViewWidget::setHScrollBarOff( ScrollBarOff off )
{
  _hsbOff = off;
}

TextViewWidget::ScrollBarOff TextViewWidget::getHScrollBarOff() const
{
  return _hsbOff;
}

void TextViewWidget::resizeEvent( QResizeEvent *e )
{
  updateScrollBars();
  super::resizeEvent(e);
}

void TextViewWidget::setGeometry( int x, int y, int w, int h )
{
  updateScrollBars();
  super::setGeometry(x,y,w,h);
}

void TextViewWidget::setScrollBarOff( QScrollBar* sb, ScrollBarOff sbo, bool off )
{
  switch( sbo )
  {
  case sboHide:
    {
      if( off )
      {
        sb->hide();
      }
      else
      {
        sb->show();
      }
      break;
    }
  case sboDisable:
    {
      if( off )
      {
        sb->setDisabled(true);
      }
      else
      {
        sb->setDisabled(false);
      }
      break;
    }
  }
}
