/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CHECKOUTDIALOG_H
#define _SC_CHECKOUTDIALOG_H

// sc
class RevisionWidget;
class ExternProvider;
class ExternButton;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class CheckoutDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  CheckoutDialog( ExternProvider* p, bool recurse, bool add, QWidget *parent = 0 );
  virtual ~CheckoutDialog();

  void enableRepositoryUrl( bool enable );
  void enableWorkingCopyPath( bool enable );

  QString getRepositoryUrl();
  void setRepositoryUrl( const QString& url );

  QString getWorkingCopyPath();
  void setWorkingCopyPath( const QString& path );

  svn::Revision* getRevision();
  svn::Revision* getPegRevision();
  bool isRecursive();
  bool isAddToProject();

public slots:
  void selectWcPath();
  void checkOk( const QString& text );

private slots:
  void repExtern();

private:
  void handleExtern( QComboBox* e );

private:
  RevisionWidget* _rw;
  RevisionWidget* _rwPeg;

  QCheckBox*      _recurse;
  QCheckBox*      _autoAdd;
  QComboBox*      _rep;
  ExternButton*   _repEx;
  QComboBox*      _wc;
  ExternButton*   _wcEx;

  QPushButton*    _ok;
  QPushButton*    _ca;

  ExternProvider* _p;
};

#endif // _SC_CHECKOUTDIALOG_H
