/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Pair;
import classes.TypeSelection;
import enums.TrafficDefinitionLayerType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import roadnetwork.RoadNetwork;
import roadnetwork.RoadNetworkParser;
import simulation.JobType;
import simulation.Simulation;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.TrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class Project {
    private static transient Project currentlyLoadedProject = null;
    private JobType defaultJobType = null;
    private VehicleType defaultVehicleType = null;
    private String fileName = null;
    private List<JobType> jobTypes = null;
    private RoadNetwork roadNetwork = null;
    private List<TrafficDefinitionLayer> trafficLayers = null;
    private List<VehicleType> vehicleTypes = null;
    private TypeSelection<VehicleType> activityBasedTrafficVehicleSelection;
    private Simulation simulation = new Simulation();

    public static Project getCurrentlyLoadedProject() {
        return currentlyLoadedProject;
    }

    public Project(String projectPath) throws Exception {
        this.fileName = projectPath;
        FileInputStream fileIn = new FileInputStream(this.fileName);
        ObjectInputStream in = new ObjectInputStream(fileIn);
        this.roadNetwork = (RoadNetwork)in.readObject();
        this.trafficLayers = (ArrayList)in.readObject();
        this.simulation = (Simulation)in.readObject();
        this.jobTypes = (ArrayList)in.readObject();
        this.vehicleTypes = (ArrayList)in.readObject();
        this.defaultJobType = (JobType)in.readObject();
        this.defaultVehicleType = (VehicleType)in.readObject();
        this.activityBasedTrafficVehicleSelection = (TypeSelection)in.readObject();
        in.close();
        currentlyLoadedProject = this;
    }

    public Project(String projectPath, File roadNetworkFile) throws Exception {
        currentlyLoadedProject = this;
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document roadNetworkXMLDocument = parser.parse(roadNetworkFile);
        this.roadNetwork = new RoadNetworkParser().ParseXMLNetFile(roadNetworkXMLDocument);
        this.trafficLayers = new ArrayList<TrafficDefinitionLayer>();
        this.jobTypes = new ArrayList<JobType>();
        this.defaultJobType = JobType.CreateDefaultType();
        this.jobTypes.add(this.defaultJobType);
        this.vehicleTypes = new ArrayList<VehicleType>();
        this.defaultVehicleType = VehicleType.CreateDefaultType();
        this.vehicleTypes.add(this.defaultVehicleType);
        this.activityBasedTrafficVehicleSelection = new TypeSelection();
        this.activityBasedTrafficVehicleSelection.add(new Pair<VehicleType, Float>(this.defaultVehicleType, Float.valueOf(1.0f)));
        this.createNewLayer(TrafficDefinitionLayerType.UserDefined);
        this.fileName = projectPath;
        FileOutputStream fileOut = new FileOutputStream(this.fileName);
        ObjectOutputStream out = new ObjectOutputStream(fileOut);
        File edgesFile = new File(roadNetworkFile.getAbsolutePath().replaceFirst(".net.", ".edg."));
        File nodesFile = new File(roadNetworkFile.getAbsolutePath().replaceFirst(".net.", ".nod."));
        FileInputStream fileInEdges = new FileInputStream(edgesFile);
        FileInputStream fileInNodes = new FileInputStream(nodesFile);
        byte[] edgeBytes = new byte[(int)edgesFile.length()];
        byte[] nodeBytes = new byte[(int)nodesFile.length()];
        fileInEdges.read(edgeBytes);
        fileInNodes.read(nodeBytes);
        this.roadNetwork.setRoadNetworkEdgesXML(new String(edgeBytes));
        this.roadNetwork.setRoadNetworkNodesXML(new String(nodeBytes));
        out.writeObject(this.roadNetwork);
        out.writeObject(this.trafficLayers);
        out.writeObject(this.simulation);
        out.writeObject(this.jobTypes);
        out.writeObject(this.vehicleTypes);
        out.writeObject(this.defaultJobType);
        out.writeObject(this.defaultVehicleType);
        out.writeObject(this.activityBasedTrafficVehicleSelection);
        out.close();
    }

    public void Close() {
        currentlyLoadedProject = null;
    }

    public TrafficDefinitionLayer createDuplicateLayer(TrafficDefinitionLayer source) {
        TrafficDefinitionLayer newLayer = source.duplicate();
        this.trafficLayers.add(newLayer);
        return newLayer;
    }

    public TrafficDefinitionLayer createNewLayer(TrafficDefinitionLayerType type) {
        TrafficDefinitionLayer newLayer = null;
        switch (type) {
            case UserDefined: {
                newLayer = new UserDefinedTrafficDefinitionLayer();
                break;
            }
            case ActivityBased: {
                newLayer = new ActivityBasedTrafficDefinitionLayer();
                break;
            }
            case Random: {
                newLayer = new RandomTrafficDefinitionLayer();
            }
        }
        this.trafficLayers.add(newLayer);
        return newLayer;
    }

    public void DeleteLayer(TrafficDefinitionLayer layer) {
        this.trafficLayers.remove(layer);
    }

    public JobType getDefaultJobType() {
        return this.defaultJobType;
    }

    public VehicleType getDefaultVehicleType() {
        return this.defaultVehicleType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<JobType> getJobTypes() {
        return this.jobTypes;
    }

    public TrafficDefinitionLayer getLayer(int index) {
        return this.trafficLayers.get(index);
    }

    public RoadNetwork getRoadNetwork() {
        return this.roadNetwork;
    }

    public List<TrafficDefinitionLayer> getTrafficLayers() {
        return this.trafficLayers;
    }

    public List<VehicleType> getVehicleTypes() {
        return this.vehicleTypes;
    }

    public void saveTDL(String path) throws Exception {
        FileWriter fw = new FileWriter(path);
        PrintWriter pw = new PrintWriter(fw);
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<trafficModel name =\"" + this.simulation.getName() + "\" startingTime =\"" + String.valueOf(this.simulation.getBeginTime()) + "\" endingTime =\"" + String.valueOf(this.simulation.getEndTime()) + "\" xmlns=\"http://tempuri.org/TDL.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >");
        pw.println("<jobTypes>");
        for (JobType j : this.jobTypes) {
            pw.println("<job name=\"" + j.getName() + "\" startingTime=\"" + String.valueOf(j.getStartingTime()) + "\" endingTime=\"" + String.valueOf(j.getEndingTime()) + "\"/>");
        }
        pw.println("</jobTypes>");
        pw.println("<vehicleTypes>");
        for (VehicleType v : this.vehicleTypes) {
            pw.println("<vehicle name=\"" + v.getName() + "\" acceleration=\"" + String.valueOf(v.getAcceleration()) + "\" deceleration=\"" + String.valueOf(v.getDeceleration()) + "\" length=\"" + String.valueOf(v.getLength()) + "\" maximumSpeed=\"" + String.valueOf(v.getMaximumSpeed()) + "\" driverImperfection=\"" + String.valueOf(v.getDriverImperfection()) + "\" />");
        }
        pw.println("</vehicleTypes>");
        pw.print(XMLHelpers.vehicleSelectionToXML("activityBasedTrafficVehicleSelection", this.activityBasedTrafficVehicleSelection));
        pw.println("<trafficLayers>");
        for (TrafficDefinitionLayer tdl : this.trafficLayers) {
            pw.print(tdl.toXML());
        }
        pw.println("</trafficLayers>");
        pw.println("</trafficModel>");
        pw.close();
        fw.close();
    }

    public void Save() throws Exception {
        FileOutputStream fileOut = new FileOutputStream(this.fileName, false);
        ObjectOutputStream out = new ObjectOutputStream(fileOut);
        out.writeObject(this.roadNetwork);
        out.writeObject(this.trafficLayers);
        out.writeObject(this.simulation);
        out.writeObject(this.jobTypes);
        out.writeObject(this.vehicleTypes);
        out.writeObject(this.defaultJobType);
        out.writeObject(this.defaultVehicleType);
        out.writeObject(this.activityBasedTrafficVehicleSelection);
        out.close();
    }

    public void SaveAs(String path) throws Exception {
        this.fileName = path;
        this.Save();
    }

    public void setJobTypes(List<JobType> jobTypes) {
        this.jobTypes = jobTypes;
    }

    public void setVehicleTypes(List<VehicleType> vehicleTypes) {
        this.vehicleTypes = vehicleTypes;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public TypeSelection<VehicleType> getActivityBasedTrafficVehicleSelection() {
        return this.activityBasedTrafficVehicleSelection;
    }

    public void setActivityBasedTrafficVehicleSelection(TypeSelection<VehicleType> vehicleSelection) {
        this.activityBasedTrafficVehicleSelection = vehicleSelection;
    }
}

