/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Pair;
import classes.TypeSelection;
import interfaces.SelectableType;
import javax.swing.table.AbstractTableModel;

public class TypeSelectionTableModel<T extends SelectableType>
extends AbstractTableModel {
    private static final long serialVersionUID = -6606926480332673298L;
    TypeSelection<T> selection;

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.selection.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Type";
        }
        return "Percentage %";
    }

    public TypeSelectionTableModel(TypeSelection<T> initialSelection) {
        this.selection = initialSelection;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col < 0 || col > 1 || row < 0 || row > this.selection.size() - 1) {
            return null;
        }
        if (col == 0) {
            return ((Pair)this.selection.get(row)).getFirst();
        }
        return Math.round(((Float)((Pair)this.selection.get(row)).getSecond()).floatValue() * 100.0f);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        if (c == 1) {
            return Integer.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            ((Pair)this.selection.get(row)).setSecond(Float.valueOf(((Integer)value).floatValue() / 100.0f));
        }
        this.fireTableCellUpdated(row, col);
    }
}

