/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.calibrators.filebased.Agent;
import cadyts.demand.ODRelation;
import cadyts.demand.PlanChoiceDistribution;
import cadyts.interfaces.sumo.SumoPlan;
import cadyts.utilities.math.Vector;
import cadyts.utilities.misc.Tuple;
import java.util.List;
import java.util.logging.Logger;

class SumoAgent
extends Agent<SumoPlan, PlanChoiceDistribution<SumoPlan>> {
    private final int dpt_s;
    private final ODRelation<String> odRelation;
    private final boolean isClone;
    private final List<Tuple<String, String>> miscAttrs;

    SumoAgent(String id, int dpt_s, String fromTAZ, String toTAZ, boolean isClone, List<Tuple<String, String>> miscAttrs) {
        super(id, new PlanChoiceDistribution());
        this.dpt_s = dpt_s;
        this.odRelation = fromTAZ != null && toTAZ != null ? new ODRelation<String>(fromTAZ, toTAZ) : null;
        this.isClone = isClone;
        this.miscAttrs = miscAttrs;
    }

    SumoAgent(String id, int dpt_s, String fromTAZ, String toTAZ, List<Tuple<String, String>> miscAttrs) {
        this(id, dpt_s, fromTAZ, toTAZ, false, miscAttrs);
    }

    SumoAgent(SumoAgent parent, String idPostfix) {
        this(parent.getId() + idPostfix, parent.getDptTime_s(), parent.getFromTAZ(), parent.getToTAZ(), true, parent.getMiscAttrs());
        List plans = parent.getPlans();
        Vector probs = ((PlanChoiceDistribution)parent.getPlanChoiceModel()).getChoiceProbabilities(plans);
        int i = 0;
        while (i < plans.size()) {
            this.addPlan((SumoPlan)plans.get(i), probs.get(i));
            ++i;
        }
    }

    void addPlan(SumoPlan plan, double choiceProb) {
        Logger.getLogger(this.getClass().getName()).fine("agent " + this.getId() + " received route " + plan.getRouteId());
        this.addPlan(plan);
        ((PlanChoiceDistribution)this.getPlanChoiceModel()).addChoiceProbability(choiceProb);
    }

    int getDptTime_s() {
        return this.dpt_s;
    }

    ODRelation<String> getODRelation() {
        return this.odRelation;
    }

    String getFromTAZ() {
        return this.getODRelation() != null ? this.getODRelation().getFromTAZ() : null;
    }

    String getToTAZ() {
        return this.getODRelation() != null ? this.getODRelation().getToTAZ() : null;
    }

    boolean isClone() {
        return this.isClone;
    }

    List<Tuple<String, String>> getMiscAttrs() {
        return this.miscAttrs;
    }
}

