# Notices for Eclipse Sumo

This content is produced and maintained by the Eclipse Sumo project.

* Project home: https://eclipse.org/sumo

## Trademarks

Eclipse Sumo is a trademark of the Eclipse Foundation.

## Copyright

All content is the property of the respective authors or their employers. For
more information regarding authorship of content, please consult the listed
source code repository logs.

## Declared Project Licenses

This program and the accompanying materials are made available under the terms
of the Eclipse Public License v. 2.0 which is available at
http://www.eclipse.org/legal/epl-v20.html.

SPDX-License-Identifier: EPL-2.0

## Source Code

The project maintains the following source code repositories:

* https://github.com/eclipse/sumo

## Third-party Content

This project leverages the following third party content.

Font Stash from 2017-09-23 (n/a)

* License: Zlib AND (MIT OR LicenseRef-Public-Domain)
* Project: https://github.com/memononen/fontstash
* Source: https://github.com/memononen/fontstash

FOX toolkit (1.6.55)

* License: LicenseRef-Fox-Toolkit-Addendum-to-License AND
   LicenseRef-Public-Domain AND  X11
* Project: http://www.fox-toolkit.org/
* Source: ftp://ftp.fox-toolkit.org/pub/fox-1.6.55.zip

Google Design Icons (n/a)

* License: CC-BY-4.0
* Project: http://google.com/design/

odrSpiral from 2017-05-03 (n/a)

* License: Apache-2.0
* Project: https://github.com/DLR-TS/odrSpiral
* Source: https://github.com/DLR-TS/odrSpiral

OpenStreetMap data files (n/a)

* License: ODbL-1.0
* Project: http://www.openstreetmap.org/

Proj4 - (4.9.3)

* License: MIT AND LicenseRef-Public-Domain AND Apache-2.0
* Project: https://proj4.org/

RTree (n/a)

* License: LicenseRef-Permissive
* Project: http://superliminal.com/sources/sources.htm
* Source: http://superliminal.com/sources/RTreeTemplate.zip

tcpip from 2012-09-28 (n/a)

* License: BSD-3-Clause
* Project: https://github.com/itm/shawn
* Source: https://github.com/itm/shawn/tree/master/src/apps/tcpip

Xerces-C++ (3.2.0)

* License: Apache-2.0
* Project: http://xerces.apache.org/xerces-c/
* Source:
   http://mirror.softaculous.com/apache//xerces/c/3/sources/xerces-c-3.2.0.tar.gz

## Cryptography

Content may contain encryption software. The country in which you are currently
may have restrictions on the import, possession, and use, and/or re-export to
another country, of encryption software. BEFORE using any encryption software,
please check the country's laws, regulations and policies concerning the import,
possession, or use, and re-export of encryption software, to see if this is
permitted.

## Derivative Works

EPL requires that "derivative works" be licensed under the terms of the EPL
whereas "separate modules of software" may be licensed arbitrarily. Please follow the links
below for lists of files where modifications are considered derivative work.

We currently consider all modifications to [src](src/README_Contributing.md) and [tools](tools/README_Contributing.md) (including the subdirectories) as derivative work except for the following cases:
- TraCI client applications that use the public TraCI client libraries
- separate modules residing in [src](src/README_Contributing.md)
- car following models that inherit from MSCFModel (excluding [modifications of the existing models](src/microsim/cfmodels/README_Contributing.md))
- lane changing models that inherit from MSAbstractLaneChangeModel (excluding [modifications of the existing models](src/microsim/lcmodels/README_Contributing.md))
- simulation output modules (excluding [changes to the existing classes](src/microsim/output/README_Contributing.md))
- vehicle device modules (excluding [changes to the existing classes](src/microsim/devices/README_Contributing.md))
- network import modules (excluding [changes to the existing classes](src/netimport/README_Contributing.md))
- network export modules (excluding [changes to the existing classes](src/netwrite/README_Contributing.md))
- software that build upon the existing Python and Java tools libraries (excluding [changes to the existing](tools/README_Contributing.md))

