/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Swac-explore is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include "db.hh"
#include "posix.hh"
#include "messages.hh"

std::string sql_str(std::string str) {
	char formated[255];
	sqlite3_snprintf (255, formated, "'%q'", str.c_str());
	return formated;
}


bool Tdb::open() {
	char *zErrMsg = 0;
	int rc;
	
	
	std::string path(get_home_dir() + ".swac/swac.db");

	if (!fileexists(path)) {
		message_error("Can not find database. Please run \"swac-get\" first.");
		return false;
	}

	rc = sqlite3_open(path.c_str(), &this->db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(this->db));
		sqlite3_close(this->db);
		
		return false;
	}

	return true;
}


bool Tdb::close() {
	sqlite3_close(this->db);

	return true;
}


bool Tdb::exec(const char *sql,  int (*callback)(void*,int,char**,char**), void *params) {
	char *zErrMsg = 0;
	int rc;

	rc = sqlite3_exec(this->db, sql, callback, params, &zErrMsg);

	if( rc!=SQLITE_OK ){
		fprintf(stderr, "SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
	}
}
