/**
 * \file menutbar.h
 * \brief Header file for menu and tool bar routines
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __MENUTBAR_H__
#define __MENUTBAR_H__

#include <gtk/gtk.h>
#include "swamidll.h"

/* function prototypes */

SWAMI_API void swamiui_menu_cb_quit (void);
SWAMI_API void swamiui_menu_cb_new_sfont (void);
SWAMI_API void swamiui_menu_cb_save (GtkWidget *mitem, gpointer data);
SWAMI_API void swamiui_menu_cb_edit_global_mods (GtkMenuItem *menuitem);
SWAMI_API void
swamiui_menu_cb_enable_global_mods_toggle (GtkMenuItem *menuitem);

/* HACK: Glade overwrites menu item callback data, so we have to have a
   routine for each radio item :( */
void swamiui_menu_cb_lowpane_genview (GtkMenuItem *menuitem);
void swamiui_menu_cb_lowpane_genctrl (GtkMenuItem *menuitem);
void swamiui_menu_cb_lowpane_gengraph (GtkMenuItem *menuitem);
void swamiui_menu_cb_lowpane_samview (GtkMenuItem *menuitem);
void swamiui_menu_cb_lowpane_modedit (GtkMenuItem *menuitem);
void swamiui_menu_cb_spanwin_piano (GtkMenuItem *menuitem);
void swamiui_menu_cb_spanwin_velocity (GtkMenuItem *menuitem);

void swamiui_menu_cb_restart_drivers (GtkWidget *widg);
void swamiui_menu_set_lowpane_radio_item (int mode);
void swamiui_menu_set_piano_mode_radio_item (int mode);

GtkWidget *swamiui_tbar_new (void);
void swamiui_tbar_update_drivers_togbtn (void);
void swamiui_tbar_set_drivers_togbtn (gboolean active);
void swamiui_tbar_set_lowpane_togbtn (int mode);
void swamiui_tbar_set_piano_mode_togbtn (gint mode);

#endif
