

#include "SWF.h"
#include "SWFItem.h"
#include "SWFList.h"

namespace SWF {


//////////////////////////////////// Rectangle

void Rectangle::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Rectangle @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(bits,5);
	w->putNBitInt(left,bits,true);
	w->putNBitInt(right,bits,true);
	w->putNBitInt(top,bits,true);
	w->putNBitInt(bottom,bits,true);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Rectangle has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Color

void Color::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Color @%i\n", start/8 );
		dump(1,ctx);
	}
w->putByte(red);
	w->putByte(green);
	w->putByte(blue);
	
	if( ctx->alpha ) {
		w->putByte(alpha);
	
	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Color has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// String

void String::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE String @%i\n", start/8 );
		dump(1,ctx);
	}
w->putString(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: String has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Transform

void Transform::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Transform @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(scaled,1);
	
	if( scaled ) {
	
		w->putNBitInt(bitsScale,5);
	w->putNBitFixed(scaleX,bitsScale,16,true);
	w->putNBitFixed(scaleY,bitsScale,16,true);
	
	}
w->putNBitInt(skewed,1);
	
	if( skewed ) {
	
		w->putNBitInt(bitsSkew,5);
	w->putNBitFixed(skewX,bitsSkew,16,true);
	w->putNBitFixed(skewY,bitsSkew,16,true);
	
	}
w->putNBitInt(bitsTranslate,5);
	w->putNBitInt(transX,bitsTranslate,true);
	w->putNBitInt(transY,bitsTranslate,true);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Transform has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ColorTransform2

void ColorTransform2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ColorTransform2 @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(hasOffset,1);
	w->putNBitInt(hasFactor,1);
	w->putNBitInt(bits,4);
	
	if( hasFactor ) {
	
		w->putNBitInt(factorRed,bits,true);
	w->putNBitInt(factorGreen,bits,true);
	w->putNBitInt(factorBlue,bits,true);
	w->putNBitInt(factorAlpha,bits,true);
	
	}

	if( hasOffset ) {
	
		w->putNBitInt(offsetRed,bits,true);
	w->putNBitInt(offsetGreen,bits,true);
	w->putNBitInt(offsetBlue,bits,true);
	w->putNBitInt(offsetAlpha,bits,true);
	
	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ColorTransform2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Header

void Header::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Header @%i\n", start/8 );
		dump(1,ctx);
	}
size.write(w,ctx);
w->putNBitInt(framerate,16);
	w->putWord(frames);
	
	{
		int start = w->getPosition();
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list tags has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Header has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LineStyle

void LineStyle::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LineStyle @%i\n", start/8 );
		dump(1,ctx);
	}
w->putWord(width);
	
	if( ctx->tagVersion < 4 ) {
		color.write(w,ctx);

	}

	if( ctx->tagVersion > 3 ) {
		w->putNBitInt(startCapStyle,2);
	w->putNBitInt(jointStyle,2);
	w->putNBitInt(hasFill,1);
	w->putNBitInt(noHScale,1);
	w->putNBitInt(noVScale,1);
	w->putNBitInt(pixelHinting,1);
	w->putNBitInt(reserved,5);
	w->putNBitInt(noClose,1);
	w->putNBitInt(endCapStyle,2);
	
	if( jointStyle==2 ) {
		w->putWord(miterLimitFactor);
	
	}

	if( hasFill ) {
		
	{
		int start = w->getPosition();
		Style *item;
		ListItem<Style>* i;
		i = fillStyles.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list fillStyles has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( !hasFill ) {
		fillColor.write(w,ctx);

	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LineStyle has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StyleList

void StyleList::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StyleList @%i\n", start/8 );
		dump(1,ctx);
	}

    {
        int v = n_fillStyles;
        if( v >= 255  && ctx->tagVersion >= 2 ) {
            w->putByte( 255 );
            w->putWord( v );
        } else {
            w->putByte( v );
        }
    }

	
	{
		Style *item;
		ListItem<Style>* i;
		i = fillStyles.first();
		for( int j=0; j<n_fillStyles; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list fillStyles has %i items (%i expected)\n", j, n_fillStyles );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

    {
        int v = n_lineStyles;
        if( v >= 255  && ctx->tagVersion >= 2 ) {
            w->putByte( 255 );
            w->putWord( v );
        } else {
            w->putByte( v );
        }
    }

	
	{
		LineStyle *item;
		ListItem<LineStyle>* i;
		i = lineStyles.first();
		for( int j=0; j<n_lineStyles; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list lineStyles has %i items (%i expected)\n", j, n_lineStyles );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putNBitInt(fillBits,4);
	
		ctx->fillBits = fillBits;
	w->putNBitInt(lineBits,4);
	
		ctx->lineBits = lineBits;
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StyleList has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ShapeSetup

void ShapeSetup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ShapeSetup @%i\n", start/8 );
		dump(1,ctx);
	}
ShapeItem::writeHeader( w, ctx, getSize(ctx,w->getBitPosition())/8 );
		w->putNBitInt(hasNewStyles,1);
	w->putNBitInt(hasLineStyle,1);
	w->putNBitInt(hasFillStyle1,1);
	w->putNBitInt(hasFillStyle0,1);
	w->putNBitInt(hasMoveTo,1);
	
	if( hasMoveTo ) {
	
		w->putNBitInt(xybits,5);
	w->putNBitInt(x,xybits,true);
	w->putNBitInt(y,xybits,true);
	
	}

	if( hasFillStyle0 ) {
	
		w->putNBitInt(fillStyle0,ctx->fillBits);
	
	}

	if( hasFillStyle1 ) {
	
		w->putNBitInt(fillStyle1,ctx->fillBits);
	
	}

	if( hasLineStyle ) {
	
		w->putNBitInt(lineStyle,ctx->lineBits);
	
	}

	if( hasNewStyles ) {
	
		
	w->byteAlign();
styles.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ShapeSetup has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CurveTo

void CurveTo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CurveTo @%i\n", start/8 );
		dump(1,ctx);
	}
ShapeItem::writeHeader( w, ctx, getSize(ctx,w->getBitPosition())/8 );
		w->putNBitInt(bits,4);
	w->putNBitInt(x1,bits+2,true);
	w->putNBitInt(y1,bits+2,true);
	w->putNBitInt(x2,bits+2,true);
	w->putNBitInt(y2,bits+2,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CurveTo has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Shape

void Shape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Shape @%i\n", start/8 );
		dump(1,ctx);
	}

	{
		int start = w->getPosition();
		ShapeItem *item;
		ListItem<ShapeItem>* i;
		i = edges.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list edges has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Shape has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GlyphShape

void GlyphShape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GlyphShape @%i\n", start/8 );
		dump(1,ctx);
	}

	ctx->fillBits = 1;

	ctx->lineBits = 0;
w->putNBitInt(fillBits,4);
	w->putNBitInt(lineBits,4);
	
	{
		int start = w->getPosition();
		ShapeItem *item;
		ListItem<ShapeItem>* i;
		i = edges.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list edges has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GlyphShape has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GradientItem

void GradientItem::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GradientItem @%i\n", start/8 );
		dump(1,ctx);
	}
w->putByte(position);
	color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GradientItem has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Symbol

void Symbol::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Symbol @%i\n", start/8 );
		dump(1,ctx);
	}
w->putWord(objectID);
	w->putString(name);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Symbol has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Parameter

void Parameter::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Parameter @%i\n", start/8 );
		dump(1,ctx);
	}
w->putByte(reg);
	w->putString(name);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Parameter has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// UChar

void UChar::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE UChar @%i\n", start/8 );
		dump(1,ctx);
	}
w->putByte(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: UChar has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// UShort

void UShort::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE UShort @%i\n", start/8 );
		dump(1,ctx);
	}
w->putWord(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: UShort has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ULong

void ULong::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ULong @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(value,32);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ULong has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Short

void Short::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Short @%i\n", start/8 );
		dump(1,ctx);
	}
w->putWord(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Short has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Float

void Float::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Float @%i\n", start/8 );
		dump(1,ctx);
	}
w->putFloat(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Float has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Kerning

void Kerning::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Kerning @%i\n", start/8 );
		dump(1,ctx);
	}
w->putByte(a);
	w->putByte(b);
	w->putNBitInt(adjustment,16,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Kerning has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// WideKerning

void WideKerning::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE WideKerning @%i\n", start/8 );
		dump(1,ctx);
	}
w->putWord(a);
	w->putWord(b);
	w->putWord(adjustment);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: WideKerning has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextEntry

void TextEntry::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextEntry @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(glyph,ctx->glyphBits);
	w->putNBitInt(advance,ctx->advanceBits,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextEntry has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextEntry2

void TextEntry2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextEntry2 @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(glyph,ctx->glyphBits2);
	w->putNBitInt(advance,ctx->advanceBits2,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextEntry2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord6

void TextRecord6::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord6 @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(isSetup,1);
	
	if( isSetup ) {
	
		w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(objectID);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	}

	if( !isSetup ) {
	
		w->putNBitInt(nGlyphs,7);
	
	{
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	w->byteAlign();

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord6 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord62

void TextRecord62::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord62 @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(isSetup,1);
	
	if( isSetup ) {
	
		w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(objectID);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	}

	if( !isSetup ) {
	
		w->putNBitInt(nGlyphs,7);
	
	{
		TextEntry2 *item;
		ListItem<TextEntry2>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	w->byteAlign();

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord62 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord7

void TextRecord7::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord7 @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(isSetup,1);
	w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(objectID);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	if( isSetup ) {
	
		w->putByte(nGlyphs);
	
	{
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord7 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord72

void TextRecord72::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord72 @%i\n", start/8 );
		dump(1,ctx);
	}

	ctx->alpha = 1;
w->putNBitInt(isSetup,1);
	w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(fontRef);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	if( isSetup ) {
	
		w->putByte(nGlyphs);
	
	{
		TextEntry2 *item;
		ListItem<TextEntry2>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord72 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord

void TextRecord::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord @%i\n", start/8 );
		dump(1,ctx);
	}

	if( ctx->tagVersion < 2 ) {
		
	{
		int start = w->getPosition();
		TextRecord6 *item;
		ListItem<TextRecord6>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( ctx->tagVersion >= 2 ) {
		string.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TextRecord2

void TextRecord2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord2 @%i\n", start/8 );
		dump(1,ctx);
	}

	if( ctx->swfVersion < 7 ) {
		
	{
		int start = w->getPosition();
		TextRecord62 *item;
		ListItem<TextRecord62>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( ctx->swfVersion >= 7 ) {
		textString.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TextRecord2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Button

void Button::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Button @%i\n", start/8 );
		dump(1,ctx);
	}
w->putNBitInt(reserved,4);
	w->putNBitInt(hitTest,1);
	w->putNBitInt(down,1);
	w->putNBitInt(over,1);
	w->putNBitInt(up,1);
	
	if( hitTest || down || over || up ) {
		w->putWord(objectID);
	w->putWord(depth);
	transform.write(w,ctx);

	if( ctx->tagVersion >= 2 ) {
		colorTransform.write(w,ctx);

	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Button has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Event

void Event::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Event @%i\n", start/8 );
		dump(1,ctx);
	}

		{
			int r = 0;
			
	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx,r);
			}
			i = i->next();
		}
	}
actionLength = (r/8);
		}
	
	w->byteAlign();
w->putWord(flags1);
	
	if( ctx->swfVersion>=6 ) {
		w->putWord(flags2);
	
	}

	if( (flags1 | flags2) ) {
		w->putInt(actionLength);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Event has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Condition

void Condition::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Condition @%i\n", start/8 );
		dump(1,ctx);
	}

		if( !ctx->isLast ) {
			int r = 0;
			
	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r += 7;

	r++;

	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx,r);
			}
			i = i->next();
		}
	}
next = (r/8) - (-2);
		} else {
			next = 0;
		}
	w->putWord(next);
	w->putNBitInt(menuEnter,1);
	w->putNBitInt(pointerReleaseOutside,1);
	w->putNBitInt(pointerDragEnter,1);
	w->putNBitInt(pointerDragLeave,1);
	w->putNBitInt(pointerReleaseInside,1);
	w->putNBitInt(pointerPush,1);
	w->putNBitInt(pointerLeave,1);
	w->putNBitInt(pointerEnter,1);
	w->putNBitInt(key,7);
	w->putNBitInt(menuLeave,1);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Condition has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// UnknownFilter

void UnknownFilter::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE UnknownFilter @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: UnknownFilter has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DropShadow

void DropShadow::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DropShadow @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
color.write(w,ctx);
w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitFixed2(angle,32,16,true);
	w->putNBitFixed2(distance,32,16,true);
	w->putNBitFixed2(strength,16,8,true);
	w->putNBitInt(innerShadow,1);
	w->putNBitInt(knockout,1);
	w->putNBitInt(compositeSource,1);
	w->putNBitInt(passes,5);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DropShadow has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Blur

void Blur::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Blur @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitInt(passes,5);
	w->putNBitInt(reserved1,3);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Blur has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Glow

void Glow::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Glow @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
color.write(w,ctx);
w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitFixed2(strength,16,8,true);
	w->putNBitInt(innerGlow,1);
	w->putNBitInt(knockout,1);
	w->putNBitInt(compositeSource,1);
	w->putNBitInt(passes,5);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Glow has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Bevel

void Bevel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Bevel @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
shadowColor.write(w,ctx);
highlightColor.write(w,ctx);
w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitFixed2(angle,32,16,true);
	w->putNBitFixed2(distance,32,16,true);
	w->putNBitFixed2(strength,16,8,true);
	w->putNBitInt(innerShadow,1);
	w->putNBitInt(knockout,1);
	w->putNBitInt(compositeSource,1);
	w->putNBitInt(onTop,1);
	w->putNBitInt(passes,4);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Bevel has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GradientGlow

void GradientGlow::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GradientGlow @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
w->putByte(numColors);
	
	{
		Color *item;
		ListItem<Color>* i;
		i = colors.first();
		for( int j=0; j<numColors; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list colors has %i items (%i expected)\n", j, numColors );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		UChar *item;
		ListItem<UChar>* i;
		i = ratio.first();
		for( int j=0; j<numColors; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list ratio has %i items (%i expected)\n", j, numColors );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitFixed2(angle,32,16,true);
	w->putNBitFixed2(distance,32,16,true);
	w->putNBitFixed2(strength,16,8,true);
	w->putNBitInt(innerGlow,1);
	w->putNBitInt(knockout,1);
	w->putNBitInt(compositeSource,1);
	w->putNBitInt(onTop,1);
	w->putNBitInt(passes,4);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GradientGlow has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Convolution

void Convolution::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Convolution @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
w->putByte(matrixX);
	w->putByte(matrixY);
	w->putFloat(divizor);
	w->putFloat(bias);
	
	{
		int start = w->getPosition();
		Float *item;
		ListItem<Float>* i;
		i = matrix.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list matrix has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
defaultColor.write(w,ctx);
w->putNBitInt(reserved,5);
	w->putNBitInt(clamp,1);
	w->putNBitInt(preserveAlpha,1);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Convolution has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ColorMatrix

void ColorMatrix::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ColorMatrix @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	{
		int start = w->getPosition();
		Float *item;
		ListItem<Float>* i;
		i = matrix.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list matrix has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ColorMatrix has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GradientBevel

void GradientBevel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GradientBevel @%i\n", start/8 );
		dump(1,ctx);
	}
Filter::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
w->putByte(numColors);
	
	{
		Color *item;
		ListItem<Color>* i;
		i = colors.first();
		for( int j=0; j<numColors; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list colors has %i items (%i expected)\n", j, numColors );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		UChar *item;
		ListItem<UChar>* i;
		i = ratio.first();
		for( int j=0; j<numColors; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list ratio has %i items (%i expected)\n", j, numColors );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putNBitFixed2(blurX,32,16,true);
	w->putNBitFixed2(blurY,32,16,true);
	w->putNBitFixed2(angle,32,16,true);
	w->putNBitFixed2(distance,32,16,true);
	w->putNBitFixed2(strength,16,8,true);
	w->putNBitInt(innerGlow,1);
	w->putNBitInt(knockout,1);
	w->putNBitInt(compositeSource,1);
	w->putNBitInt(onTop,1);
	w->putNBitInt(passes,4);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GradientBevel has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Solid

void Solid::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Solid @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Solid has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LinearGradient

void LinearGradient::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LinearGradient @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		matrix.write(w,ctx);
w->putByte(count);
	
	{
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list gradientColors has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LinearGradient has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// RadialGradient

void RadialGradient::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE RadialGradient @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		matrix.write(w,ctx);
w->putByte(count);
	
	{
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list gradientColors has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: RadialGradient has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TiledBitmap

void TiledBitmap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TiledBitmap @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TiledBitmap has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ClippedBitmap

void ClippedBitmap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ClippedBitmap @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ClippedBitmap has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TiledBitmap2

void TiledBitmap2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TiledBitmap2 @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TiledBitmap2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ClippedBitmap2

void ClippedBitmap2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ClippedBitmap2 @%i\n", start/8 );
		dump(1,ctx);
	}
Style::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ClippedBitmap2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// UnknownTag

void UnknownTag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE UnknownTag @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: UnknownTag has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// End

void End::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE End @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: End has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ShowFrame

void ShowFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ShowFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ShowFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineShape

void DefineShape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 0;

	ctx->many_shapes = 0;

	ctx->tagVersion = 1;
w->putWord(objectID);
	bounds.write(w,ctx);
styles.write(w,ctx);
shapes.write(w,ctx);

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineShape has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// RemoveObject

void RemoveObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE RemoveObject @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putWord(depth);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: RemoveObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineBits

void DefineBits::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineBits @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineBits has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetBackgroundColor

void SetBackgroundColor::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetBackgroundColor @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 0;
color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetBackgroundColor has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineText

void DefineText::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineText @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	bounds.write(w,ctx);
transform.write(w,ctx);
w->putByte(glyphBits);
	
		ctx->glyphBits = glyphBits;
	w->putByte(advanceBits);
	
		ctx->advanceBits = advanceBits;
	
	ctx->alpha = 0;

	ctx->tagVersion = 1;

	{
		int start = w->getPosition();
		TextRecord *item;
		ListItem<TextRecord>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineText has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineText2

void DefineText2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineText2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
w->putWord(objectID);
	bounds.write(w,ctx);
transform.write(w,ctx);
w->putByte(glyphBits2);
	
		ctx->glyphBits2 = glyphBits2;
	w->putByte(advanceBits2);
	
		ctx->advanceBits2 = advanceBits2;
	
	{
		int start = w->getPosition();
		TextRecord2 *item;
		ListItem<TextRecord2>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineText2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DoAction

void DoAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DoAction @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DoAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFontInfo

void DefineFontInfo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFontInfo @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putByte(nameLength);
	
	if( nameLength && nameData ) {
		w->putData( nameData, nameLength );
	}
	w->byteAlign();
w->putNBitInt(reserved,2);
	w->putNBitInt(smallTextOrUnicode,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(isItalic,1);
	w->putNBitInt(isBold,1);
	w->putNBitInt(isWide,1);
	
	if( ctx->swfVersion>=6 ) {
		w->putByte(language);
	
	}
map.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFontInfo has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineSound

void DefineSound::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineSound @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putNBitInt(format,4);
	w->putNBitInt(rate,2);
	w->putNBitInt(is16bit,1);
	w->putNBitInt(stereo,1);
	w->putInt(samples);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineSound has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StartSound

void StartSound::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StartSound @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putNBitInt(reserved,2);
	w->putNBitInt(stopPlayback,1);
	w->putNBitInt(noMultiple,1);
	w->putNBitInt(hasEnvelope,1);
	w->putNBitInt(hasLoop,1);
	w->putNBitInt(hasOutPoint,1);
	w->putNBitInt(hasInPoint,1);
	
	if( hasInPoint ) {
	
		w->putInt(inPoint);
	
	}

	if( hasOutPoint ) {
	
		w->putInt(outPoint);
	
	}

	if( hasLoop ) {
	
		w->putWord(loop);
	
	}

	if( hasEnvelope ) {
	
		w->putByte(envelopeCount);
	envelopeData.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StartSound has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineShape2

void DefineShape2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 0;

	ctx->many_shapes = 1;

	ctx->tagVersion = 2;
w->putWord(objectID);
	bounds.write(w,ctx);
styles.write(w,ctx);
shapes.write(w,ctx);

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineShape2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineShape3

void DefineShape3::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape3 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;

	ctx->many_shapes = 1;

	ctx->tagVersion = 3;
w->putWord(objectID);
	bounds.write(w,ctx);
styles.write(w,ctx);
shapes.write(w,ctx);

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineShape3 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineShape4

void DefineShape4::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape4 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineShape4 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineShape5

void DefineShape5::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape5 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;

	ctx->many_shapes = 1;

	ctx->tagVersion = 5;
w->putWord(objectID);
	bounds.write(w,ctx);
strokeBounds.write(w,ctx);
w->putNBitInt(reserved,6);
	w->putNBitInt(nonScalingStrokes,1);
	w->putNBitInt(scalingStrokes,1);
	styles.write(w,ctx);
shapes.write(w,ctx);

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineShape5 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineMorphShape

void DefineMorphShape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineMorphShape @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineMorphShape has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFontInfo2

void DefineFontInfo2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFontInfo2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putByte(nameLength);
	
	if( nameLength && nameData ) {
		w->putData( nameData, nameLength );
	}
	w->byteAlign();
w->putNBitInt(reserved,2);
	w->putNBitInt(smallTextOrUnicode,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(isItalic,1);
	w->putNBitInt(isBold,1);
	w->putNBitInt(isWide,1);
	
	if( ctx->swfVersion>=6 ) {
		w->putByte(language);
	
	}
map.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFontInfo2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SoundStreamHead

void SoundStreamHead::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamHead @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(reserved,4);
	w->putNBitInt(playbackRate,2);
	w->putNBitInt(playbackSize,1);
	w->putNBitInt(playbackStereo,1);
	w->putNBitInt(compression,4);
	w->putNBitInt(soundRate,2);
	w->putNBitInt(soundSize,1);
	w->putNBitInt(soundStereo,1);
	w->putWord(sampleSize);
	
	if( compression==2 ) {
		latencySeek.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SoundStreamHead has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineBitsLossless

void DefineBitsLossless::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsLossless @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putByte(format);
	w->putWord(width);
	w->putWord(height);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineBitsLossless has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineBitsJPEG2

void DefineBitsJPEG2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsJPEG2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineBitsJPEG2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineBitsJPEG3

void DefineBitsJPEG3::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsJPEG3 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putInt(offset_to_alpha);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineBitsJPEG3 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineBitsLossless2

void DefineBitsLossless2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsLossless2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putByte(format);
	w->putWord(width);
	w->putWord(height);
	
	if( format==3 ) {
		w->putByte(n_colormap);
	
	}
data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineBitsLossless2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// PlaceObject2

void PlaceObject2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE PlaceObject2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(hasEventHandler,1);
	w->putNBitInt(hasClipDepth,1);
	w->putNBitInt(hasName,1);
	w->putNBitInt(hasMorph,1);
	w->putNBitInt(hasColorTransform,1);
	w->putNBitInt(hasTransform,1);
	w->putNBitInt(hasID,1);
	w->putNBitInt(replace,1);
	w->putWord(depth);
	
	if( hasID ) {
	
		w->putWord(objectID);
	
	}

	if( hasTransform ) {
	
		transform.write(w,ctx);

	}

	if( hasColorTransform ) {
	
		colorTransform.write(w,ctx);

	}

	if( hasMorph ) {
	
		w->putWord(morph);
	
	}

	if( hasName ) {
	
		w->putString(name);
	
	}

	if( hasClipDepth ) {
	
		w->putWord(clipDepth);
	
	}

	if( hasEventHandler ) {
	
		w->putWord(reserved);
	w->putWord(allflags1);
	
	if( ctx->swfVersion>=6 ) {
		w->putWord(allflags2);
	
	}

	{
		int start = w->getPosition();
		Event *item;
		ListItem<Event>* i;
		i = events.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list events has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: PlaceObject2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// RemoveObject2

void RemoveObject2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE RemoveObject2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(depth);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: RemoveObject2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineEditText

void DefineEditText::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineEditText @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->alpha = 1;
w->putWord(objectID);
	size.write(w,ctx);
w->putNBitInt(hasText,1);
	w->putNBitInt(wordWrap,1);
	w->putNBitInt(multiLine,1);
	w->putNBitInt(password,1);
	w->putNBitInt(readOnly,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMaxLength,1);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(reserved,1);
	w->putNBitInt(autoSize,1);
	w->putNBitInt(hasLayout,1);
	w->putNBitInt(notSelectable,1);
	w->putNBitInt(hasBorder,1);
	w->putNBitInt(reserved2,1);
	w->putNBitInt(isHTML,1);
	w->putNBitInt(useOutlines,1);
	
	if( hasFont ) {
	
		w->putWord(fontRef);
	w->putWord(fontHeight);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMaxLength ) {
	
		w->putWord(maxLength);
	
	}

	if( hasLayout ) {
	
		w->putByte(align);
	w->putWord(leftMargin);
	w->putWord(rightMargin);
	w->putWord(indent);
	w->putWord(leading);
	
	}
w->putString(variableName);
	
	if( hasText ) {
	
		w->putString(initialText);
	
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineEditText has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineSprite

void DefineSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineSprite @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putWord(frames);
	
	{
		int start = w->getPosition();
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list tags has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// FrameLabel

void FrameLabel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE FrameLabel @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(label);
	flags.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: FrameLabel has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SoundStreamHead2

void SoundStreamHead2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamHead2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(reserved,4);
	w->putNBitInt(playbackRate,2);
	w->putNBitInt(playbackSize,1);
	w->putNBitInt(playbackStereo,1);
	w->putNBitInt(compression,4);
	w->putNBitInt(soundRate,2);
	w->putNBitInt(soundSize,1);
	w->putNBitInt(soundStereo,1);
	w->putWord(sampleSize);
	
	if( compression==2 ) {
		latencySeek.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SoundStreamHead2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFont

void DefineFont::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFont @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->tagVersion = 1;

	ctx->wideGlyphOffsets = 0;
w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFont has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFont2

void DefineFont2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFont2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->tagVersion = 2;
w->putWord(objectID);
	w->putNBitInt(hasLayout,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isUnicode,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(wideGlyphOffsets,1);
	
		ctx->wideGlyphOffsets = wideGlyphOffsets;
	w->putNBitInt(wideMap,1);
	
		ctx->wideMap = wideMap;
	w->putNBitInt(italic,1);
	w->putNBitInt(bold,1);
	w->putByte(language);
	w->putPString(name);
	w->putWord(glyphCount);
	
		ctx->glyphCount = glyphCount;
	glyphs.write(w,ctx);

	if( hasLayout ) {
	
		w->putWord(ascent);
	w->putWord(descent);
	w->putWord(leading);
	
	{
		Short *item;
		ListItem<Short>* i;
		i = advance.first();
		for( int j=0; j<glyphCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list advance has %i items (%i expected)\n", j, glyphCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		Rectangle *item;
		ListItem<Rectangle>* i;
		i = bounds.first();
		for( int j=0; j<glyphCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list bounds has %i items (%i expected)\n", j, glyphCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(kerningCount);
	
	if( wideMap ) {
	
		
	{
		WideKerning *item;
		ListItem<WideKerning>* i;
		i = wideKerning.first();
		for( int j=0; j<kerningCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list wideKerning has %i items (%i expected)\n", j, kerningCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( !wideMap ) {
	
		
	{
		Kerning *item;
		ListItem<Kerning>* i;
		i = kerning.first();
		for( int j=0; j<kerningCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list kerning has %i items (%i expected)\n", j, kerningCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFont2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineButton

void DefineButton::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineButton @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->tagVersion = 1;
w->putWord(objectID);
	
	{
		int start = w->getPosition();
		Button *item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list buttons has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineButton has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineButton2

void DefineButton2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineButton2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	ctx->tagVersion = 2;
w->putWord(objectID);
	w->putNBitInt(reserved,7);
	w->putNBitInt(menu,1);
	w->putWord(buttonsSize);
	
	{
		int start = w->getPosition();
		Button *item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list buttons has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		int start = w->getPosition();
		Condition *item;
		ListItem<Condition>* i;
		i = conditions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list conditions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineButton2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Export

void Export::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Export @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(count);
	
	{
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list symbols has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Export has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Import

void Import::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Import @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(url);
	w->putWord(count);
	
	{
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list symbols has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Import has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DoInitAction

void DoInitAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DoInitAction @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(sprite);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DoInitAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SoundStreamBlock

void SoundStreamBlock::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamBlock @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SoundStreamBlock has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineVideoStream

void DefineVideoStream::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineVideoStream @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putWord(frames);
	w->putWord(width);
	w->putWord(height);
	w->putNBitInt(reserved,5);
	w->putNBitInt(deblocking,2);
	w->putNBitInt(smoothing,1);
	w->putByte(codec);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineVideoStream has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// VideoFrame

void VideoFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE VideoFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putWord(frame);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: VideoFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ScriptLimits

void ScriptLimits::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ScriptLimits @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(maxRecursionDepth);
	w->putWord(timeout);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ScriptLimits has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetTabIndex

void SetTabIndex::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetTabIndex @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(depth);
	w->putWord(tabIndex);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetTabIndex has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// PlaceObject3

void PlaceObject3::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE PlaceObject3 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(hasEventHandler,1);
	w->putNBitInt(hasClipDepth,1);
	w->putNBitInt(hasName,1);
	w->putNBitInt(hasMorph,1);
	w->putNBitInt(hasColorTransform,1);
	w->putNBitInt(hasTransform,1);
	w->putNBitInt(hasID,1);
	w->putNBitInt(replace,1);
	w->putNBitInt(reserved1,5);
	w->putNBitInt(hasCacheAsBitmap,1);
	w->putNBitInt(hasBlendMode,1);
	w->putNBitInt(hasFilterList,1);
	w->putWord(depth);
	
	if( hasID ) {
	
		w->putWord(objectID);
	
	}

	if( hasTransform ) {
	
		transform.write(w,ctx);

	}

	if( hasColorTransform ) {
	
		colorTransform.write(w,ctx);

	}

	if( hasMorph ) {
	
		w->putWord(morph);
	
	}

	if( hasName ) {
	
		w->putString(name);
	
	}

	if( hasClipDepth ) {
	
		w->putWord(clipDepth);
	
	}

	if( hasFilterList ) {
	
		w->putByte(numFilters);
	
	{
		Filter *item;
		ListItem<Filter>* i;
		i = filters.first();
		for( int j=0; j<numFilters; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list filters has %i items (%i expected)\n", j, numFilters );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( hasBlendMode ) {
	
		w->putByte(blendMode);
	
	}

	if( hasCacheAsBitmap ) {
	
		w->putByte(bitmapCaching);
	
	}

	if( hasEventHandler ) {
	
		w->putWord(reserved);
	w->putWord(allflags1);
	
	if( ctx->swfVersion>=6 ) {
		w->putWord(allflags2);
	
	}

	{
		int start = w->getPosition();
		Event *item;
		ListItem<Event>* i;
		i = events.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list events has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: PlaceObject3 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ImportAssets2

void ImportAssets2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ImportAssets2 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(url);
	w->putByte(reserved1);
	w->putByte(reserved2);
	w->putWord(count);
	
	{
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list symbols has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ImportAssets2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// FileAttributes

void FileAttributes::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE FileAttributes @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(reserved1,3);
	w->putNBitInt(hasMetaData,1);
	w->putNBitInt(reserved2,3);
	w->putNBitInt(useNetwork,1);
	w->putNBitInt(reserved3,24);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: FileAttributes has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFontInfo3

void DefineFontInfo3::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFontInfo3 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFontInfo3 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CSMTextSettings

void CSMTextSettings::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CSMTextSettings @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	w->putNBitInt(useFlashType,2);
	w->putNBitInt(gridFit,3);
	w->putNBitInt(reserved1,3);
	w->putFloat(thickness);
	w->putFloat(sharpness);
	w->putByte(reserved2);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CSMTextSettings has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineFont3

void DefineFont3::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineFont3 @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineFont3 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Metadata

void Metadata::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Metadata @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(RDF);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Metadata has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineScalingGrid

void DefineScalingGrid::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineScalingGrid @%i\n", start/8 );
		dump(1,ctx);
	}
Tag::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(objectID);
	splitter.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineScalingGrid has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackString

void StackString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackString @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackString has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackFloat

void StackFloat::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackFloat @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putFloat(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackFloat has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackNull

void StackNull::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackNull @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackNull has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackUndefined

void StackUndefined::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackUndefined @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackUndefined has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackRegister

void StackRegister::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackRegister @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(reg);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackRegister has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackBoolean

void StackBoolean::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackBoolean @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackBoolean has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackDouble

void StackDouble::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackDouble @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putDouble(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackDouble has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackInteger

void StackInteger::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackInteger @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putInt(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackInteger has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackDictionaryLookup

void StackDictionaryLookup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackDictionaryLookup @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(index);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackDictionaryLookup has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StackLargeDictionaryLookup

void StackLargeDictionaryLookup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StackLargeDictionaryLookup @%i\n", start/8 );
		dump(1,ctx);
	}
StackItem::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(index);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StackLargeDictionaryLookup has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// UnknownAction

void UnknownAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE UnknownAction @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: UnknownAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// EndAction

void EndAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE EndAction @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: EndAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// NextFrame

void NextFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE NextFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: NextFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// PreviousFrame

void PreviousFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE PreviousFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: PreviousFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Play

void Play::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Play @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Play has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Stop

void Stop::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Stop @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Stop has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ToggleQuality

void ToggleQuality::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ToggleQuality @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ToggleQuality has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StopSound

void StopSound::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StopSound @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StopSound has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// AddCast

void AddCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE AddCast @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: AddCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Substract

void Substract::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Substract @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Substract has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Mulitply

void Mulitply::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Mulitply @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Mulitply has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Divide

void Divide::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Divide @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Divide has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// EqualCast

void EqualCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE EqualCast @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: EqualCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LessThanCast

void LessThanCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LessThanCast @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LessThanCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LogicalAND

void LogicalAND::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LogicalAND @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LogicalAND has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LogicalOR

void LogicalOR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LogicalOR @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LogicalOR has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LogicalNOT

void LogicalNOT::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LogicalNOT @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LogicalNOT has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StringEqual

void StringEqual::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StringEqual @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StringEqual has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StringLength

void StringLength::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StringLength @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StringLength has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SubString

void SubString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SubString @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SubString has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Pop

void Pop::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Pop @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Pop has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// IntegralPart

void IntegralPart::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE IntegralPart @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: IntegralPart has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetVariable

void GetVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetVariable @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetVariable

void SetVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetVariable @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetTargetDynamic

void SetTargetDynamic::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetTargetDynamic @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetTargetDynamic has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ConcatenateString

void ConcatenateString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ConcatenateString @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ConcatenateString has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetProperty

void GetProperty::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetProperty @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetProperty has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetProperty

void SetProperty::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetProperty @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetProperty has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DuplicateSprite

void DuplicateSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DuplicateSprite @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DuplicateSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// RemoveSprite

void RemoveSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE RemoveSprite @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: RemoveSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Trace

void Trace::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Trace @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Trace has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StartDrag

void StartDrag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StartDrag @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StartDrag has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StopDrag

void StopDrag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StopDrag @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StopDrag has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StringLessThan

void StringLessThan::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StringLessThan @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StringLessThan has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Throw

void Throw::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Throw @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Throw has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CastObject

void CastObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CastObject @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CastObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Implements

void Implements::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Implements @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Implements has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Random

void Random::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Random @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Random has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// MultibyteStringLength

void MultibyteStringLength::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteStringLength @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: MultibyteStringLength has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ORD

void ORD::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ORD @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ORD has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CHR

void CHR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CHR @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CHR has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetTimer

void GetTimer::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetTimer @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetTimer has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// MultibyteSubString

void MultibyteSubString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteSubString @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: MultibyteSubString has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// MultibyteORD

void MultibyteORD::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteORD @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: MultibyteORD has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// MultibyteCHR

void MultibyteCHR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteCHR @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: MultibyteCHR has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Delete

void Delete::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Delete @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Delete has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeleteAll

void DeleteAll::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeleteAll @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeleteAll has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetLocalVariable

void SetLocalVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetLocalVariable @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetLocalVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CallFunction

void CallFunction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CallFunction @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CallFunction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Return

void Return::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Return @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Return has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Modulo

void Modulo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Modulo @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Modulo has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// New

void New::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE New @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: New has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeclareLocalVariable

void DeclareLocalVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeclareLocalVariable @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeclareLocalVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeclareArray

void DeclareArray::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeclareArray @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeclareArray has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeclareObject

void DeclareObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeclareObject @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeclareObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// TypeOf

void TypeOf::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE TypeOf @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: TypeOf has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetTarget

void GetTarget::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetTarget @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetTarget has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Enumerate

void Enumerate::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Enumerate @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Enumerate has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// AddTyped

void AddTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE AddTyped @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: AddTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// LessThanTyped

void LessThanTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE LessThanTyped @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: LessThanTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// EqualTyped

void EqualTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE EqualTyped @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: EqualTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineNumber

void DefineNumber::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineNumber @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineNumber has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DefineString

void DefineString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DefineString @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DefineString has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Duplicate

void Duplicate::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Duplicate @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Duplicate has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Swap

void Swap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Swap @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Swap has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetMember

void GetMember::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetMember @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetMember has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetMember

void SetMember::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetMember @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetMember has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Increment

void Increment::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Increment @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Increment has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Decrement

void Decrement::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Decrement @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Decrement has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CallMethod

void CallMethod::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CallMethod @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CallMethod has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// NewMethod

void NewMethod::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE NewMethod @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: NewMethod has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// InstanceOf

void InstanceOf::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE InstanceOf @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: InstanceOf has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// EnumerateObject

void EnumerateObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE EnumerateObject @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: EnumerateObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// AND

void AND::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE AND @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: AND has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// OR

void OR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE OR @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: OR has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// XOR

void XOR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE XOR @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: XOR has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ShiftLeft

void ShiftLeft::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ShiftLeft @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ShiftLeft has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ShiftRight

void ShiftRight::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ShiftRight @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ShiftRight has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// ShiftRightUnsigned

void ShiftRightUnsigned::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE ShiftRightUnsigned @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: ShiftRightUnsigned has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StrictEqual

void StrictEqual::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StrictEqual @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StrictEqual has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GreaterThanTyped

void GreaterThanTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GreaterThanTyped @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GreaterThanTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StringGreaterThan

void StringGreaterThan::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StringGreaterThan @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StringGreaterThan has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Extends

void Extends::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Extends @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Extends has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GotoFrame

void GotoFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GotoFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(frame);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GotoFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetURL

void GetURL::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetURL @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(url);
	w->putString(target);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetURL has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// StoreRegister

void StoreRegister::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE StoreRegister @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(reg);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: StoreRegister has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Dictionary

void Dictionary::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Dictionary @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(length);
	
	{
		String *item;
		ListItem<String>* i;
		i = strings.first();
		for( int j=0; j<length; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list strings has %i items (%i expected)\n", j, length );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Dictionary has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// WaitForFrame

void WaitForFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE WaitForFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(frame);
	w->putByte(skip);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: WaitForFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// SetTarget

void SetTarget::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE SetTarget @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(label);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: SetTarget has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GotoLabel

void GotoLabel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GotoLabel @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(label);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GotoLabel has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// WaitForFrameDynamic

void WaitForFrameDynamic::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE WaitForFrameDynamic @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(frame);
	w->putByte(skip);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: WaitForFrameDynamic has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeclareFunction2

void DeclareFunction2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeclareFunction2 @%i\n", start/8 );
		dump(1,ctx);
	}

		{
			int r = 0;
			
	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx,r);
			}
			i = i->next();
		}
	}
length = (r/8);
		}
	Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  - length );
		w->putString(name);
	w->putWord(argc);
	w->putByte(regc);
	w->putNBitInt(preloadThis,1);
	w->putNBitInt(suppressThis,1);
	w->putNBitInt(preloadArguments,1);
	w->putNBitInt(suppressArguments,1);
	w->putNBitInt(preloadSuper,1);
	w->putNBitInt(suppressSuper,1);
	w->putNBitInt(preloadRoot,1);
	w->putNBitInt(preloadParent,1);
	w->putNBitInt(preloadGlobal,1);
	w->putNBitInt(reserved,7);
	
	{
		Parameter *item;
		ListItem<Parameter>* i;
		i = args.first();
		for( int j=0; j<argc; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list args has %i items (%i expected)\n", j, argc );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(length);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeclareFunction2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// Try

void Try::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE Try @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putNBitInt(reserved,5);
	w->putNBitInt(catchInRegister,1);
	w->putNBitInt(doFinally,1);
	w->putNBitInt(doCatch,1);
	w->putWord(trySize);
	w->putWord(catchSize);
	w->putWord(finallySize);
	
	if( catchInRegister ) {
	
		w->putByte(reg);
	
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: Try has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// With

void With::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE With @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(size);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: With has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// PushData

void PushData::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE PushData @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		
	{
		int start = w->getPosition();
		StackItem *item;
		ListItem<StackItem>* i;
		i = items.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list items has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: PushData has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GetURL2

void GetURL2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GetURL2 @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(method);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GetURL2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// DeclareFunction

void DeclareFunction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE DeclareFunction @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putString(name);
	w->putWord(argc);
	
	{
		String *item;
		ListItem<String>* i;
		i = args.first();
		for( int j=0; j<argc; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list args has %i items (%i expected)\n", j, argc );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(length);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: DeclareFunction has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// BranchAlways

void BranchAlways::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE BranchAlways @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(byteOffset);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: BranchAlways has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// BranchIfTrue

void BranchIfTrue::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE BranchIfTrue @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putWord(byteOffset);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: BranchIfTrue has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// CallFrame

void CallFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE CallFrame @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: CallFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}


//////////////////////////////////// GotoExpression

void GotoExpression::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	if( ctx->debugTrace ) {
		printf("WRITE GotoExpression @%i\n", start/8 );
		dump(1,ctx);
	}
Action::writeHeader( w, ctx, (getSize(ctx,w->getBitPosition())/8)  );
		w->putByte(play);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx,start)) {
		printf("WARNING: GotoExpression has different size than expected: %i bits instead of %i\n", l, getSize(ctx,start) );
	}

}



}

