/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.NavDialogCreationOptions;
import org.eclipse.swt.internal.carbon.NavReplyRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        char[] buffer;
        String directoryPath = null;
        int titlePtr = 0;
        int messagePtr = 0;
        if (this.title != null) {
            buffer = new char[this.title.length()];
            this.title.getChars(0, buffer.length, buffer, 0);
            titlePtr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        }
        buffer = new char[this.message.length()];
        this.message.getChars(0, buffer.length, buffer, 0);
        messagePtr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        NavDialogCreationOptions options = new NavDialogCreationOptions();
        options.parentWindow = OS.GetControlOwner((int)this.parent.handle);
        options.windowTitle = options.clientName = titlePtr;
        options.optionFlags = 12544;
        options.message = messagePtr;
        options.location_h = (short)-1;
        options.location_v = (short)-1;
        int[] outDialog = new int[1];
        if (OS.NavCreateChooseFolderDialog((NavDialogCreationOptions)options, (int)0, (int)0, (int)0, (int[])outDialog) == 0) {
            OS.NavDialogRun((int)outDialog[0]);
            if (OS.NavDialogGetUserAction((int)outDialog[0]) == 4) {
                NavReplyRecord record = new NavReplyRecord();
                OS.NavDialogGetReply((int)outDialog[0], (NavReplyRecord)record);
                AEDesc selection = new AEDesc();
                selection.descriptorType = record.selection_descriptorType;
                selection.dataHandle = record.selection_dataHandle;
                int[] count = new int[1];
                OS.AECountItems((AEDesc)selection, (int[])count);
                if (count[0] > 0) {
                    int[] actualSize;
                    int[] theAEKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr((int)maximumSize);
                    int status = OS.AEGetNthPtr((AEDesc)selection, (int)1, (int)1718841958, (int[])theAEKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])(actualSize = new int[1]));
                    if (status == 0 && typeCode[0] == 1718841958) {
                        byte[] fsRef = new byte[actualSize[0]];
                        OS.memcpy((byte[])fsRef, (int)dataPtr, (int)actualSize[0]);
                        int dirUrl = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                        int dirString = OS.CFURLCopyFileSystemPath((int)dirUrl, (int)0);
                        OS.CFRelease((int)dirUrl);
                        int length = OS.CFStringGetLength((int)dirString);
                        buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters((int)dirString, (CFRange)range, (char[])buffer);
                        OS.CFRelease((int)dirString);
                        this.filterPath = directoryPath = new String(buffer);
                    }
                    OS.DisposePtr((int)dataPtr);
                }
            }
        }
        if (titlePtr != 0) {
            OS.CFRelease((int)titlePtr);
        }
        if (messagePtr != 0) {
            OS.CFRelease((int)messagePtr);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogDispose((int)outDialog[0]);
        }
        return directoryPath;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

