/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Status;

public class RegistryCacheReader {
    Factory cacheFactory;
    protected List objectTable = null;
    private boolean lazilyLoadExtensions;
    protected File cacheFile;
    public static final byte REGISTRY_CACHE_VERSION = 6;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    public RegistryCacheReader(File cacheFile, Factory factory, boolean lazilyLoadExtensions) {
        this.cacheFile = cacheFile;
        this.lazilyLoadExtensions = lazilyLoadExtensions;
        this.cacheFactory = factory;
        this.objectTable = new ArrayList();
    }

    public RegistryCacheReader(File cacheFile, Factory factory) {
        this(cacheFile, factory, false);
    }

    private int addToObjectTable(Object object) {
        this.objectTable.add(object);
        return this.objectTable.size() - 1;
    }

    private void debug(String msg) {
        System.out.println("RegistryCacheReader: " + msg);
    }

    private boolean readHeaderInformation(DataInputStream in, long expectedTimestamp) throws InvalidRegistryCacheException {
        try {
            if (in.readInt() != 6) {
                return false;
            }
            long installStamp = in.readLong();
            long registryStamp = in.readLong();
            String osStamp = in.readUTF();
            String windowsStamp = in.readUTF();
            String localeStamp = in.readUTF();
            InternalPlatform info = InternalPlatform.getDefault();
            return (expectedTimestamp == 0L || expectedTimestamp == registryStamp) && installStamp == InternalPlatform.getDefault().getStateTimeStamp() && osStamp.equals(info.getOS()) && windowsStamp.equals(info.getWS()) && localeStamp.equals(info.getNL());
        }
        catch (IOException e) {
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "HeaderInformation"), e);
        }
    }

    private ConfigurationElement readConfigurationElement(RegistryModelObject parent, DataInputStream in) throws IOException {
        ConfigurationElement result = this.cacheFactory.createConfigurationElement();
        result.setParent(parent);
        result.setName(this.readString(in, true));
        result.setValue(this.readString(in, true));
        int length = in.readInt();
        ConfigurationProperty[] properties = new ConfigurationProperty[length];
        int i = 0;
        while (i < length) {
            properties[i] = this.readConfigurationProperty(in);
            ++i;
        }
        result.setProperties(properties);
        length = in.readInt();
        IConfigurationElement[] elements = new ConfigurationElement[length];
        int i2 = 0;
        while (i2 < length) {
            elements[i2] = this.readConfigurationElement(result, in);
            ++i2;
        }
        result.setChildren(elements);
        return result;
    }

    private ConfigurationProperty readConfigurationProperty(DataInputStream in) throws IOException {
        ConfigurationProperty result = this.cacheFactory.createConfigurationProperty();
        result.setName(this.readString(in, true));
        result.setValue(this.readString(in, true));
        return result;
    }

    private Extension readExtension(DataInputStream in) throws InvalidRegistryCacheException {
        Extension result = null;
        try {
            result = (Extension)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createExtension();
            this.addToObjectTable(result);
            result.setSimpleIdentifier(this.readString(in, true));
            result.setParent(this.readBundleModel(in));
            result.setName(this.readString(in, false));
            result.setExtensionPointIdentifier(this.readString(in, true));
            result.setSubElements(this.readSubElements(result, in));
            return result;
        }
        catch (IOException e) {
            String extensionId = null;
            if (result != null && result.getParent() != null) {
                extensionId = String.valueOf(result.getParentIdentifier()) + "." + result.getSimpleIdentifier();
            }
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "extension:  " + extensionId), e);
        }
    }

    private ExtensionPoint readExtensionPoint(BundleModel bundle, DataInputStream in) throws InvalidRegistryCacheException {
        ExtensionPoint result = null;
        try {
            result = (ExtensionPoint)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createExtensionPoint();
            this.addToObjectTable(result);
            result.setParent(bundle);
            result.setSimpleIdentifier(this.readString(in, true));
            result.setName(this.readString(in, false));
            result.setSchema(this.readString(in, true));
            int length = in.readInt();
            IExtension[] extensions = new Extension[length];
            int i = 0;
            while (i < length) {
                extensions[i] = this.readExtension(in);
                ++i;
            }
            result.setExtensions(extensions);
            return result;
        }
        catch (IOException e) {
            String extensionPointId = null;
            if (result != null && result.getParent() != null) {
                extensionPointId = result.getUniqueIdentifier();
            }
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "extension point: " + extensionPointId), e);
        }
    }

    private BundleModel readBundleModel(DataInputStream in) throws InvalidRegistryCacheException {
        BundleModel result = null;
        try {
            result = (BundleModel)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createBundle();
            this.addToObjectTable(result);
            result.setUniqueIdentifier(this.readString(in, true));
            result.setId(in.readLong());
            result.setParent(this.readRegistry(in));
            result.setHostIdentifier(this.readString(in, true));
            int length = in.readInt();
            IExtensionPoint[] extensionPoints = new ExtensionPoint[length];
            int i = 0;
            while (i < length) {
                extensionPoints[i] = this.readExtensionPoint(result, in);
                ++i;
            }
            result.setExtensionPoints(extensionPoints);
            length = in.readInt();
            IExtension[] extensions = new Extension[length];
            int i2 = 0;
            while (i2 < length) {
                extensions[i2] = this.readExtension(in);
                ++i2;
            }
            result.setExtensions(extensions);
            return result;
        }
        catch (IOException e) {
            String bundleId = result == null || result.getUniqueIdentifier() == null ? "<not available>" : result.getUniqueIdentifier();
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "plugin: " + bundleId), e);
        }
    }

    private ExtensionRegistry readCache(DataInputStream in, long expectedTimestamps) throws InvalidRegistryCacheException {
        if (!this.readHeaderInformation(in, expectedTimestamps)) {
            if (InternalPlatform.DEBUG_REGISTRY) {
                this.debug("Cache header information out of date - ignoring cache");
            }
            return null;
        }
        return this.readRegistry(in);
    }

    private ExtensionRegistry readRegistry(DataInputStream in) throws InvalidRegistryCacheException {
        try {
            ExtensionRegistry result = (ExtensionRegistry)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createRegistry();
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            this.addToObjectTable(result);
            int length = in.readInt();
            if (length == 0) {
                return null;
            }
            int i = 0;
            while (i < length) {
                result.basicAdd(this.readBundleModel(in), false);
                ++i;
            }
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            return result;
        }
        catch (IOException e) {
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "ExtensionRegistry"), e);
        }
    }

    private ConfigurationElement[] readSubElements(Extension parent, DataInputStream in) throws IOException, InvalidRegistryCacheException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int offset = in.readInt();
        if (this.lazilyLoadExtensions) {
            Extension extension = parent;
            extension.setSubElementsCacheOffset(offset);
            this.checkSubElements(parent, in);
            extension.setFullyLoaded(false);
            return null;
        }
        return this.readBasicSubElements(parent, in);
    }

    private ConfigurationElement[] readBasicSubElements(Extension parent, DataInputStream in) throws IOException {
        in.readInt();
        int length = in.readInt();
        ConfigurationElement[] result = new ConfigurationElement[length];
        int i = 0;
        while (i < length) {
            result[i] = this.readConfigurationElement(parent, in);
            ++i;
        }
        in.readLong();
        return result;
    }

    private void checkSubElements(Extension parent, DataInputStream in) throws IOException, InvalidRegistryCacheException {
        CheckedInputStream checkedIn = new CheckedInputStream(in, new CRC32());
        int subElementsDataLength = in.readInt();
        if (checkedIn.skip(subElementsDataLength) != (long)subElementsDataLength) {
            String message = null;
            if (InternalPlatform.DEBUG_REGISTRY) {
                message = "EOF checking sub-elements data for extension " + parent.getName();
            }
            throw new InvalidRegistryCacheException(message);
        }
        long checksum = in.readLong();
        if (checksum != checkedIn.getChecksum().getValue()) {
            String message = null;
            if (InternalPlatform.DEBUG_REGISTRY) {
                message = "Checksum error checking sub-elements data for extension " + parent.getName();
            }
            throw new InvalidRegistryCacheException(message);
        }
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private Object readIndex(DataInputStream in) throws IOException {
        byte type = in.readByte();
        return type == 2 ? this.objectTable.get(in.readInt()) : null;
    }

    private DataInputStream openCacheFile() throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile), 2048));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ConfigurationElement[] loadConfigurationElements(Extension parent, int offset) {
        block11: {
            in = null;
            try {
                try {
                    in = this.openCacheFile();
                    in.skipBytes(offset);
                    in.readInt();
                    var9_4 = this.readBasicSubElements(parent, in);
                    var7_5 = null;
                }
                catch (IOException e) {
                    exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                    message = Policy.bind("meta.unableToReadCache");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                    break block11;
                }
                catch (Throwable t) {
                    message = Policy.bind("meta.registryCacheReadProblems");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, null));
                    exceptionToLog = InternalPlatform.DEBUG_REGISTRY != false ? t : null;
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, t.toString(), exceptionToLog));
                    break block11;
                }
            }
            catch (Throwable var8_23) {
                var7_6 = null;
                try {
                    if (in == null) throw var8_23;
                    in.close();
                    throw var8_23;
                }
                catch (IOException e) {
                    exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                    message = Policy.bind("meta.registryCacheReadProblems");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                }
                throw var8_23;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 164->175)] { 
lbl38:
            // 1 sources

            if (in == null) return var9_4;
            in.close();
            return var9_4;
lbl41:
            // 1 sources

            catch (IOException e) {
                exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                message = Policy.bind("meta.registryCacheReadProblems");
                InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
            }
            return var9_4;
        }
        var7_7 = null;
        try {}
        catch (IOException e) {
            exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
            message = Policy.bind("meta.registryCacheReadProblems");
            InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
            return new ConfigurationElement[0];
        }
        if (in == null) return new ConfigurationElement[0];
        in.close();
        return new ConfigurationElement[0];
    }

    public final ExtensionRegistry loadCache() {
        return this.loadCache(0L);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ExtensionRegistry loadCache(long expectedTimestamp) {
        block13: {
            in = null;
            try {
                in = this.openCacheFile();
            }
            catch (IOException e) {
                exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                message = Policy.bind("meta.unableToReadCache");
                InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                return null;
            }
            try {
                try {
                    var9_11 = this.readCache(in, expectedTimestamp);
                    var7_12 = null;
                }
                catch (InvalidRegistryCacheException e) {
                    exception = InternalPlatform.DEBUG_REGISTRY != false ? e.getCause() : null;
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, e.getMessage(), exception));
                    break block13;
                }
                catch (Throwable t) {
                    message = Policy.bind("meta.registryCacheReadProblems");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, null));
                    exceptionToLog = InternalPlatform.DEBUG_REGISTRY != false ? t : null;
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, t.toString(), exceptionToLog));
                    break block13;
                }
            }
            catch (Throwable var8_24) {
                var7_13 = null;
                try {
                    if (in == null) throw var8_24;
                    in.close();
                    throw var8_24;
                }
                catch (IOException e) {
                    exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                    message = Policy.bind("meta.registryCacheReadProblems");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                }
                throw var8_24;
            }
            ** try [egrp 3[TRYBLOCK] [6 : 202->213)] { 
lbl40:
            // 1 sources

            if (in == null) return var9_11;
            in.close();
            return var9_11;
lbl43:
            // 1 sources

            catch (IOException e) {
                exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
                message = Policy.bind("meta.registryCacheReadProblems");
                InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
            }
            return var9_11;
        }
        var7_14 = null;
        try {}
        catch (IOException e) {
            exception = InternalPlatform.DEBUG_REGISTRY != false ? e : null;
            message = Policy.bind("meta.registryCacheReadProblems");
            InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
            return null;
        }
        if (in == null) return null;
        in.close();
        return null;
    }

    public class InvalidRegistryCacheException
    extends Exception {
        public InvalidRegistryCacheException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public InvalidRegistryCacheException(String string) {
            super(string);
        }
    }
}

