/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Box.java,v $
   Revision 1.4  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.3  2004/02/07 21:04:50  bobintetley
   Fixed typo - createVerical should be createVertical

   Revision 1.2  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.1  2004/01/20 15:52:56  bobintetley
   Code from an anonymous developer


*/

package swingwtx.swing;

import swingwt.awt.*;

/**
 * @author Submitted by a kind developer who remains anonymous
 * Fixed up by Rob to subclass JPanel so it can be used as a Swing
 * container (SwingSet does this)
 */
public class Box extends JPanel {
    
    public Box(int axis) { 
        this(null, axis);
    }
    
    public Box(Container target, int axis) { 
        
        if (target != null) {
            target.add(this);
            setLayout(new BoxLayout(target, axis));
        }
        else
            setLayout(new BoxLayout(this, axis));
    }
                              
    public static Box createHorizontalBox() {
        return new Box(BoxLayout.X_AXIS);    
    }
    
    public static Box createVerticalBox() {
        return new Box(BoxLayout.Y_AXIS);    
    }
    
    public static Box createHorizontalBox(Container target) {
            return new Box(target, BoxLayout.X_AXIS);
    }
                                                                                                                        
    public static Box createVerticalBox(Container target) {
            return new Box(target, BoxLayout.Y_AXIS);
    }
                                                                                                                             
    public static Component createRigidArea(Dimension d) {
        return new Filler(d, d, d);
    }
                                                                                                                             
    public static Component createHorizontalStrut(int width) {
        // PENDING(jeff) change to Integer.MAX_VALUE. This hasn't been done
        // to date because BoxLayout alignment breaks.
        return new Filler(new Dimension(width,0), new Dimension(width,0), new Dimension(width, Short.MAX_VALUE));
    }
                                                                                                                             
    public static Component createVerticalStrut(int height) {
        // PENDING(jeff) change to Integer.MAX_VALUE. This hasn't been done
        // to date because BoxLayout alignment breaks.
        return new Filler(new Dimension(0,height), new Dimension(0,height), new Dimension(Short.MAX_VALUE, height));
    }
                                                                                                                             
    public static Component createGlue() {
        // PENDING(jeff) change to Integer.MAX_VALUE. This hasn't been done
        // to date because BoxLayout alignment breaks.
        return new Filler(new Dimension(0,0), new Dimension(0,0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }
                                                                                                                             
    public static Component createHorizontalGlue() {
        // PENDING(jeff) change to Integer.MAX_VALUE. This hasn't been done 
        // to date because BoxLayout alignment breaks.
        return new Filler(new Dimension(0,0), new Dimension(0,0), new Dimension(Short.MAX_VALUE, 0));
    }
                                                                                                                             
    public static Component createVerticalGlue() {
        // PENDING(jeff) change to Integer.MAX_VALUE. This hasn't been done
        // to date because BoxLayout alignment breaks.
        return new Filler(new Dimension(0,0), new Dimension(0,0), new Dimension(0, Short.MAX_VALUE));
    }                                                                                                                    
                                                                                                                             
    public static class Filler extends JPanel {
                                                                                                                             
        public Filler(Dimension min, Dimension pref, Dimension max) {
            reqMin = min;
            reqPref = pref;
            reqMax = max;
        }
                                                                                                                             
        public void changeShape(Dimension min, Dimension pref, Dimension max) {
            reqMin = min;
            reqPref = pref;
            reqMax = max;
            //invalidate();
        }
                                                                                                                             
        public Dimension getMinimumSize() {
            return reqMin;
        }
                                                                                                                             
        public Dimension getPreferredSize() {
            return reqPref;
        }
                                                                                                                             
        public Dimension getMaximumSize() {
            return reqMax;
        }
                                                                                                                             
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;
    }
}
