#include <vcl.h>
#pragma hdrstop
#include <windows.hpp>
#include <stdlib.h>
#include <stdio.h>
#include "editentryfrm.h"
#include <swdisprtf.h>

const float RulerAdj = 4.0/3.0;
const int GutterWid = 6;
//----------------------------------------------------------------------------
#pragma resource "*.dfm"
TEditEntry *EditEntry;
//----------------------------------------------------------------------------
__fastcall TEditEntry::TEditEntry(TComponent *Owner) : TForm(Owner) {
	ResultBuf = 0;
}


__fastcall TEditEntry::~TEditEntry() {
	if (ResultBuf)
		delete [] ResultBuf;
}


//----------------------------------------------------------------------------
void __fastcall TEditEntry::SelectionChange(TObject */*Sender*/) {
	char sizebuf[6];

	try {
		FUpdating = True;
		FirstInd->Left = int(RichEdit1->Paragraph->FirstIndent*RulerAdj)-
							4+GutterWid;
		LeftInd->Left  = int((RichEdit1->Paragraph->LeftIndent+
							RichEdit1->Paragraph->FirstIndent)*RulerAdj)-
							4+GutterWid;
		RightInd->Left = Ruler->ClientWidth-6-int(
						(RichEdit1->Paragraph->RightIndent+GutterWid)*RulerAdj);

		BoldButton->Down = RichEdit1->SelAttributes->Style.Contains(fsBold);
		ItalicButton->Down = RichEdit1->SelAttributes->Style.Contains(fsItalic);
		UnderlineButton->Down = RichEdit1->SelAttributes->Style.Contains(fsUnderline);

		BulletsButton->Down = bool(RichEdit1->Paragraph->Numbering);

		FontSize->Text = itoa(RichEdit1->SelAttributes->Size, sizebuf, 10);

		switch((int)RichEdit1->Paragraph->Alignment)
		{ case 0: LeftAlign->Down   = True; break;
		 case 1: RightAlign->Down  = True; break;
		 case 2: CenterAlign->Down = True; break;
		}
	}
	catch (...) {
		FUpdating = False;
	}
	FUpdating = False;
}


//----------------------------------------------------------------------------
TTextAttributes *__fastcall TEditEntry::CurrText(void)
{
    return RichEdit1->SelAttributes;
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::CheckFileSave(void)
{
	if ( RichEdit1->Modified ) {
		switch(MessageBox(Handle, "Save Changes?","Modify Comment",MB_YESNOCANCEL | MB_ICONQUESTION)) {
		case ID_YES    : ExtractRTF(); break;
		case ID_CANCEL : Abort(); break;
		default: 
			if (ResultBuf)
				delete [] ResultBuf;
			ResultBuf = 0;
			break;
		};
	}
}


void __fastcall TEditEntry::SetupRuler(void)
{    int iCtr = 1;
	char sTmp[201];
	while (iCtr < 200) {
	  sTmp[iCtr] = 9;
	  iCtr++;
	  sTmp[iCtr] = '|';
	  iCtr++;
	}
	Ruler->Caption = (AnsiString)sTmp;
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::SetEditRect(void)
{    TRect Rct = Rect(GutterWid, 0, RichEdit1->ClientWidth-GutterWid,
						 ClientHeight);
	SendMessage(RichEdit1->Handle, EM_SETRECT, 0, long(&Rct));
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FormCreate(TObject* /*Sender*/)
{    Application->OnHint = &ShowHint;
	SetupRuler();
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::ShowHint(TObject* /*Sender*/)
{    StatusBar->SimpleText = Application->Hint;
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::EditUndoClick(TObject* /*Sender*/)
{    if ( RichEdit1->HandleAllocated() )
	   SendMessage(RichEdit1->Handle, EM_UNDO, 0, 0);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::EditCutClick(TObject* /*Sender*/)
{    RichEdit1->CutToClipboard();
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::EditCopyClick(TObject* /*Sender*/)
{    RichEdit1->CopyToClipboard();
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::EditPasteClick(TObject* /*Sender*/)
{    RichEdit1->PasteFromClipboard();
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::RulerResize(TObject* /*Sender*/)
{     RulerLine->Width = (int)Ruler->ClientWidth - (RulerLine->Left*2);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FormResize(TObject* Sender)
{    SetEditRect();
	SelectionChange(Sender);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FormPaint(TObject* /*Sender*/)
{    SetEditRect();
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::BoldButtonClick(TObject* /*Sender*/)
{    if ( !FUpdating )
	{  if ( BoldButton->Down )
		 CurrText()->Style = CurrText()->Style << fsBold;
	   else
		 CurrText()->Style = CurrText()->Style >> fsBold;
	}
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::ItalicButtonClick(TObject* /*Sender*/)
{    if ( !FUpdating )
	{
	   if ( ItalicButton->Down )
		 CurrText()->Style = CurrText()->Style << fsItalic;
	   else
		 CurrText()->Style = CurrText()->Style >> fsItalic;
	}
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::UnderlineButtonClick(TObject* /*Sender*/)
{
	if ( !FUpdating ) {
		if ( UnderlineButton->Down )
			CurrText()->Style = CurrText()->Style << fsUnderline;
		else CurrText()->Style = CurrText()->Style >> fsUnderline;
	}
}


void __fastcall TEditEntry::FontSizeChange(TObject* /*Sender*/)
{
	int fontsize = atoi(FontSize->Text.c_str());

	if ((!FUpdating) &&  (fontsize)) {
		if (fontsize < 1) {
			ShowMessage("Please Enter a Number betweek 1 and 1638");
			FontSize->Text = 1;
		}
		else if (fontsize > 1638) {
			ShowMessage("Please Enter a Number betweek 1 and 1638");
			FontSize->Text = 1638;
		}
		CurrText()->Size = atoi(FontSize->Text.c_str());
	}
}


void __fastcall TEditEntry::AlignClick(TObject* Sender)
{
	if ( !FUpdating ) {
		TControl *oAliBtn = (TControl*)(Sender);
		RichEdit1->Paragraph->Alignment = (TAlignment)oAliBtn->Tag;
	}
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::BulletsButtonClick(TObject* /*Sender*/)
{    if ( !FUpdating )
	   RichEdit1->Paragraph->Numbering = (TNumberingStyle)BulletsButton->Down;
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FormCloseQuery(TObject* /*Sender*/,
	bool & CanClose)
{    try {
	  CheckFileSave();
	}
	catch (...) {
	  CanClose = False;
	}
}
//----------------------------------------------------------------------------

//***************************
//***Ruler Indent Dragging***
//***************************

//----------------------------------------------------------------------------
void __fastcall TEditEntry::RulerItemMouseDown(TObject * Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{    TLabel * oTmpLabel = (TLabel *)Sender;
	FDragOfs = oTmpLabel->Width / 2;
	oTmpLabel->Left = oTmpLabel->Left+X-FDragOfs;
	FDragging = True;
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::RulerItemMouseMove(TObject *Sender, TShiftState Shift, int X, int /*Y*/) {
    if (FDragging) {
	   TLabel *oTmpLabel = (TLabel *)Sender;
	   oTmpLabel->Left = oTmpLabel->Left+X-FDragOfs;
       oTmpLabel->Left -= oTmpLabel->Left % 10;
	}
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FirstIndMouseUp(TObject *Sender, TMouseButton
	Button, TShiftState Shift, int X, int Y)
{    FDragging = False;
	RichEdit1->Paragraph->FirstIndent = int((FirstInd->Left+FDragOfs-GutterWid) / RulerAdj);
	LeftIndMouseUp(Sender, Button, Shift, X, Y);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::LeftIndMouseUp(TObject *Sender, TMouseButton
	 /*Button*/, TShiftState /*Shift*/, int /*X*/,	int /*Y*/)
{    FDragging = False;
	RichEdit1->Paragraph->LeftIndent = int((LeftInd->Left+FDragOfs-GutterWid)/
			 RulerAdj)-RichEdit1->Paragraph->FirstIndent;
	SelectionChange(Sender);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::RightIndMouseUp(TObject *Sender, TMouseButton
	 /*Button*/, TShiftState /*Shift*/, int /*X*/,	int /*Y*/)
{    FDragging = False;
	RichEdit1->Paragraph->RightIndent =
	    int((Ruler->ClientWidth-RightInd->Left+FDragOfs-2) /
	    RulerAdj)-2*GutterWid;
	SelectionChange(Sender);
}
//----------------------------------------------------------------------------
void __fastcall TEditEntry::FormActivate(TObject *Sender)
{
	System::AnsiString newtext, tmptext;

	if (Module) {
		TMemoryStream *RTFStream = new TMemoryStream();
		newtext = RTFDisplay->RTFHeader;
		Module->Error(); // clear error;
		newtext = newtext + "\\pard \\nowidctlpar \\cf0 ";
		(const char *)*Module;	// force key to snap to entry before pulling out the text of the key
		tmptext = (const char *)*Module;
	
		newtext = newtext + RTFDisplay->RTFVersePre + " " + tmptext + RTFDisplay->RTFVersePost;
		newtext = newtext + RTFDisplay->RTFTrailer;
		RTFStream->Clear();
		RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
		RTFStream->Position = 0;
		RichEdit1->Lines->LoadFromStream(RTFStream);
		delete RTFStream;
	}
	SelectionChange(this);
	RichEdit1->SetFocus();
	if (ResultBuf)
		delete [] ResultBuf;
	ResultBuf = 0;
}
//---------------------------------------------------------------------

void TEditEntry::ExtractRTF()
{
	System::AnsiString newtext, tmptext;
	TMemoryStream *RTFStream = new TMemoryStream();
	char *tmpbuf, *datastart;

	RTFStream->Clear();
	RichEdit1->Lines->SaveToStream(RTFStream);
	RTFStream->Position = 0;
	if (ResultBuf)
		delete [] ResultBuf;
	tmpbuf = new char [ RTFStream->Size + 1];
	RTFStream->ReadBuffer(tmpbuf, RTFStream->Size);
	tmpbuf[RTFStream->Size] = 0;
	char *tbl = strstr(tmpbuf, "colortbl");
	if (!tbl)
		tbl = strstr(tmpbuf, "fonttbl");
	if (tbl) {    
		strtok(tbl, "}");
		datastart = strtok(NULL, "");
		ResultBuf = new char [ strlen(datastart) + 2 ];
		ResultBuf[0] = '{';
		strcpy(ResultBuf+1, datastart);
		delete [] tmpbuf;
		delete RTFStream;
		//--------  Change all fonts to \f1
		for (int i = 0; i < strlen(ResultBuf)-4; i++) {
			if (ResultBuf[i] == '\\') {
				if (ResultBuf[i+1] == '\\') {		//	skip a real '\' character
					i += 1;
					continue;
				}
				if (ResultBuf[i+1] == 'f') {
					if (isdigit(ResultBuf[i+2])) {
						ResultBuf[i+2] = '1';
                              if (isdigit(ResultBuf[i+3])) {
                                   memmove(&ResultBuf[i+3], &ResultBuf[i+4], strlen(&ResultBuf[i+3]));
                              }
                         }
                    }
               }
          }
     }
}


__fastcall TCharsetObject::TCharsetObject(int FCharset)
  : TObject()
{
     Charset = FCharset;
}
//---------------------------------------------------------------------------
