/*  Project sword
    
    GNU Copyleft GPL  1995. Almost No Rights Reserved.

    SUBSYSTEM:    sword.exe Application
    FILE:         swordapp.cpp
    AUTHOR:       The Sword Project Team


    OVERVIEW
    ========
    Source file for implementation of swordApp (TApplication).
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "swordapp.h"
#include "swrtdlgc.h"                        // Definition of client class.
#include "swrdabtd.h"                        // Definition of about dialog.
#include "serchdlg.h"

//{{swordApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(swordApp, TApplication)
//{{swordAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{swordAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// swordApp
// =====
//
swordApp::swordApp () : TApplication("sword")
{

    // INSERT>> Your constructor code here.
}


swordApp::~swordApp ()
{
    // INSERT>> Your destructor code here.
}


//////////////////////////////////////////////////////////
// swordApp
// =====
// Application intialization.
//
void swordApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false);
    frame->SetFlag(wfShrinkToClient);

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

  
    SetMainWindow(frame);

    frame->SetMenuDescr(TMenuDescr(SDI_MENU));
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
    : TDecoratedFrame(parent, title, clientWnd == 0 ? new swordTDLGClient(0) : clientWnd, trackMenuSelection, module)
{
}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// swordApp
// ===========
// Menu Help About sword.exe command
void swordApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    swordAboutDlg(MainWindow).Execute();
}
int OwlMain (int , char* [])
{
    try {
        swordApp    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}

void swordApp::SearchText ()
{
    SearchDlg(MainWindow).Execute();
}

