/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QXLIB_H
#define QXLIB_H

/**
 * @file
 *
 * This file exports functions from Xlib.  The functions work just like
 * their counterparts from the XLib headers, except that they are overloaded
 * to implicitly use QX11Info::display().
 *
 * Read the Xlib manpages for detailled information about the function
 * parameters.
 *
 * @note
 *
 * For the purpose of interoperation with Qt this header undefs a whole
 * bunch defines from Xlib.h
 */

#include <QtGui/QX11Info>
#include <QtCore/QSharedPointer>
extern "C" {
#include "X11/Xlib.h"
// clean namespace from Xlib pollution!
#undef Bool
#undef Status
#undef True
#undef False
#undef QueuedAlready
#undef QueuedAfterReading
#undef QueuedAfterFlush
}


namespace QX11 {

    inline Atom InternAtom(const char *name, bool only_if_exists) {
        return XInternAtom(QX11Info::display(), name, only_if_exists);
    }

    inline QByteArray GetAtomName(Atom atom) {
        QSharedPointer<char> name(
            XGetAtomName(QX11Info::display(), atom), XFree);
        return QByteArray(name.data());
    }

    inline int QueryKeymap(char keys_return[32]) {
        return XQueryKeymap(QX11Info::display(), keys_return);
    }

    inline QSharedPointer<XModifierKeymap> GetModifierMapping() {
        return QSharedPointer<XModifierKeymap>(
            XGetModifierMapping(QX11Info::display()), XFreeModifiermap);
    }
}


#endif /* QXLIB_H */
