C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CMPTFA,SSI=0
                        SUBROUTINE CMPTFA
C                       *****************
C
C     -------------------------------------------------
     * (NDIELE,NREFAC,NODES,NDMATS,NELEMS,NBFACE,NELESS,NELEUS,
     *  NBFFLU,NBFECH,NELERC,NELEPR,NELERA,NBFRAI,
     *  NREFS,NPOINS,NBCOUS,NBDIRS,NBRESS,NBPRIO,NBMOBS,
     *  NBFLUS,NBECHS,NBRAYS,NBRAIS,ITAB1,ITAB2)
C     -------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             COMPTE DES NOEUDS PORTANT LES DIVERSES CONDITIONS        *
C             POSSIBLES                                                *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIELE   !  E ! D  ! DIMENSION DES ELEMENTS                       !
C !  NREFAC   ! TE ! D  ! REFERENCES DES FACES SOLIDES (volumiques)    !
C !  NODES    ! TE ! D  ! CONNECTIVITE                                 !
C !  NDMATS   !  E ! D  ! RNOMBRE DE NOEUDS PAR ELEMENTS               !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELEMENTS                            !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACE DES ELEMENTS                  !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS SURF COUPLES   SOLIDES     !
C !  NELEUS   !  E ! D  ! NOMBRE D'ELEMENTS SURF TYPE FLUX SOLIDES     !
C !  NBFFLU   !  E ! R  ! NOMBRE DE FACES  SOLIDES AVEC CL DE TYPE FLUX!
C !  NBFECH   !  E ! R  ! NOMBRE DE FACES  SOLIDES AVEC CL COEF ECH    !
C !  NELERC   !  E ! R  ! NOMBRE DE FACES  SOLIDES AVEC CL RESI CONTACT!
C !  NELERA   !  E ! R  ! NOMBRE DE FACES  SOLIDES AVEC CL RAYONNEMENT !
C !  NBFRAI   !  E ! R  ! NOMBRE DE FACES  SOLIDES AVEC RAYONNEMENT INF!
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NBCOUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBDIRS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBRESS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBPRIO   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NBMOBS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES EN MOUVEMENT        !
C !  NBFLUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBECHS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBRAYS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBRAIS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT INF!
C !  NELEPR   !  E ! R  ! NOMBRE D'ELEMENTS PERIODIQUES                !
C !  ITAB1    ! TE ! A  ! TALBEAU DE TRAVAIL                           !
C !  IDIMT1   ! TE ! A  ! DIMENSION DE ITAB1                           !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "xrefer.h"
#include "optct.h"
#include "divct.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NDIELE,NELEMS,NBFACE,NDMATS
      INTEGER NODES(NELEMS,NDMATS),NREFAC(NELEMS,NBFACE)
      INTEGER NELESS,NELEUS,NBFFLU,NBFECH,NELERC,NBFRAI,NELEPR,NELERA
      INTEGER NPOINS,NREFS(NPOINS)
      INTEGER NBCOUS,NBDIRS,NBRESS
      INTEGER NBPRIO,NBMOBS,ITAB1(NPOINS),ITAB2(NPOINS)
      INTEGER NBFLUS,NBECHS,NBRAYS,NBRAIS
C
C.. Variables internes
      INTEGER I,J,NUMREF,N1,N,NBP,NUM,N2
      LOGICAL LPERIO
C
C     NARE(noeud,arete), NFAC(noeud,face)
      INTEGER NARE(3,3),NFAC(6,4)
C***********************************************************************
C
      DATA NARE/1,2,4,  2,3,5,  3,1,6/
      DATA NFAC/1,2,3,5,6,7,  1,2,4,5,9,8,  1,3,4,7,10,8,  2,3,4,6,10,9/
C
C     1- INITIALISATIONS
C     ------------------
C
      NBFLUS = 0
      NBRAYS = 0
      NBRAIS = 0
      NBECHS = 0
C
      NELESS = 0
      NBFFLU = 0
      NBFECH = 0
      NELERC = 0
      NELERA = 0
      NBFRAI = 0
C
      NBCOUS = 0
      NBDIRS = 0
      NBRESS = 0
      NBPRIO = 0
      NBMOBS = 0
C
      NELEPR = 0

      NELEUS = 0
C
C
      DO 10 N=1,NPOINS
        ITAB1(N) = 0
        ITAB2(N) = 0
   10 CONTINUE
C
      IF (NCTHFS.EQ.2) THEN
        NBP = 6
      ELSE
        IF (NDIELE.EQ.2) THEN
          NBP = 3
        ELSE
          NBP = 6
        ENDIF
      ENDIF
C
C
C     2.1- COMPTE DES FACES ET NOEUDS COUPLES OU REST DE CONTACT
C     ==========================================================
C 
       DO 200 J=1,NBFACE
        DO 210 I=1,NELEMS
C
         NUMREF = NREFAC(I,J)
C
         IF (NUMREF.NE.0) THEN
C
          DO 205 N1=1,NRFMAX
C
            IF (IREFSC(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NELESS = NELESS + 1
                DO 215 N=1,NBP
                  IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
                    NUM = NODES(I,NARE(N,J))
                  ELSEIF (NCTHFS.EQ.3 .AND. NDIELE.EQ.3) THEN 
                    NUM = NODES(I,NFAC(N,J))
                  ELSE
                    NUM = NODES(I,N)
                  ENDIF
                  IF (ITAB1(NUM).LE.0) THEN
                    NBCOUS = NBCOUS + 1
                    ITAB1(NUM) = 1
                  ENDIF
  215          CONTINUE   
            ENDIF
C
            IF (IREFSF(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBFFLU = NBFFLU + 1
            ENDIF
C            
            IF (IREFSE(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBFECH = NBFECH + 1
            ENDIF
C
            IF (IREFRE(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NELERC = NELERC + 1
                DO 216 N=1,NBP
                  IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
                    NUM = NODES(I,NARE(N,J))
                  ELSEIF (NCTHFS.EQ.3 .AND. NDIELE.EQ.3) THEN 
                    NUM = NODES(I,NFAC(N,J))
                  ELSE
                    NUM = NODES(I,N)
                  ENDIF
                  IF (ITAB2(NUM).LE.0) THEN
                    NBRESS = NBRESS + 1
                    ITAB2(NUM) = 1
                  ENDIF
  216           CONTINUE                  
            ENDIF
C
  205     CONTINUE
C
        ENDIF
C
  210   CONTINUE
  200  CONTINUE
C
C     2.2- COMPTE DES FACES ET NOEUDS AVEC RAYONNEMENT
C     ================================================
      DO 22 N=1,NPOINS
        ITAB1(N) = 0
        ITAB2(N) = 0
   22 CONTINUE
C 

       DO 220 J=1,NBFACE
        DO 230 I=1,NELEMS
C
         NUMREF = NREFAC(I,J)
C
         IF (NUMREF.NE.0) THEN
C
          DO 235 N1=1,NRFMAX
C
            IF (IREFRA(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NELERA = NELERA + 1
                DO 236 N=1,NBP
                  IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
                     NUM = NODES(I,NARE(N,J))
                  ELSEIF (NCTHFS.EQ.3 .AND. NDIELE.EQ.3) THEN 
                    NUM = NODES(I,NFAC(N,J))
                  ELSE
                    NUM = NODES(I,N)
                  ENDIF
                  IF (ITAB1(NUM).EQ.0) THEN
                    NBRAYS = NBRAYS + 1
                    IF (N.LE.NDIELE) THEN
                      ITAB1(NUM) = 1
                    ELSE
                      ITAB1(NUM) = -1
                    ENDIF
                 ENDIF
  236         CONTINUE   
            ENDIF
C
            IF (IREFRI(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBFRAI = NBFRAI + 1
                DO 237 N=1,NBP
                  IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
                    NUM = NODES(I,NARE(N,J))
                  ELSEIF (NCTHFS.EQ.3 .AND. NDIELE.EQ.3) THEN 
                    NUM = NODES(I,NFAC(N,J))
                  ELSE
                    NUM = NODES(I,N)
                  ENDIF
                  IF (ITAB2(NUM).LE.0) THEN
                    NBRAIS = NBRAIS + 1
                    ITAB2(NUM) = 1
                  ENDIF
  237          CONTINUE   
            ENDIF
C
  235     CONTINUE
C
        ENDIF
C
  230   CONTINUE
  220  CONTINUE
C
C     2B- COMPTE DES NOEUDS SOMMET AVEC RAYONNEMENT
C     =============================================
C
       NPRAP1 = 0
C
      DO 250 N=1,NPOINS
        IF (ITAB1(N).EQ. 1) NPRAP1 = NPRAP1 + 1
  250 CONTINUE
C
C
C     3- COMPTE DES NOEUDS SUIVANTS LES CL
C     ====================================
C
      DO 300 I=1,NPOINS
C
        NUMREF = NREFS(I)
C
        IF (NUMREF.NE.0) THEN
C
          DO 305 N1=1,NRFMAX
C
            IF (IREFSD(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBDIRS = NBDIRS + 1
            ENDIF
C
            IF (IREFPR(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBPRIO = NBPRIO + 1
            ENDIF
C
            IF (IREFMO(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBMOBS = NBMOBS + 1
            ENDIF
C
  305     CONTINUE
C
        ENDIF
C
  300 CONTINUE
C
C
C     4- COMPTE DES ELEMENTS PERIODIQUES
C     ==================================
C 
      DO 400 N=1,NELEMS
C
        LPERIO = .FALSE.
        DO 401 N1=1,NDMATS
          NUMREF = NREFS(NODES(N,N1))
          IF (NUMREF.NE.0) THEN
            DO 402 N2=1,NRFMAX
              IF (IREFPR(N2).NE.0 .AND. NUMREF.EQ.N2) LPERIO = .TRUE.
  402       CONTINUE
          ENDIF
  401   CONTINUE
        IF (LPERIO) NELEPR = NELEPR + 1
C
  400 CONTINUE
C
C
C     5- NOMBRE TOTAL D'ELEMENTS SURF DE TYPE FLUX
C     ============================================
      DO 500 J=1,NBFACE
       DO 510 I=1,NELEMS
C
         NUMREF = NREFAC(I,J)
C
         IF (NUMREF.NE.0) THEN
C
          DO 520 N1=1,NRFMAX
C
            IF (    (IREFSC(N1).NE.0 .AND. NUMREF.EQ.N1) 
     *          .OR.(IREFSF(N1).NE.0 .AND. NUMREF.EQ.N1) 
     *          .OR.(IREFSE(N1).NE.0 .AND. NUMREF.EQ.N1)  
     *          .OR.(IREFRE(N1).NE.0 .AND. NUMREF.EQ.N1) 
     *          .OR.(IREFRA(N1).NE.0 .AND. NUMREF.EQ.N1) 
     *          .OR.(IREFRI(N1).NE.0 .AND. NUMREF.EQ.N1)  )
     *             NELEUS = NELEUS + 1
  520     CONTINUE
         ENDIF
  510   CONTINUE
  500 CONTINUE
C
      END
