C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE COORFL
C                       *****************
C
C     ---------------------------------------------------------
     *(NDIM,NBCOUF,NBRAF,NPOINF,NREFF,XYZF,COORDF,COORAF,
     * NBFILS,NWMAIL,NWDN,NWDRN)
C     ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C              LECTURE DES COORDONNEES DU MAILLAGE SURFACIQUE COUPLE   *
C              CES DONNEEES SONT LUES DANS LE FICHIER DATA1 DE N3S     *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NDIM   !  TE  ! E  ! Dimension du probleme (2 pour 2D, 3 pour 3D)! 
C   ! NBCOUF !  E   ! D  ! Nombre de points fluides couples            !
C   ! NBRAF  !  E   ! D  ! Nombre de points fluides non couples + rayt !
C   ! NPOINF !  E   ! D  ! Nombre de points fluide total               !
C   ! NREFF  !  TE  ! D  ! Tableau des references fluides              !
C   ! COORDF !  TR  ! M  ! Coordonnes des points fluides couples       !
C   ! COORAF !  TR  ! M  ! Coordonnes des pts fluides non couples+rayt !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! D  !                                             !
C   !/FICHCT/!      ! D  !                                             !
C   !/XREFER/!      ! D  ! 
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :  
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "optct.h"
#include "nlofes.h"
C
C**********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINF,NBCOUF,NBRAF
      INTEGER NREFF(NPOINF),NBFILS,NWMAIL,NWDN,NWDRN
      DOUBLE PRECISION XYZF(NPOINF,NDIM)
      DOUBLE PRECISION COORDF(NBCOUF,NDIM),COORAF(NBRAF,NDIM)
C
C.. Variables internes
      INTEGER N,M,NC,NR
      LOGICAL LCOUPL,LRAYT
C
C**********************************************************************
C
C     1- INITIALISATION
C     =================
C
      NC = NWDN-1
      NR = NWDRN-1
C
      DO 100 N=1,NPOINF
C
        LCOUPL = .FALSE.
        LRAYT  = .FALSE.
        DO 110 M=1,NRFMAX
          IF (IREFFC(M).NE.0 .AND. NREFF(N).EQ.M) LCOUPL = .TRUE.
          IF (IREFRF(M).NE.0 .AND. NREFF(N).EQ.M) LRAYT = .TRUE.
 110    CONTINUE
C
        IF (LCOUPL) THEN
          NC = NC + 1
          COORDF(NC,1)=XYZF(N,1)
          COORDF(NC,2)=XYZF(N,2)
          IF (NDIM.EQ.3) COORDF(NC,3)=XYZF(N,3)
        ENDIF
        IF (LRAYT) THEN
          NR = NR + 1
          COORAF(NR,1)=XYZF(N,1)
          COORAF(NR,2)=XYZF(N,2)
          IF (NDIM.EQ.3) COORAF(NR,3)=XYZF(N,3)
        ENDIF
C
 100  CONTINUE
C
      IF (NWMAIL.EQ.NBFILS .AND.
     &    (NC.NE.NBCOUF .OR. NR.NE.NBRAF)) THEN
         WRITE(NFECRA,4000) NC,NBCOUF,NR,NBRAF
         STOP
      ENDIF
C
C--------
C FORMATS
C--------
 4000 FORMAT(/,' %% ERREUR COORFL : lors de la lecture des coordonnees'
     &        ,' pour le(s) fluide(s). On trouve :',/,
     &         20X,I6,' noeuds couples au lieu de ',I6,/,
     &         20X,I6,' noeuds avec rayonnement au lieu de ',I6 )
C
C
      END











