#ifndef TAGCOLL_BASIC_DISK_INDEX_H
#define TAGCOLL_BASIC_DISK_INDEX_H

/** \file
 * Fast generic on-disk index for string items and tags
 */

/*
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/Collection.h>
#include <tagcoll/Serializer.h>
#include <tagcoll/Exception.h>
#include <tagcoll/IntDiskIndex.h>
#include <tagcoll/StringIndex.h>
#include <tagcoll/InputMerger.h>

namespace Tagcoll
{

/**
 * Full TaggedCollection implementation on top of a persistent on-disk TDB
 * database.
 *
 * It allows to efficiently query a collection without having to store it all
 * into memory.
 */
class BasicStringDiskIndex : public MasterMMapIndex, public IntDiskIndex<std::string, std::string>
{
protected:
	StringIndex pkgs;
	StringIndex tags;

public:
	/**
	 * Create a new Indexer
	 *
	 * @param dir
	 *   The directory with the index files
	 */
	BasicStringDiskIndex(const std::string& file);
	virtual ~BasicStringDiskIndex() {}

	const std::string& filename() const { return m_filename; }

	static void remove(const std::string& dir);
};

class BasicStringDiskIndexer : public Consumer<std::string, std::string>
{
protected:
	InputMerger<std::string, std::string> cache;
	StringIndexer pkgs;
	StringIndexer tags;

	virtual void consumeItemUntagged(const std::string& item);
	virtual void consumeItem(const std::string& item, const OpSet<std::string>& tags);

public:
	virtual ~BasicStringDiskIndexer() {}

	void write(const std::string& file);
};


};

// vim:set ts=4 sw=4:
#endif
