package provide tag 0.1
#
# This defines a set of operations on tag type data files, all accessed
# through one master tag procedure.
#
# This will probably be rewritten as a loadable set of extensions.
#

#	tag open <filename>

#	tag getheader

#	tag getnext
#		returns a list, where each list item is a pair of values,
#		of the form {tagname value}
#		(or for multiline values the items are a triplet of the
#		form {tagname value endlabel}

#
#	tag readfile <filename>
#		returns a list, where each list item is a tag record as
#		above
#
#	tag readselected <filename> <list of tests>
#		reads a file and returns all those entries which match the
#		<list of tests> in a similar maner to doing a
#		'tag readfile' followed by a 'tag extract'
#
#	tag writehtml dlist <filehandle> <taglist> [options]
#		write the taglist to the specified file (appending to it)
#		a list of html elements as a definition list
#
#	tag writehtml tlist <filenhandle> <taglist> [options]
#		write the taglist to the file as two column tables, the
#		first column being the values, and the second being the
#		valuse
#
#	tag writehtml table <filehandle> <taglist> [options]
#		write the taglist to the spedified file (appending to it)
#		as a table. The columns of the table are given by the
#		-fields <fieldslist>  option
#
#	tag sort <list of tagrecords> <fieldname> [options]
#		return a list of tagrecords, sorted in order of the value
#		of fieldname. It tekes the same options as the lsort command
#


proc tag { action args } {


if { $action == "readfile" } {
 set result {}
 if { ! [file readable [lindex $args 0]]} {
	return $result
	}
 set f [open [lindex $args 0]]
 # ought to check that it opened OK - if not then return an empty list
 
# This is not the most efficient way to do it - read the whole file into
# a single variable - then split up that variable - but will work on
# reading it in chunks later
while { ![eof $f]} {
 set tagbuf [read $f]  

}
 close $f
set finished 0

set thisentry {}
while { [string length $tagbuf] >0 } {
  set tagendlabel ""
  set tagindex [ string first : $tagbuf ]
#  puts "tagindex is $tagindex"
  incr tagindex -1
  set tagname [ string range $tagbuf 0 $tagindex ]
#  puts "tagname is $tagname"
  incr tagindex 2
  set tagbuf [string range $tagbuf $tagindex end ]
#  puts "tagbuf is now $tagbuf"
  if { [string index $tagbuf 0] == ":" } {
    set tagindex [string first \n $tagbuf ]
    incr tagindex -1
    set tagendlabel [string trimleft [ string range $tagbuf 1 $tagindex ]]
#   puts "tagendlabel is $tagendlabel"
    incr tagindex 2
    set tagbuf [string range $tagbuf $tagindex end]
#    puts "Tagbuf (ML) is $tagbuf"
    set tagindex [string first "$tagendlabel\n" $tagbuf]
#    puts "tagindex is $tagindex"
    incr tagindex -2
    set tagvalue [string range $tagbuf 0 $tagindex]
#    puts "tagvalue is $tagvalue"
    incr tagindex 2
    incr tagindex [string length $tagendlabel]
    set tagbuf [string range $tagbuf $tagindex end ]
  set tagbuf [string trimleft $tagbuf]
#  puts "tagbuf is now $tagbuf"

    } else {
  set tagindex [ string first \n  $tagbuf ]
  incr tagindex -1
#  puts "tagindex is $tagindex"
  set tagvalue [string range $tagbuf 0 $tagindex ]
  set tagvalue [string trimleft $tagvalue]
#  puts "tagvalue is $tagvalue"
  incr tagindex 2
  set tagbuf [string range $tagbuf $tagindex end ]
  set tagbuf [string trimleft $tagbuf]
#  puts "tagbuf is now $tagbuf"
  }

# We now have a tagname and value pair - append them to thisentry
  set thispair [list $tagname $tagvalue]
# if there is an endlabel then we ought to append it to thispair
  if { $tagendlabel != "" } {
     lappend thispair $tagendlabel
  }
# puts "thispair is $thispair"
 if {[llength $thisentry] == 0 } {
  set thisentry [list $thispair]
  } else {
#  set thisentry [list  $thisentry $thispair]
   lappend thisentry $thispair
  }
#  puts "thisentry is $thisentry"
 # if the tagname is End then we should append thisentry to the result and
 # clear it
 if {$tagname == "End"} {
   if {[llength $result] == 0 } {
	set result [list $thisentry]
	} else {
	lappend result $thisentry
	}
#   puts "result is $result"
   set thisentry {}
  }

}

return $result

} elseif { $action == "writefile" } {
#
# Write out a whole file 'tag writefile filename list [mode]'
#
set filename [lindex $args 0]
set tlist [lindex $args 1]

set mode [lindex $args 2]
if {$mode == ""} {set mode w}

# puts "tag writefile $filename $tlist"

set f [open $filename $mode]

foreach entry $tlist {
 # the entry should be a list of tag-value pairs (except multiline which have
 # a third element, which is the delimiter
 foreach item $entry {
   set tagname [lindex $item 0]
   set tagvalue [lindex $item 1]
   if {[llength $item] == 3 } {
      set delimiter [lindex $item 2]
	puts $f "${tagname}:: $delimiter"
	puts $f $tagvalue
	puts $f $delimiter
	} else {
      puts $f "$tagname: $tagvalue"
	}
   }
 }
close $f

} elseif { $action == "writeentry" } {
# tag writeentry filechannel entry
#
set f [lindex $args 0]
set entry [lindex $args 1]
 foreach item $entry {
   set tagname [lindex $item 0]
   set tagvalue [lindex $item 1]
   if {[llength $item] == 3 } {
      set delimiter [lindex $item 2]
	puts $f "${tagname}:: $delimiter"
	puts $f $tagvalue
	puts $f $delimiter
	} else {
      puts $f "$tagname: $tagvalue"
	}
 }

} elseif { $action == "matchcond" } {
# Take a single tag entry and return 1 if it matches the criteria or 0 if not
#

set entry [lindex $args 0 ]
set test [lindex $args 1]

foreach item $entry {
 set tagname [lindex $item 0]
 set tagvalue [lindex $item 1]

  set testlabel [lindex $test 0]
  set testop [lindex $test 1]

  if { $testop == "=="} {
    set testvalue [lindex $test 2]
    if { (($testlabel == $tagname) && ($tagvalue == $testvalue ))} {
	return 1
    }
   } elseif { $testop == "!="} {
     set testvalue [lindex $test 2]
    if { (($testlabel == $tagname) && ($tagvalue != $testvalue ))} {
	return 1
	}
   } elseif { $testop == "<="} {
     set testvalue [lindex $test 2]
    if { (($testlabel == $tagname) && ($tagvalue <= $testvalue ))} {
	return 1
	}
   } elseif { $testop == "-in"} {
   # return true if the tagvalue is a member of the list given as the testvalue
      if { $testlabel == $tagname } {
      set testvalue [lindex $test 2]
        foreach listval $testvalue {
		if { $tagvalue == $listval } {
			return 1
		}
	}
	}
   } elseif { $testop == "-contains"} {
   # return true if the tagvalue contains the string given as a testvalue
	if { $testlabel == $tagname } {
	set testvalue [lindex $test 2]
	if { [string match -nocase  *$testvalue* $tagvalue] } {
		return 1
		}
	}
   } elseif { $testop == "-later" } {
	if { $testlabel == $tagname } {
	set testvalue [lindex $test 2]
	if { [clock scan $tagvalue] > [clock scan $testvalue] } {
		return 1
		}
	}
   } elseif {  $testop == "-earlier" } {
	if { $testlabel == $tagname } {
        set testvalue [lindex $test 2]
	if  { [clock scan $tagvalue] < [clock scan $testvalue] } {
                return 1
                }
        }
   } elseif { $testop == "-datebetween"} {
   # return true if the tagvalue (which must be a date) is between the *two*
   #  dates given as testvalues
	if { $testlabel == $tagname } {
	set startdate [lindex $test 2]
	set enddate [lindex $test 3]
	error "Not yet implemented"	


	}
   } elseif { $testop == "-exists"} {
   # return true if the testlabel is found in the current record
#   puts "Exists - checking to see if testlabel $testlabel = tagname $tagname"
   if { $testlabel == $tagname } {
     return 1
   }

   } else {
     error "Invalid operator $testop in tag matchcond"
   }

 }
# We never found what we were looking for
return 0

} elseif { $action == "matchall" } {
# does a tag item match *all* the criteria in a list

set entry [lindex $args 0 ]
set criteria [lindex $args 1]

foreach test $criteria {
   if { ! [ tag matchcond $entry $test ]} {
#       puts "matchall found that $entry did not match $test - returning 0"
	return 0
	}
}
# puts "matchall found that all the criteria matched - returning 1"
   return 1

} elseif { $action == "matchany" } {
# does a tag item match *any* of the creteria in a list of conditions

set entry [lindex $args 0 ]
set criteria [lindex $args 1]

foreach test $criteria {
   if { [ tag matchcond $entry $test ]} {
        return 1
	}
}
return 0


} elseif { $action == "extract" } {
# Takes a list of tag items and returns those which match the criteria in
# the selection list
# i.e. tag extract list list-of-criteria
# where list of criteria is a list of lists of the form { label op [value] }
#

set tlist [lindex $args 0]
set criteria [lindex $args 1]

foreach entry $tlist {

 
 if { [ tag matchall $entry $criteria ] } {
	lappend result $entry
	}
}
if { [info exists result] } {
return $result	
} else {
  return {}
}

} elseif { $action == "replace" } {
# Returns a new value for the entry - call as
#  tag replace entryvar name newvalue
set entryvar [lindex $args 0 ]
set name [lindex $args 1 ]
set newvalue [lindex $args 2 ]

upvar $entryvar entry

set i 0
foreach item $entry {
 set tagname [lindex $item 0]
 set tagvalue [lindex $item 1]
 if { $name == $tagname } {
	set newitem [list $tagname $newvalue]
	set entry [ lreplace $entry $i $i $newitem ]
	return 0
     }
 incr i
}
 error "No tag named $name in $entry to replace" 

} elseif {$action == "setorreplace" } {
# tag setorreplace entryvar name newvalue
set entryvar [lindex $args 0 ]
set name [lindex $args 1 ]
set newvalue [lindex $args 2 ]

upvar $entryvar entry

set i 0
foreach item $entry {
 set tagname [lindex $item 0]
 set tagvalue [lindex $item 1]
 if { $name == $tagname } {
        set newitem [list $tagname $newvalue]
        set entry [ lreplace $entry $i $i $newitem ]
        return 0
     }
 incr i
}
# we got here and we did not find the tag we wanted - add it to the end
 set newitem [list $name $newvalue]
 set len [llength $entry]
 incr len -1
 set entry [linsert $entry $len $newitem]
 return 0

} elseif { $action == "update" } {
#
#  tag update filename replacement_entry id_field
#
#  Read a tagged file until we come across one where the id_field in the
#  replacement_entry matches that in the file, replace that entry with
# the replacement - if no match then the file is unchanged. It always
# copies to a file named after the input file with a .tmp suffix, which is
# renamed to the original if the replacemnt succeeds
#
# For now use readfile to read in the whole lot - and not use a temp file

 set filename [lindex $args 0]
 set replacementEntry [lindex $args 1]
 set idField [lindex $args 2]

 foreach item $replacementEntry {
   set tagname [lindex $item 0]
   set tagvalue [lindex $item 1]
   if { $tagname == $idField } {
     set idvalue $tagvalue
     }
   }
  
 set tmplist [tag readfile $filename]
 set test [list $idField "==" $idvalue]

set f [open $filename w]
 foreach entry $tmplist {
   if [tag matchcond $entry $test] {
     tag writeentry $f $replacementEntry
   } else {
    tag writeentry $f $entry
  } 
 }
 close $f

} elseif { $action == "readselected" } {

#	tag readselected <filename> <list of tests>
#		reads a file and returns all those entries which match the
#		<list of tests> in a similar maner to doing a
#		'tag readfile' followed by a 'tag extract'
#
# For now we can implement it exactly like that
 set tmplist [tag readfile [lindex $args 0]]
 return [tag extract $tmplist [lindex $args 1]]

} elseif { $action == "writehtml" } {
 set isurlcall ""
 set fieldslist ""
 set hformat [lindex $args 0]
 set f [lindex $args 1]
 set taglist [lindex $args 2]
 
 set n 3
 while { $n < [llength $args] } {
# for now should only be one optional argument - really ned to do this better
  if { [lindex $args $n] == "-isurlcall"} {
	incr n
	set isurlcall [lindex $args $n]
	incr n
     } elseif { [lindex $args $n] == "-fields" } {
       incr n
       set fieldslist [lindex $args $n]
	incr n

  } else {
    error "unknown option [lindex $args $n]"
  }

  }

 if { $hformat == "dlist" } {

 foreach entry $taglist {
  puts $f "<dl id=\"taglist\">"
  foreach item $entry {
  set delimiter ""
  set tagname [lindex $item 0]
  set tagvalue [lindex $item 1]
  if { $tagname != "End" } {
    puts $f "<dt id=\"tagname\">$tagname<dd id=\"tagvalue\">"
    if { [llength $item] == 3 } {
     puts $f "<pre>$tagvalue\n</pre>" 
    } else {
     # only worry about URLs on single lines
     if { $isurlcall != "" } {
	set isurl [$isurlcall $tagname $tagvalue]
	if { $isurl } {
		puts $f "<a href=$tagvalue>$tagvalue</a>"
	} else {
		puts $f "$tagvalue"
		}
	} else {
     puts $f "$tagvalue"
	}
    }
  }
  }
 puts $f "</dl>"
 puts $f "<hr>"
}

} elseif { $hformat == "table" } {




 } else {
  error "bad argument to'tag writehtml' expected dlist or table"
 }

} elseif { $action == "sort" } {
set tags [lindex $args 0]
set indexfield [lindex $args 1]

set listops [lrange $args 2 end] 

# create a temporary list consisting of the values of the sort elements

for { set i 0 } { $i < [llength $tags] } { incr i} {

set entry [lindex $tags $i]

set l [list $i {}]
if { [lsearch $listops "-integer"] >=0 } {
 # Need to make the default value an integer if we do an integer sort
 set l [list $i 0]
}

foreach item $entry {
  if { [lindex $item 0] == $indexfield } {
	set l [list $i [lindex $item 1]]
	break
	}

}
lappend sortlist $l

}

set listcmd [list lsort -index 1 $listops $sortlist]
set sortlist [eval $listcmd]
# work through the sortlist - appending values to the result

for { set i 0 } { $i < [llength $sortlist] } { incr i} {
 set te [lindex $tags [lindex [lindex $sortlist $i] 0 ]]
 lappend result $te

}
return $result

} else {
 error "Unknown first argument to tag - must be 'readfile' or 'writefile'"
}


}

